/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Avoid unnecessary boxing by using plain == for primitive types.", tags={"Performance"}, severity=BugPattern.SeverityLevel.WARNING)
public class ObjectEqualsForPrimitives
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticEqualsInvocation(), Matchers.argument((int)0, (Matcher)Matchers.isPrimitiveType()), Matchers.argument((int)1, (Matcher)Matchers.isPrimitiveType())});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String arg1 = state.getSourceForNode((Tree)tree.getArguments().get(0));
        String arg2 = state.getSourceForNode((Tree)tree.getArguments().get(1));
        SuggestedFix fix = SuggestedFix.builder().replace((Tree)tree, "(" + arg1 + " == " + arg2 + ")").build();
        return this.describeMatch(tree, (Fix)fix);
    }
}

