/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.app;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import com.zwitserloot.cmdreader.CmdReader;
import com.zwitserloot.cmdreader.Description;
import com.zwitserloot.cmdreader.FullName;
import com.zwitserloot.cmdreader.InvalidCommandLineException;
import com.zwitserloot.cmdreader.Mandatory;
import com.zwitserloot.cmdreader.Sequential;
import com.zwitserloot.cmdreader.Shorthand;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import lombok.ast.Node;
import lombok.ast.Version;
import lombok.ast.app.EcjBugsNormalization;
import lombok.ast.ecj.EcjTreeBuilder;
import lombok.ast.ecj.EcjTreeConverter;
import lombok.ast.ecj.EcjTreeOperations;
import lombok.ast.ecj.EcjTreePrinter;
import lombok.ast.grammar.ParseProblem;
import lombok.ast.grammar.Source;
import lombok.ast.javac.JcTreeBuilder;
import lombok.ast.javac.JcTreeConverter;
import lombok.ast.javac.JcTreePrinter;
import lombok.ast.printer.HtmlFormatter;
import lombok.ast.printer.SourcePrinter;
import lombok.ast.printer.StructureFormatter;
import lombok.ast.printer.TextFormatter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.parboiled.google.collect.Lists;

public class Main {
    private final Charset charset;
    private List<Operation<Object, Object>> program;
    private final boolean verbose;
    private final boolean normalize;
    private final boolean positions;
    private final boolean saveIntermediate;
    private int errors;
    private File outDir = null;
    private final List<Plan> files = Lists.newArrayList();
    private final Operation<Void, Node> parseWithLombok = new Operation<Void, Node>(){

        @Override
        public Node process(Source in, Void irrelevant) throws ConversionProblem {
            List<Node> nodes = in.getNodes();
            List<ParseProblem> problems = in.getProblems();
            if (problems.size() > 0) {
                throw new ConversionProblem(String.format("Can't read file %s due to parse error: %s", in.getName(), problems.get(0)));
            }
            if (nodes.size() == 1) {
                return nodes.get(0);
            }
            if (nodes.size() == 0) {
                throw new ConversionProblem("No nodes parsed by lombok.ast");
            }
            throw new ConversionProblem("More than 1 node parsed by lombok.ast");
        }
    };
    private final Operation<Void, ASTNode> parseWithEcj = new Operation<Void, ASTNode>(){

        @Override
        public ASTNode process(Source in, Void irrelevant) throws ConversionProblem {
            CompilationResult compilationResult;
            CompilerOptions compilerOptions = Main.this.ecjCompilerOptions();
            Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (IProblemFactory)new DefaultProblemFactory()), compilerOptions.parseLiteralExpressionsAsConstants);
            parser.javadocParser.checkDocComment = true;
            CompilationUnit sourceUnit = new CompilationUnit(in.getRawInput().toCharArray(), in.getName(), Main.this.charset.name());
            CompilationUnitDeclaration cud = parser.parse((ICompilationUnit)sourceUnit, compilationResult = new CompilationResult((ICompilationUnit)sourceUnit, 0, 0, 0));
            if (cud.hasErrors()) {
                throw new ConversionProblem(String.format("Can't read file %s due to parse error: %s", in.getName(), compilationResult.getErrors()[0]));
            }
            return cud;
        }
    };
    private final Operation<Void, JCTree.JCCompilationUnit> parseWithJavac = new Operation<Void, JCTree.JCCompilationUnit>(){

        @Override
        public JCTree.JCCompilationUnit process(Source in, Void irrelevant) throws ConversionProblem {
            Context context = new Context();
            Options.instance(context).put(OptionName.ENCODING, Main.this.charset.name());
            JavaCompiler compiler = new JavaCompiler(context);
            compiler.genEndPos = true;
            compiler.keepComments = true;
            JCTree.JCCompilationUnit cu = compiler.parse(new ContentBasedJavaFileObject(in.getName(), in.getRawInput()));
            return cu;
        }
    };
    private final Operation<JCTree.JCCompilationUnit, Node> javacToLombok = new Operation<JCTree.JCCompilationUnit, Node>(){

        @Override
        public Node process(Source source, JCTree.JCCompilationUnit in) throws ConversionProblem {
            JcTreeConverter converter = new JcTreeConverter();
            converter.visit(in);
            return converter.getResult();
        }
    };
    private final Operation<CompilationUnitDeclaration, Node> ecjToLombok = new Operation<CompilationUnitDeclaration, Node>(){

        @Override
        public Node process(Source source, CompilationUnitDeclaration in) throws ConversionProblem {
            EcjTreeConverter converter = new EcjTreeConverter();
            converter.visit(source.getRawInput(), (ASTNode)in);
            return converter.get();
        }
    };
    private final Operation<Node, JCTree.JCCompilationUnit> lombokToJavac = new Operation<Node, JCTree.JCCompilationUnit>(){

        @Override
        public JCTree.JCCompilationUnit process(Source source, Node in) throws ConversionProblem {
            JcTreeBuilder builder = new JcTreeBuilder();
            builder.visit(in);
            JCTree out = builder.get();
            if (out instanceof JCTree.JCCompilationUnit) {
                return (JCTree.JCCompilationUnit)out;
            }
            throw new ConversionProblem("result from lombokToJavac is not JCCompilationUnit");
        }
    };
    private final Operation<Node, CompilationUnitDeclaration> lombokToEcj = new Operation<Node, CompilationUnitDeclaration>(){

        @Override
        public CompilationUnitDeclaration process(Source source, Node in) throws ConversionProblem {
            EcjTreeBuilder builder = new EcjTreeBuilder(source, Main.this.ecjCompilerOptions());
            builder.visit(in);
            ASTNode out = builder.get();
            if (out instanceof CompilationUnitDeclaration) {
                return (CompilationUnitDeclaration)out;
            }
            throw new ConversionProblem("result from lombokToEcj is not CompilationUnitDeclaration");
        }
    };
    private final Operation<Node, String> lombokToHtml = new Operation<Node, String>(){

        @Override
        public String process(Source source, Node in) throws ConversionProblem {
            HtmlFormatter formatter = new HtmlFormatter(source.getRawInput());
            in.accept(new SourcePrinter(formatter));
            for (ParseProblem x : source.getProblems()) {
                formatter.addError(x.getPosition().getStart(), x.getPosition().getEnd(), x.getMessage());
            }
            return formatter.finish();
        }
    };
    private final Operation<Node, String> lombokToSource = new Operation<Node, String>(){

        @Override
        public String process(Source source, Node in) throws ConversionProblem {
            TextFormatter formatter = new TextFormatter();
            in.accept(new SourcePrinter(formatter));
            for (ParseProblem x : source.getProblems()) {
                formatter.addError(x.getPosition().getStart(), x.getPosition().getEnd(), x.getMessage());
            }
            return formatter.finish();
        }
    };
    private final Operation<Node, String> lombokToText = new Operation<Node, String>(){

        @Override
        public String process(Source source, Node in) throws ConversionProblem {
            StructureFormatter formatter = Main.this.positions ? StructureFormatter.formatterWithPositions() : StructureFormatter.formatterWithoutPositions();
            in.accept(new SourcePrinter(formatter));
            for (ParseProblem x : source.getProblems()) {
                formatter.addError(x.getPosition().getStart(), x.getPosition().getEnd(), x.getMessage());
            }
            return formatter.finish();
        }
    };
    private final Operation<JCTree.JCCompilationUnit, String> javacToText = new Operation<JCTree.JCCompilationUnit, String>(){

        @Override
        public String process(Source source, JCTree.JCCompilationUnit in) throws ConversionProblem {
            JcTreePrinter printer = Main.this.positions ? JcTreePrinter.printerWithPositions() : JcTreePrinter.printerWithoutPositions();
            printer.visit(in);
            return printer.toString();
        }
    };
    private final Operation<CompilationUnitDeclaration, String> ecjToText = new Operation<CompilationUnitDeclaration, String>(){

        @Override
        public String process(Source source, CompilationUnitDeclaration in) throws ConversionProblem {
            if (Main.this.normalize) {
                return Main.this.positions ? EcjTreeOperations.convertToString((ASTNode)in) : EcjTreeOperations.convertToStringNoPositions((ASTNode)in);
            }
            EcjTreePrinter printer = Main.this.positions ? EcjTreePrinter.printerWithPositions() : EcjTreePrinter.printerWithoutPositions();
            printer.visit((ASTNode)in);
            return printer.getContent();
        }
    };
    private final Map<String, Operation<?, ?>> CONVERSIONS = ImmutableMap.builder().put((Object)"_,ecj", this.parseWithEcj).put((Object)"_,lombok", this.parseWithLombok).put((Object)"_,javac", this.parseWithJavac).put((Object)"javac,lombok", this.javacToLombok).put((Object)"lombok,javac", this.lombokToJavac).put((Object)"ecj,lombok", this.ecjToLombok).put((Object)"lombok,ecj", this.lombokToEcj).put((Object)"lombok,text", this.lombokToText).put((Object)"lombok,source", this.lombokToSource).put((Object)"lombok,html", this.lombokToHtml).put((Object)"ecj,text", this.ecjToText).put((Object)"javac,text", this.javacToText).build();
    private final Map<String, Operation<?, ?>> NORMALIZATION = ImmutableMap.builder().put((Object)"ecj:ecjbugs", EcjBugsNormalization.ecjToEcjBugsNormalizedEcj).put((Object)"lombok:ecjbugs", EcjBugsNormalization.lombokToEcjBugsNormalizedLombok).build();
    private final List<String> LEGAL_FINAL = ImmutableList.of((Object)"source", (Object)"html", (Object)"text");
    private final List<Operation<?, Node>> TO_LOMBOK = ImmutableList.of(this.ecjToLombok, this.javacToLombok, this.parseWithLombok);
    private final List<Operation<?, ? extends ASTNode>> TO_ECJ = ImmutableList.of(this.lombokToEcj, this.parseWithEcj);
    private final List<Operation<?, JCTree.JCCompilationUnit>> TO_JAVAC = ImmutableList.of(this.lombokToJavac, this.parseWithJavac);
    private final List<Operation<?, String>> TO_TEXT = ImmutableList.of(this.ecjToText, this.javacToText, this.lombokToText);

    public static void main(String[] rawArgs) throws Exception {
        CmdArgs args;
        CmdReader reader = CmdReader.of(CmdArgs.class);
        try {
            args = (CmdArgs)reader.make(rawArgs);
        }
        catch (InvalidCommandLineException e) {
            System.err.println(e.getMessage());
            System.err.println(reader.generateCommandLineHelp("java -jar lombok.ast.jar"));
            System.exit(1);
            return;
        }
        if (args.help) {
            System.out.println("lombok.ast java AST tool " + Version.getVersion());
            System.out.println(reader.generateCommandLineHelp("java -jar lombok.ast.jar"));
            System.exit(0);
            return;
        }
        if (args.version) {
            System.out.println(Version.getVersion());
            System.exit(0);
            return;
        }
        try {
            Charset charset = args.encoding == null ? Charset.defaultCharset() : Charset.forName(args.encoding);
            Main main = new Main(charset, args.verbose, args.normalize, !args.noPositions, args.saveIntermediate);
            main.compile(args.program);
            if (!args.print) {
                File targetDir = new File(args.target);
                if (!targetDir.exists()) {
                    targetDir.mkdirs();
                }
                if (!targetDir.isDirectory()) {
                    System.err.printf("%s is not a directory or cannot be created\n", targetDir.getCanonicalPath());
                    System.exit(1);
                    return;
                }
                main.setOutputDir(targetDir);
            }
            for (String input : args.input) {
                main.addToQueue(input);
            }
            main.go();
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
            return;
        }
    }

    private void go() throws IOException {
        for (Plan p : this.files) {
            this.process(p.getFile(), this.outDir, p.getRelativeName());
        }
        if (this.errors > 0) {
            System.err.printf("%d errors\n", this.errors);
        }
        System.exit(this.errors > 0 ? 2 : 0);
    }

    private void setOutputDir(File f) {
        this.outDir = f;
    }

    private void addToQueue(String item) throws IOException {
        this.addToQueue0(new File(item), "");
    }

    private void addToQueue0(File f, String pathSoFar) throws IOException {
        pathSoFar = pathSoFar + (pathSoFar.isEmpty() ? "" : "/") + f.getName();
        if (f.isFile()) {
            if (f.getName().endsWith(".java")) {
                this.files.add(new Plan(f, pathSoFar));
            }
        } else if (f.isDirectory()) {
            for (File inner : f.listFiles()) {
                this.addToQueue0(inner, pathSoFar);
            }
        } else {
            throw new IllegalArgumentException("Unknown file: " + f.getCanonicalPath());
        }
    }

    private void process(File in, File outDir, String relativeName) throws IOException {
        File out;
        File file = out = outDir == null ? null : new File(outDir, relativeName);
        if (this.verbose && !this.saveIntermediate) {
            System.out.printf("Processing: %s to %s\n", in.getCanonicalPath(), out == null ? "sysout" : out.getCanonicalPath());
        }
        Source source = new Source(Files.toString((File)in, (Charset)this.charset), in.getCanonicalPath());
        Object transfer = null;
        String chain = "/";
        try {
            for (Operation<Object, Object> programElem : this.program) {
                transfer = programElem.process(source, transfer);
                if (!this.saveIntermediate) continue;
                if (!"/".equals(chain)) {
                    chain = chain + "-";
                }
                chain = chain + this.getDestinationType(programElem);
                File intermediate = new File(outDir.getCanonicalPath() + chain + "/" + relativeName);
                intermediate.getParentFile().mkdirs();
                if (this.verbose) {
                    System.out.printf("Processing: %s to %s\n", in.getCanonicalPath(), intermediate.getCanonicalPath());
                }
                if (this.TO_JAVAC.contains(programElem)) {
                    Files.write((CharSequence)this.javacToText.process(source, (JCTree.JCCompilationUnit)transfer).toString(), (File)intermediate, (Charset)this.charset);
                    continue;
                }
                if (this.TO_ECJ.contains(programElem)) {
                    Files.write((CharSequence)this.ecjToText.process(source, (CompilationUnitDeclaration)transfer).toString(), (File)intermediate, (Charset)this.charset);
                    continue;
                }
                if (!this.TO_LOMBOK.contains(programElem)) continue;
                Files.write((CharSequence)this.lombokToText.process(source, (Node)transfer).toString(), (File)intermediate, (Charset)this.charset);
            }
            if (out == null) {
                System.out.println(transfer);
            } else if (!this.saveIntermediate) {
                out.getParentFile().mkdirs();
                Files.write((CharSequence)transfer.toString(), (File)out, (Charset)this.charset);
            }
        }
        catch (ConversionProblem cp) {
            System.err.printf("Can't convert: %s due to %s\n", in.getCanonicalPath(), cp.getMessage());
            ++this.errors;
        }
        catch (RuntimeException e) {
            System.err.printf("Error during convert: %s\n%s\n", in.getCanonicalPath(), Main.printEx(e));
            ++this.errors;
        }
    }

    private String getDestinationType(Operation<Object, Object> operation) {
        if (this.TO_LOMBOK.contains(operation)) {
            return "lombok";
        }
        if (this.TO_ECJ.contains(operation)) {
            return "ecj";
        }
        if (this.TO_JAVAC.contains(operation)) {
            return "javac";
        }
        if (this.TO_TEXT.contains(operation)) {
            return "text";
        }
        return null;
    }

    private static String printEx(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append(t.toString());
        sb.append("\n");
        Joiner.on((String)"\n").appendTo(sb, (Object[])t.getStackTrace());
        return sb.toString();
    }

    private void compile(String program) {
        this.program = this.compile0(program);
    }

    private List<ChainElement> toChainElements(String program) {
        ArrayList<ChainElement> out = new ArrayList<ChainElement>();
        for (String part : program.split("\\s*,\\s*")) {
            int idx = part.indexOf(58);
            if (idx == -1) {
                out.add(new ChainElement(part.trim(), ""));
                continue;
            }
            out.add(new ChainElement(part.substring(0, idx).trim(), part.substring(idx + 1).trim()));
        }
        return out;
    }

    private void addNormalization(List<Operation<Object, Object>> list, ChainElement element) {
        if (!element.hasSubtype()) {
            return;
        }
        Operation<?, ?> operation = this.NORMALIZATION.get(element.toString());
        if (operation == null) {
            ArrayList normalizations = Lists.newArrayList();
            for (String n : this.NORMALIZATION.keySet()) {
                if (!n.startsWith(element.getType() + ":")) continue;
                normalizations.add(n);
            }
            throw new IllegalArgumentException(String.format("Illegal normalization operation: %s. Valid normalizations: %s", element, Joiner.on((String)",").join((Iterable)normalizations)));
        }
        list.add(operation);
    }

    private List<Operation<Object, Object>> compile0(String program) {
        List<ChainElement> parts = this.toChainElements(program);
        ArrayList out = Lists.newArrayList();
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("No operations");
        }
        Operation<?, ?> initialOp = this.CONVERSIONS.get("_," + parts.get(0).getType());
        if (initialOp == null) {
            ArrayList initialOps = Lists.newArrayList();
            for (String key : this.CONVERSIONS.keySet()) {
                if (!key.startsWith("_,")) continue;
                initialOps.add(key.substring(2));
            }
            throw new IllegalArgumentException(String.format("Illegal initial operation: %s\nLegal initial operations: %s", parts.get(0), Joiner.on((String)",").join((Iterable)initialOps)));
        }
        out.add(initialOp);
        this.addNormalization(out, parts.get(0));
        for (int i = 0; i < parts.size() - 1; ++i) {
            String convKey = String.format("%s,%s", parts.get(i).getType(), parts.get(i + 1).getType());
            Operation<?, ?> convOp = this.CONVERSIONS.get(convKey);
            if (convOp == null) {
                ArrayList convOps = Lists.newArrayList();
                for (String key : this.CONVERSIONS.keySet()) {
                    if (!key.startsWith(parts.get(i).getType() + ",")) continue;
                    convOps.add(key.substring(parts.get(i).getType().length() + 1));
                }
                throw new IllegalArgumentException(String.format("Illegal conversion operation: %s\nLegal conversion operations from %s: %s", convKey, parts.get(i), Joiner.on((String)",").join((Iterable)convOps)));
            }
            out.add(convOp);
            this.addNormalization(out, parts.get(i + 1));
        }
        String lastPart = parts.get(parts.size() - 1).getType();
        if (!this.LEGAL_FINAL.contains(lastPart) && !this.saveIntermediate) {
            throw new IllegalArgumentException(String.format("Illegal final operation: %s\nLegal final operations: %s", lastPart, Joiner.on((String)",").join(this.LEGAL_FINAL)));
        }
        return out;
    }

    protected CompilerOptions ecjCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        options.complianceLevel = 0x320000L;
        options.sourceLevel = 0x320000L;
        options.targetJDK = 0x320000L;
        options.parseLiteralExpressionsAsConstants = true;
        return options;
    }

    private Main(Charset charset, boolean verbose, boolean normalize, boolean positions, boolean saveIntermediate) {
        this.charset = charset;
        this.verbose = verbose;
        this.normalize = normalize;
        this.positions = positions;
        this.saveIntermediate = saveIntermediate;
    }

    private static class ContentBasedJavaFileObject
    extends SimpleJavaFileObject {
        private final String content;

        public ContentBasedJavaFileObject(String name, String content) {
            super(new File(name).toURI(), JavaFileObject.Kind.SOURCE);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.content;
        }
    }

    static class ConversionProblem
    extends Exception {
        ConversionProblem(String message) {
            super(message);
        }
    }

    static interface Operation<A, B> {
        public B process(Source var1, A var2) throws ConversionProblem;
    }

    private static final class ChainElement {
        private final String type;
        private final String subtype;

        public String toString() {
            return this.subtype.length() == 0 ? this.type : String.format("%s:%s", this.type, this.subtype);
        }

        public boolean hasSubtype() {
            return this.subtype.length() > 0;
        }

        @ConstructorProperties(value={"type", "subtype"})
        public ChainElement(String type, String subtype) {
            this.type = type;
            this.subtype = subtype;
        }

        public String getType() {
            return this.type;
        }

        public String getSubtype() {
            return this.subtype;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChainElement)) {
                return false;
            }
            ChainElement other = (ChainElement)o;
            if (this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType())) {
                return false;
            }
            return !(this.getSubtype() == null ? other.getSubtype() != null : !this.getSubtype().equals(other.getSubtype()));
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = result * 31 + (this.getType() == null ? 0 : this.getType().hashCode());
            result = result * 31 + (this.getSubtype() == null ? 0 : this.getSubtype().hashCode());
            return result;
        }
    }

    private static class Plan {
        final File file;
        final String relativeName;

        @ConstructorProperties(value={"file", "relativeName"})
        public Plan(File file, String relativeName) {
            this.file = file;
            this.relativeName = relativeName;
        }

        public File getFile() {
            return this.file;
        }

        public String getRelativeName() {
            return this.relativeName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Plan)) {
                return false;
            }
            Plan other = (Plan)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFile() == null ? other.getFile() != null : !this.getFile().equals(other.getFile())) {
                return false;
            }
            return !(this.getRelativeName() == null ? other.getRelativeName() != null : !this.getRelativeName().equals(other.getRelativeName()));
        }

        public boolean canEqual(Object other) {
            return other instanceof Plan;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = result * 31 + (this.getFile() == null ? 0 : this.getFile().hashCode());
            result = result * 31 + (this.getRelativeName() == null ? 0 : this.getRelativeName().hashCode());
            return result;
        }

        public String toString() {
            return "Main.Plan(file=" + this.getFile() + ", relativeName=" + this.getRelativeName() + ")";
        }
    }

    private static class CmdArgs {
        @Shorthand(value={"v"})
        @Description(value="Print the name of each file as it is being converted.")
        private boolean verbose;
        @Description(value="Show version number and exit.")
        private boolean version;
        @Shorthand(value={"h"})
        @Description(value="Show this help text and exit.")
        private boolean help;
        @Shorthand(value={"e"})
        @Description(value="Sets the encoding of your source files. Defaults to the system default charset. Example: \"UTF-8\"")
        private String encoding;
        @Shorthand(value={"p"})
        @Description(value="Print converted code to standard output instead of saving it in target directory")
        private boolean print;
        @Shorthand(value={"d"})
        @Description(value="Directory to save converted files to")
        @Mandatory(onlyIfNot={"print", "help", "version"})
        private String target;
        @Shorthand(value={"i"})
        @Description(value="Save the result of each (intermediate) operation as 'text' representation. Do not use any text/source/html operations if you use this option.")
        @FullName(value="save-intermediate")
        private boolean saveIntermediate;
        @Shorthand(value={"z"})
        @Description(value="Normalize the way various different nodes are printed when using the structural printer ('text'), when these nodes are semantically identical")
        private boolean normalize;
        @Shorthand(value={"n"})
        @Description(value="Omit printing the start and end position of nodes for structural output")
        @FullName(value="no-positions")
        private boolean noPositions;
        @Mandatory(onlyIfNot={"help", "version"})
        @Sequential
        @Description(value="Operations to apply to each source file. Comma-separated (no spaces). Valid options: ecj/javac/lombok first to decide how the file is parsed initially, then any number of further ecj/javac/lombok keywords to convert ASTs, and finally text/source/html.")
        private String program;
        @Description(value="Files to convert. Provide either a file, or a directory. If you use a directory, all files in it (recursive) are converted")
        @Mandatory(onlyIfNot={"help", "version"})
        @Sequential
        private List<String> input = new ArrayList<String>();

        private CmdArgs() {
        }
    }
}

