# Copyright 2022 The Bazel Authors. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""A rule to generate a Python source file containing the main repo's
runfiles directory name."""

_RUNFILES_CONSTANTS_TEMPLATE = """# Generated by gen_runfiles_constants.bzl
# Internal-only; do no use.
# The name of the runfiles directory corresponding to the main repository.
MAIN_REPOSITORY_RUNFILES_DIRECTORY = '%s'
"""

def _gen_runfiles_constants_impl(ctx):
    out = ctx.actions.declare_file(ctx.attr.name + ".py")
    ctx.actions.write(out, _RUNFILES_CONSTANTS_TEMPLATE % ctx.workspace_name)

    return DefaultInfo(
        files = depset([out]),
        runfiles = ctx.runfiles([out]),
    )

gen_runfiles_constants = rule(
    implementation = _gen_runfiles_constants_impl,
)
