/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	"encoding/json"
)

// PostBucketRequest struct for PostBucketRequest
type PostBucketRequest struct {
	// The organization ID. Specifies the organization that owns the bucket.
	OrgID string `json:"orgID" yaml:"orgID"`
	// The bucket name.
	Name string `json:"name" yaml:"name"`
	// A description of the bucket.
	Description *string `json:"description,omitempty" yaml:"description,omitempty"`
	// The retention policy for the bucket. For InfluxDB 1.x, specifies the duration of time that each data point in the retention policy persists.  If you need compatibility with InfluxDB 1.x, specify a value for the `rp` property; otherwise, see the `retentionRules` property.  [Retention policy](https://docs.influxdata.com/influxdb/v1.8/concepts/glossary/#retention-policy-rp) is an InfluxDB 1.x concept. The InfluxDB 2.x and Cloud equivalent is [retention period]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#retention-period). The InfluxDB `/api/v2` API uses `RetentionRules` to configure the retention period.
	Rp *string `json:"rp,omitempty" yaml:"rp,omitempty"`
	// Retention rules to expire or retain data. The InfluxDB `/api/v2` API uses `RetentionRules` to configure the [retention period]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#retention-period).  #### InfluxDB Cloud  - `retentionRules` is required.  #### InfluxDB OSS  - `retentionRules` isn't required.
	RetentionRules *[]RetentionRule `json:"retentionRules,omitempty" yaml:"retentionRules,omitempty"`
	SchemaType     *SchemaType      `json:"schemaType,omitempty" yaml:"schemaType,omitempty"`
}

// NewPostBucketRequest instantiates a new PostBucketRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPostBucketRequest(orgID string, name string) *PostBucketRequest {
	this := PostBucketRequest{}
	this.OrgID = orgID
	this.Name = name
	var rp string = "0"
	this.Rp = &rp
	return &this
}

// NewPostBucketRequestWithDefaults instantiates a new PostBucketRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPostBucketRequestWithDefaults() *PostBucketRequest {
	this := PostBucketRequest{}
	var rp string = "0"
	this.Rp = &rp
	return &this
}

// GetOrgID returns the OrgID field value
func (o *PostBucketRequest) GetOrgID() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.OrgID
}

// GetOrgIDOk returns a tuple with the OrgID field value
// and a boolean to check if the value has been set.
func (o *PostBucketRequest) GetOrgIDOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.OrgID, true
}

// SetOrgID sets field value
func (o *PostBucketRequest) SetOrgID(v string) {
	o.OrgID = v
}

// GetName returns the Name field value
func (o *PostBucketRequest) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *PostBucketRequest) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *PostBucketRequest) SetName(v string) {
	o.Name = v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *PostBucketRequest) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PostBucketRequest) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *PostBucketRequest) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *PostBucketRequest) SetDescription(v string) {
	o.Description = &v
}

// GetRp returns the Rp field value if set, zero value otherwise.
func (o *PostBucketRequest) GetRp() string {
	if o == nil || o.Rp == nil {
		var ret string
		return ret
	}
	return *o.Rp
}

// GetRpOk returns a tuple with the Rp field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PostBucketRequest) GetRpOk() (*string, bool) {
	if o == nil || o.Rp == nil {
		return nil, false
	}
	return o.Rp, true
}

// HasRp returns a boolean if a field has been set.
func (o *PostBucketRequest) HasRp() bool {
	if o != nil && o.Rp != nil {
		return true
	}

	return false
}

// SetRp gets a reference to the given string and assigns it to the Rp field.
func (o *PostBucketRequest) SetRp(v string) {
	o.Rp = &v
}

// GetRetentionRules returns the RetentionRules field value if set, zero value otherwise.
func (o *PostBucketRequest) GetRetentionRules() []RetentionRule {
	if o == nil || o.RetentionRules == nil {
		var ret []RetentionRule
		return ret
	}
	return *o.RetentionRules
}

// GetRetentionRulesOk returns a tuple with the RetentionRules field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PostBucketRequest) GetRetentionRulesOk() (*[]RetentionRule, bool) {
	if o == nil || o.RetentionRules == nil {
		return nil, false
	}
	return o.RetentionRules, true
}

// HasRetentionRules returns a boolean if a field has been set.
func (o *PostBucketRequest) HasRetentionRules() bool {
	if o != nil && o.RetentionRules != nil {
		return true
	}

	return false
}

// SetRetentionRules gets a reference to the given []RetentionRule and assigns it to the RetentionRules field.
func (o *PostBucketRequest) SetRetentionRules(v []RetentionRule) {
	o.RetentionRules = &v
}

// GetSchemaType returns the SchemaType field value if set, zero value otherwise.
func (o *PostBucketRequest) GetSchemaType() SchemaType {
	if o == nil || o.SchemaType == nil {
		var ret SchemaType
		return ret
	}
	return *o.SchemaType
}

// GetSchemaTypeOk returns a tuple with the SchemaType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PostBucketRequest) GetSchemaTypeOk() (*SchemaType, bool) {
	if o == nil || o.SchemaType == nil {
		return nil, false
	}
	return o.SchemaType, true
}

// HasSchemaType returns a boolean if a field has been set.
func (o *PostBucketRequest) HasSchemaType() bool {
	if o != nil && o.SchemaType != nil {
		return true
	}

	return false
}

// SetSchemaType gets a reference to the given SchemaType and assigns it to the SchemaType field.
func (o *PostBucketRequest) SetSchemaType(v SchemaType) {
	o.SchemaType = &v
}

func (o PostBucketRequest) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["orgID"] = o.OrgID
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Rp != nil {
		toSerialize["rp"] = o.Rp
	}
	if o.RetentionRules != nil {
		toSerialize["retentionRules"] = o.RetentionRules
	}
	if o.SchemaType != nil {
		toSerialize["schemaType"] = o.SchemaType
	}
	return json.Marshal(toSerialize)
}

type NullablePostBucketRequest struct {
	value *PostBucketRequest
	isSet bool
}

func (v NullablePostBucketRequest) Get() *PostBucketRequest {
	return v.value
}

func (v *NullablePostBucketRequest) Set(val *PostBucketRequest) {
	v.value = val
	v.isSet = true
}

func (v NullablePostBucketRequest) IsSet() bool {
	return v.isSet
}

func (v *NullablePostBucketRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePostBucketRequest(val *PostBucketRequest) *NullablePostBucketRequest {
	return &NullablePostBucketRequest{value: val, isSet: true}
}

func (v NullablePostBucketRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePostBucketRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
