/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.newmerge;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.help.DefaultHelpModel;
import javax.help.HelpBroker;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.JHelpIndexNavigator;
import javax.help.JHelpNavigator;
import javax.help.JHelpSearchNavigator;
import javax.help.JHelpTOCNavigator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import sunw.demo.newmerge.HSFilter;
import sunw.demo.newmerge.JarAccessory;

public class Merge {
    private JFrame viewFrame = null;
    private JHelpTOCNavigator masterTOC;
    private JHelpTOCNavigator slaveTOC;
    private JHelpIndexNavigator masterIndex;
    private JHelpIndexNavigator slaveIndex;
    private JHelpSearchNavigator masterSearch;
    private JHelpSearchNavigator slaveSearch;
    private String masterTitle;
    private String slaveTitle;
    private JLabel masterTOCLabel;
    private JLabel masterIndexLabel;
    private JLabel slaveTOCLabel;
    private JLabel slaveIndexLabel;
    final JFileChooser hsChooser = new JFileChooser();
    private JarAccessory jarAccessory;
    private HSFilter hsFilter;
    private JFrame frame;
    private Stack slaveSets = new Stack();
    private Stack slaveCopySets = new Stack();
    final JMenuItem removeItem = new JMenuItem("Remove");
    final JMenuItem msItem = new JMenuItem("Master and Slave");
    private JMenuItem helpItem;
    private HelpModel helpModel;
    private HelpSet masterHelpSet;
    private HelpSet slaveHelpSet;
    private HelpSet masterHSCopy;
    private HelpSet slaveHSCopy;
    private ClassLoader loader;
    private URL masterHsURL;
    private URL slaveHsURL;
    private JHelp help;
    private JHelp slaveHelp;
    private JHelp masterHelpCopy;
    private JHelp slaveHelpCopy;
    private HelpBroker helpBroker;

    public Merge(String string) {
        this.hsFilter = new HSFilter();
        this.hsChooser.setFileFilter(this.hsFilter);
        this.jarAccessory = new JarAccessory(this.hsChooser);
        this.hsChooser.setAccessory(this.jarAccessory);
        this.loader = this.getClass().getClassLoader();
        this.masterHsURL = HelpSet.findHelpSet(this.loader, string);
        try {
            this.masterHelpSet = new HelpSet(this.loader, this.masterHsURL);
            this.masterHSCopy = new HelpSet(this.loader, this.masterHsURL);
        }
        catch (HelpSetException helpSetException) {
            System.out.println(helpSetException);
        }
        this.masterTitle = this.masterHSCopy.getTitle();
        this.masterTOCLabel = new JLabel(this.masterTitle, 0);
        this.masterIndexLabel = new JLabel(this.masterTitle, 0);
        JHelp jHelp = new JHelp(this.masterHelpSet);
        this.masterHelpCopy = new JHelp(this.masterHSCopy);
        this.setupMasterNavigators(this.masterHelpCopy);
        this.frame = new JFrame("help");
        JPanel jPanel = new JPanel(new GridLayout());
        jPanel.add(jHelp);
        this.frame.setContentPane(jPanel);
        jHelp.setNavigatorDisplayed(true);
        this.frame.setJMenuBar(this.createMenu());
        this.frame.pack();
        this.frame.setLocation(this.computeCenter(this.frame));
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public JMenuBar createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('f');
        JMenu jMenu2 = new JMenu("HelpSet");
        jMenu2.setMnemonic('s');
        JMenu jMenu3 = new JMenu("View");
        jMenu3.setMnemonic('v');
        JMenu jMenu4 = new JMenu("Help");
        jMenu4.setMnemonic('h');
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic('e');
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.msItem.setMnemonic('m');
        this.msItem.setEnabled(false);
        this.msItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Merge.this.viewFrame.setVisible(true);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Add");
        jMenuItem2.setMnemonic('a');
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Merge.this.hsChooser.showOpenDialog(Merge.this.frame);
                if (n == 0) {
                    if (!Merge.this.slaveCopySets.empty()) {
                        Merge.this.masterHSCopy.add((HelpSet)Merge.this.slaveCopySets.peek());
                    }
                    Merge.this.handleFile();
                    Merge.this.setSlaveCopy((HelpSet)Merge.this.slaveCopySets.peek());
                }
                if (!Merge.this.slaveSets.empty()) {
                    Merge.this.removeItem.setEnabled(true);
                    Merge.this.msItem.setEnabled(true);
                }
            }
        });
        this.removeItem.setMnemonic('r');
        this.removeItem.setEnabled(false);
        this.removeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Merge.this.masterHelpSet.remove((HelpSet)Merge.this.slaveSets.pop());
                Merge.this.removeSetFromView();
                Merge.this.jarAccessory.removeFromModel();
                if (Merge.this.slaveSets.empty()) {
                    Merge.this.removeItem.setEnabled(false);
                    Merge.this.msItem.setEnabled(false);
                }
            }
        });
        this.helpItem = new JMenuItem("Contents");
        this.helpItem.setMnemonic('c');
        this.initHelp();
        jMenu4.add(this.helpItem);
        jMenu2.add(jMenuItem2);
        jMenu2.add(this.removeItem);
        jMenu3.add(this.msItem);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        return jMenuBar;
    }

    public void view() {
        if (this.viewFrame == null) {
            this.viewFrame = new JFrame("Master and Slave view");
        } else {
            this.viewFrame.setVisible(false);
            this.viewFrame = new JFrame("Master and Slave view");
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.viewFrame.getContentPane().add(jTabbedPane);
        jTabbedPane.addTab("TOC", this.createTOCPane());
        jTabbedPane.addTab("Index", this.createIndexPane());
        jTabbedPane.addTab("Search", this.createSearchPane());
        this.viewFrame.pack();
        this.viewFrame.setLocation(this.computeCenter(this.viewFrame));
        this.viewFrame.setVisible(false);
        this.msItem.setEnabled(false);
        this.viewFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Merge.this.viewFrame.setVisible(false);
                Merge.this.msItem.setEnabled(true);
            }
        });
    }

    public void setSlaveCopy(HelpSet helpSet) {
        DefaultHelpModel defaultHelpModel = new DefaultHelpModel(helpSet);
        try {
            this.slaveTOC.setModel(defaultHelpModel);
            this.slaveIndex.setModel(defaultHelpModel);
            this.slaveSearch.setModel(defaultHelpModel);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void removeSetFromView() {
        HelpSet helpSet;
        block6: {
            this.slaveCopySets.pop();
            Object var1_1 = null;
            helpSet = null;
            try {
                helpSet = (HelpSet)this.slaveCopySets.lastElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (this.viewFrame == null) break block6;
                this.viewFrame.setVisible(false);
            }
        }
        if (helpSet != null) {
            DefaultHelpModel defaultHelpModel = new DefaultHelpModel(helpSet);
            this.slaveTOC.setModel(defaultHelpModel);
            this.slaveIndex.setModel(defaultHelpModel);
            this.slaveSearch.setModel(defaultHelpModel);
        } else if (this.viewFrame != null) {
            this.viewFrame.setVisible(false);
        }
        if (this.slaveCopySets.size() > 0) {
            this.masterHSCopy.remove((HelpSet)this.slaveCopySets.peek());
        }
    }

    public Component createTOCPane() {
        JSplitPane jSplitPane = new JSplitPane(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Master", 0), "North");
        jPanel.add((Component)this.masterTOC, "Center");
        jPanel.setPreferredSize(new Dimension(200, 400));
        jSplitPane.setLeftComponent(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel("Slave", 0), "North");
        jPanel2.add((Component)this.slaveTOC, "Center");
        jPanel2.setPreferredSize(new Dimension(200, 400));
        jSplitPane.setRightComponent(jPanel2);
        jSplitPane.resetToPreferredSizes();
        return jSplitPane;
    }

    public Component createIndexPane() {
        JSplitPane jSplitPane = new JSplitPane(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Master", 0), "North");
        jPanel.add((Component)this.masterIndex, "Center");
        jSplitPane.setLeftComponent(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel("Slave", 0), "North");
        jPanel2.add((Component)this.slaveIndex, "Center");
        jSplitPane.setRightComponent(jPanel2);
        return jSplitPane;
    }

    public Component createSearchPane() {
        JSplitPane jSplitPane = new JSplitPane(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Master", 0), "North");
        jPanel.add((Component)this.masterSearch, "Center");
        jSplitPane.setLeftComponent(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel("Slave", 0), "North");
        jPanel2.add((Component)this.slaveSearch, "Center");
        jSplitPane.setRightComponent(jPanel2);
        return jSplitPane;
    }

    public void setupMasterNavigators(JHelp jHelp) {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        Enumeration enumeration = jHelp.getHelpNavigators();
        try {
            clazz = Class.forName("javax.help.JHelpTOCNavigator");
            clazz2 = Class.forName("javax.help.JHelpIndexNavigator");
            clazz3 = Class.forName("javax.help.JHelpSearchNavigator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            System.exit(1);
        }
        while (enumeration.hasMoreElements()) {
            JHelpNavigator jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
            if (clazz.isInstance(jHelpNavigator)) {
                try {
                    this.masterTOC = (JHelpTOCNavigator)jHelpNavigator;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
                continue;
            }
            if (clazz2.isInstance(jHelpNavigator)) {
                try {
                    this.masterIndex = (JHelpIndexNavigator)jHelpNavigator;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
                continue;
            }
            if (!clazz3.isInstance(jHelpNavigator)) continue;
            try {
                this.masterSearch = (JHelpSearchNavigator)jHelpNavigator;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    public void setupSlaveNavigators(JHelp jHelp) {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        Class<?> clazz3 = null;
        Enumeration enumeration = jHelp.getHelpNavigators();
        try {
            clazz = Class.forName("javax.help.JHelpTOCNavigator");
            clazz2 = Class.forName("javax.help.JHelpIndexNavigator");
            clazz3 = Class.forName("javax.help.JHelpSearchNavigator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            System.exit(1);
        }
        while (enumeration.hasMoreElements()) {
            JHelpNavigator jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
            if (clazz.isInstance(jHelpNavigator)) {
                try {
                    this.slaveTOC = (JHelpTOCNavigator)jHelpNavigator;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
                continue;
            }
            if (clazz2.isInstance(jHelpNavigator)) {
                try {
                    this.slaveIndex = (JHelpIndexNavigator)jHelpNavigator;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
                continue;
            }
            if (!clazz3.isInstance(jHelpNavigator)) continue;
            try {
                this.slaveSearch = (JHelpSearchNavigator)jHelpNavigator;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    public boolean handleFile() {
        File file = this.hsChooser.getSelectedFile();
        String string = file.getAbsolutePath();
        if (string.endsWith(".jar")) {
            String string2 = this.jarAccessory.getName();
            try {
                URL uRL = new URL("file:" + string);
                URL[] uRLArray = new URL[]{uRL};
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, this.loader);
                this.slaveHsURL = HelpSet.findHelpSet(uRLClassLoader, string2);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(malformedURLException);
            }
        } else {
            try {
                this.slaveHsURL = new URL("file:" + string);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(malformedURLException);
            }
        }
        try {
            this.slaveHelpSet = new HelpSet(this.loader, this.slaveHsURL);
            this.slaveSets.push(this.slaveHelpSet);
            this.slaveTitle = this.slaveHelpSet.getTitle();
            this.slaveTOCLabel = new JLabel(this.slaveTitle, 0);
            this.slaveIndexLabel = new JLabel(this.slaveTitle, 0);
            this.slaveHSCopy = new HelpSet(this.loader, this.slaveHsURL);
            this.slaveCopySets.push(this.slaveHSCopy);
            this.slaveHelp = new JHelp(this.slaveHelpSet);
            this.slaveHelpCopy = new JHelp(this.slaveHSCopy);
            this.masterHelpSet.add(this.slaveHelpSet);
            if (this.slaveTOC == null || this.slaveIndex == null) {
                this.setupSlaveNavigators(this.slaveHelpCopy);
            }
        }
        catch (HelpSetException helpSetException) {
            System.err.println(helpSetException);
        }
        if (this.slaveSets.size() == 1) {
            this.view();
        }
        return true;
    }

    public Point computeCenter(JFrame jFrame) {
        Toolkit toolkit = jFrame.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        double d = dimension.getWidth() / 2.0 - dimension2.getWidth() / 2.0;
        double d2 = dimension.getHeight() / 2.0 - dimension2.getHeight() / 2.0;
        return new Point((int)d, (int)d2);
    }

    public void initHelp() {
        HelpSet helpSet = null;
        try {
            helpSet = new HelpSet(this.loader, HelpSet.findHelpSet(this.loader, "MergeHelp"));
        }
        catch (HelpSetException helpSetException) {
            System.out.println(helpSetException);
        }
        this.helpBroker = helpSet.createHelpBroker();
        this.helpBroker.enableHelpKey(this.frame.getRootPane(), "intro", helpSet);
        this.helpBroker.enableHelpOnButton(this.helpItem, "intro", helpSet);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            new Merge(stringArray[0]);
        } else {
            new Merge("Animals");
        }
    }
}

