/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.searchdemo;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.help.search.SearchEngine;
import javax.help.search.SearchQuery;
import sunw.demo.searchdemo.ClientSearchQuery;
import sunw.demo.searchdemo.DocVector;
import sunw.demo.searchdemo.WordVector;

public class ClientSearchEngine
extends SearchEngine {
    private WordVector wordVec;
    private DocVector docVec;
    public static int AND = 1;
    public static int OR = 2;
    public static int NOT = 3;
    public static int NEAR = 4;
    public static int LEFT_PAREN = 5;
    public static int RIGHT_PAREN = 6;
    public static int ADJ = 7;
    private static boolean debugFlag = false;

    public ClientSearchEngine(URL uRL, Hashtable hashtable) {
        super(uRL, hashtable);
        ClientSearchEngine.debug("Loading Search Database");
        try {
            String string = (String)hashtable.get("data");
            ClientSearchEngine.debug("base=" + uRL.toExternalForm());
            ClientSearchEngine.debug("urldata=" + string);
            URL uRL2 = new URL(uRL, string + ".inv");
            ClientSearchEngine.debug("url: " + uRL2);
            URLConnection uRLConnection = uRL2.openConnection();
            uRLConnection.setAllowUserInteraction(true);
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            this.wordVec = new WordVector(dataInputStream);
            uRL2 = new URL(uRL, string + ".dat");
            ClientSearchEngine.debug("url: " + uRL2);
            uRLConnection = uRL2.openConnection();
            uRLConnection.setAllowUserInteraction(true);
            dataInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            this.docVec = new DocVector(dataInputStream);
            ClientSearchEngine.debug("Search Database loaded");
        }
        catch (Exception exception) {
            this.wordVec = null;
            this.docVec = null;
            ClientSearchEngine.debug("Failed to load Search DataBase");
            exception.printStackTrace();
        }
    }

    public SearchQuery createQuery() {
        return new ClientSearchQuery(this);
    }

    public WordVector getWordVector() {
        return this.wordVec;
    }

    public DocVector getDocVector() {
        return this.docVec;
    }

    public URL getBase() {
        return this.base;
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("ClientSearchEngine: " + string);
        }
    }
}

