// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/certificatemanager/v1/certificate_manager.proto

package certificatemanager

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines set of serving states associated with a resource.
type ServingState int32

const (
	// The status is undefined.
	ServingState_SERVING_STATE_UNSPECIFIED ServingState = 0
	// The configuration is serving.
	ServingState_ACTIVE ServingState = 1
	// Update is in progress. Some frontends may serve this configuration.
	ServingState_PENDING ServingState = 2
)

// Enum value maps for ServingState.
var (
	ServingState_name = map[int32]string{
		0: "SERVING_STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "PENDING",
	}
	ServingState_value = map[string]int32{
		"SERVING_STATE_UNSPECIFIED": 0,
		"ACTIVE":                    1,
		"PENDING":                   2,
	}
)

func (x ServingState) Enum() *ServingState {
	p := new(ServingState)
	*p = x
	return p
}

func (x ServingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[0].Descriptor()
}

func (ServingState) Type() protoreflect.EnumType {
	return &file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[0]
}

func (x ServingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServingState.Descriptor instead.
func (ServingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{0}
}

// Certificate scope.
type Certificate_Scope int32

const (
	// Certificates with default scope are served from core Google data centers.
	// If unsure, choose this option.
	Certificate_DEFAULT Certificate_Scope = 0
	// Certificates with scope EDGE_CACHE are special-purposed certificates,
	// served from non-core Google data centers.
	Certificate_EDGE_CACHE Certificate_Scope = 1
)

// Enum value maps for Certificate_Scope.
var (
	Certificate_Scope_name = map[int32]string{
		0: "DEFAULT",
		1: "EDGE_CACHE",
	}
	Certificate_Scope_value = map[string]int32{
		"DEFAULT":    0,
		"EDGE_CACHE": 1,
	}
)

func (x Certificate_Scope) Enum() *Certificate_Scope {
	p := new(Certificate_Scope)
	*p = x
	return p
}

func (x Certificate_Scope) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Certificate_Scope) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[1].Descriptor()
}

func (Certificate_Scope) Type() protoreflect.EnumType {
	return &file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[1]
}

func (x Certificate_Scope) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Certificate_Scope.Descriptor instead.
func (Certificate_Scope) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25, 0}
}

type Certificate_ManagedCertificate_State int32

const (
	Certificate_ManagedCertificate_STATE_UNSPECIFIED Certificate_ManagedCertificate_State = 0
	// Certificate Manager attempts to provision or renew the certificate.
	// If the process takes longer than expected, consult the
	// `provisioning_issue` field.
	Certificate_ManagedCertificate_PROVISIONING Certificate_ManagedCertificate_State = 1
	// Multiple certificate provisioning attempts failed and Certificate
	// Manager gave up. To try again, delete and create a new managed
	// Certificate resource.
	// For details see the `provisioning_issue` field.
	Certificate_ManagedCertificate_FAILED Certificate_ManagedCertificate_State = 2
	// The certificate management is working, and a certificate has been
	// provisioned.
	Certificate_ManagedCertificate_ACTIVE Certificate_ManagedCertificate_State = 3
)

// Enum value maps for Certificate_ManagedCertificate_State.
var (
	Certificate_ManagedCertificate_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		2: "FAILED",
		3: "ACTIVE",
	}
	Certificate_ManagedCertificate_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONING":      1,
		"FAILED":            2,
		"ACTIVE":            3,
	}
)

func (x Certificate_ManagedCertificate_State) Enum() *Certificate_ManagedCertificate_State {
	p := new(Certificate_ManagedCertificate_State)
	*p = x
	return p
}

func (x Certificate_ManagedCertificate_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Certificate_ManagedCertificate_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[2].Descriptor()
}

func (Certificate_ManagedCertificate_State) Type() protoreflect.EnumType {
	return &file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[2]
}

func (x Certificate_ManagedCertificate_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Certificate_ManagedCertificate_State.Descriptor instead.
func (Certificate_ManagedCertificate_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25, 1, 0}
}

type Certificate_ManagedCertificate_ProvisioningIssue_Reason int32

const (
	Certificate_ManagedCertificate_ProvisioningIssue_REASON_UNSPECIFIED Certificate_ManagedCertificate_ProvisioningIssue_Reason = 0
	// Certificate provisioning failed due to an issue with one or more of
	// the domains on the certificate.
	// For details of which domains failed, consult the
	// `authorization_attempt_info` field.
	Certificate_ManagedCertificate_ProvisioningIssue_AUTHORIZATION_ISSUE Certificate_ManagedCertificate_ProvisioningIssue_Reason = 1
	// Exceeded Certificate Authority quotas or internal rate limits of the
	// system. Provisioning may take longer to complete.
	Certificate_ManagedCertificate_ProvisioningIssue_RATE_LIMITED Certificate_ManagedCertificate_ProvisioningIssue_Reason = 2
)

// Enum value maps for Certificate_ManagedCertificate_ProvisioningIssue_Reason.
var (
	Certificate_ManagedCertificate_ProvisioningIssue_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "AUTHORIZATION_ISSUE",
		2: "RATE_LIMITED",
	}
	Certificate_ManagedCertificate_ProvisioningIssue_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":  0,
		"AUTHORIZATION_ISSUE": 1,
		"RATE_LIMITED":        2,
	}
)

func (x Certificate_ManagedCertificate_ProvisioningIssue_Reason) Enum() *Certificate_ManagedCertificate_ProvisioningIssue_Reason {
	p := new(Certificate_ManagedCertificate_ProvisioningIssue_Reason)
	*p = x
	return p
}

func (x Certificate_ManagedCertificate_ProvisioningIssue_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Certificate_ManagedCertificate_ProvisioningIssue_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[3].Descriptor()
}

func (Certificate_ManagedCertificate_ProvisioningIssue_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[3]
}

func (x Certificate_ManagedCertificate_ProvisioningIssue_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Certificate_ManagedCertificate_ProvisioningIssue_Reason.Descriptor instead.
func (Certificate_ManagedCertificate_ProvisioningIssue_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25, 1, 0, 0}
}

type Certificate_ManagedCertificate_AuthorizationAttemptInfo_State int32

const (
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_STATE_UNSPECIFIED Certificate_ManagedCertificate_AuthorizationAttemptInfo_State = 0
	// Certificate provisioning for this domain is under way. GCP will
	// attempt to authorize the domain.
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_AUTHORIZING Certificate_ManagedCertificate_AuthorizationAttemptInfo_State = 1
	// A managed certificate can be provisioned, no issues for this domain.
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_AUTHORIZED Certificate_ManagedCertificate_AuthorizationAttemptInfo_State = 6
	// Attempt to authorize the domain failed. This prevents the Managed
	// Certificate from being issued.
	// See `failure_reason` and `details` fields for more information.
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_FAILED Certificate_ManagedCertificate_AuthorizationAttemptInfo_State = 7
)

// Enum value maps for Certificate_ManagedCertificate_AuthorizationAttemptInfo_State.
var (
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "AUTHORIZING",
		6: "AUTHORIZED",
		7: "FAILED",
	}
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"AUTHORIZING":       1,
		"AUTHORIZED":        6,
		"FAILED":            7,
	}
)

func (x Certificate_ManagedCertificate_AuthorizationAttemptInfo_State) Enum() *Certificate_ManagedCertificate_AuthorizationAttemptInfo_State {
	p := new(Certificate_ManagedCertificate_AuthorizationAttemptInfo_State)
	*p = x
	return p
}

func (x Certificate_ManagedCertificate_AuthorizationAttemptInfo_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Certificate_ManagedCertificate_AuthorizationAttemptInfo_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[4].Descriptor()
}

func (Certificate_ManagedCertificate_AuthorizationAttemptInfo_State) Type() protoreflect.EnumType {
	return &file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[4]
}

func (x Certificate_ManagedCertificate_AuthorizationAttemptInfo_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Certificate_ManagedCertificate_AuthorizationAttemptInfo_State.Descriptor instead.
func (Certificate_ManagedCertificate_AuthorizationAttemptInfo_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25, 1, 1, 0}
}

type Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason int32

const (
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_FAILURE_REASON_UNSPECIFIED Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason = 0
	// There was a problem with the user's DNS or load balancer
	// configuration for this domain.
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_CONFIG Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason = 1
	// Certificate issuance forbidden by an explicit CAA record for the
	// domain or a failure to check CAA records for the domain.
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_CAA Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason = 2
	// Reached a CA or internal rate-limit for the domain,
	// e.g. for certificates per top-level private domain.
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_RATE_LIMITED Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason = 3
)

// Enum value maps for Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason.
var (
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason_name = map[int32]string{
		0: "FAILURE_REASON_UNSPECIFIED",
		1: "CONFIG",
		2: "CAA",
		3: "RATE_LIMITED",
	}
	Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason_value = map[string]int32{
		"FAILURE_REASON_UNSPECIFIED": 0,
		"CONFIG":                     1,
		"CAA":                        2,
		"RATE_LIMITED":               3,
	}
)

func (x Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason) Enum() *Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason {
	p := new(Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason)
	*p = x
	return p
}

func (x Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[5].Descriptor()
}

func (Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason) Type() protoreflect.EnumType {
	return &file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[5]
}

func (x Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason.Descriptor instead.
func (Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25, 1, 1, 1}
}

// Defines predefined cases other than SNI-hostname match when this
// configuration should be applied.
type CertificateMapEntry_Matcher int32

const (
	// A matcher has't been recognized.
	CertificateMapEntry_MATCHER_UNSPECIFIED CertificateMapEntry_Matcher = 0
	// A primary certificate that is served when SNI wasn't specified in the
	// request or SNI couldn't be found in the map.
	CertificateMapEntry_PRIMARY CertificateMapEntry_Matcher = 1
)

// Enum value maps for CertificateMapEntry_Matcher.
var (
	CertificateMapEntry_Matcher_name = map[int32]string{
		0: "MATCHER_UNSPECIFIED",
		1: "PRIMARY",
	}
	CertificateMapEntry_Matcher_value = map[string]int32{
		"MATCHER_UNSPECIFIED": 0,
		"PRIMARY":             1,
	}
)

func (x CertificateMapEntry_Matcher) Enum() *CertificateMapEntry_Matcher {
	p := new(CertificateMapEntry_Matcher)
	*p = x
	return p
}

func (x CertificateMapEntry_Matcher) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateMapEntry_Matcher) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[6].Descriptor()
}

func (CertificateMapEntry_Matcher) Type() protoreflect.EnumType {
	return &file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes[6]
}

func (x CertificateMapEntry_Matcher) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateMapEntry_Matcher.Descriptor instead.
func (CertificateMapEntry_Matcher) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{27, 0}
}

// Request for the `ListCertificates` method.
type ListCertificatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the certificate should be listed,
	// specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of certificates to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListCertificatesResponse`. Indicates that
	// this is a continuation of a prior `ListCertificates` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the Certificates returned.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// A list of Certificate field names used to specify the order of the returned
	// results. The default sorting order is ascending. To specify descending
	// order for a field, add a suffix " desc".
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCertificatesRequest) Reset() {
	*x = ListCertificatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCertificatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCertificatesRequest) ProtoMessage() {}

func (x *ListCertificatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCertificatesRequest.ProtoReflect.Descriptor instead.
func (*ListCertificatesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{0}
}

func (x *ListCertificatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCertificatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCertificatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCertificatesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCertificatesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for the `ListCertificates` method.
type ListCertificatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of certificates for the parent resource.
	Certificates []*Certificate `protobuf:"bytes,1,rep,name=certificates,proto3" json:"certificates,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// A list of locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCertificatesResponse) Reset() {
	*x = ListCertificatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCertificatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCertificatesResponse) ProtoMessage() {}

func (x *ListCertificatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCertificatesResponse.ProtoReflect.Descriptor instead.
func (*ListCertificatesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{1}
}

func (x *ListCertificatesResponse) GetCertificates() []*Certificate {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *ListCertificatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCertificatesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `GetCertificate` method.
type GetCertificateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the certificate to describe. Must be in the format
	// `projects/*/locations/*/certificates/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCertificateRequest) Reset() {
	*x = GetCertificateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCertificateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCertificateRequest) ProtoMessage() {}

func (x *GetCertificateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCertificateRequest.ProtoReflect.Descriptor instead.
func (*GetCertificateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{2}
}

func (x *GetCertificateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CreateCertificate` method.
type CreateCertificateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the certificate. Must be in the format
	// `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A user-provided name of the certificate.
	CertificateId string `protobuf:"bytes,2,opt,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
	// Required. A definition of the certificate to create.
	Certificate *Certificate `protobuf:"bytes,3,opt,name=certificate,proto3" json:"certificate,omitempty"`
}

func (x *CreateCertificateRequest) Reset() {
	*x = CreateCertificateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCertificateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCertificateRequest) ProtoMessage() {}

func (x *CreateCertificateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCertificateRequest.ProtoReflect.Descriptor instead.
func (*CreateCertificateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{3}
}

func (x *CreateCertificateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCertificateRequest) GetCertificateId() string {
	if x != nil {
		return x.CertificateId
	}
	return ""
}

func (x *CreateCertificateRequest) GetCertificate() *Certificate {
	if x != nil {
		return x.Certificate
	}
	return nil
}

// Request for the `UpdateCertificate` method.
type UpdateCertificateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A definition of the certificate to update.
	Certificate *Certificate `protobuf:"bytes,1,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// Required. The update mask applies to the resource. For the `FieldMask` definition,
	// see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCertificateRequest) Reset() {
	*x = UpdateCertificateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCertificateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCertificateRequest) ProtoMessage() {}

func (x *UpdateCertificateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCertificateRequest.ProtoReflect.Descriptor instead.
func (*UpdateCertificateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateCertificateRequest) GetCertificate() *Certificate {
	if x != nil {
		return x.Certificate
	}
	return nil
}

func (x *UpdateCertificateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `DeleteCertificate` method.
type DeleteCertificateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the certificate to delete. Must be in the format
	// `projects/*/locations/*/certificates/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCertificateRequest) Reset() {
	*x = DeleteCertificateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCertificateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCertificateRequest) ProtoMessage() {}

func (x *DeleteCertificateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCertificateRequest.ProtoReflect.Descriptor instead.
func (*DeleteCertificateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteCertificateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `ListCertificateMaps` method.
type ListCertificateMapsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the certificate maps should be listed,
	// specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of certificate maps to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListCertificateMapsResponse`. Indicates
	// that this is a continuation of a prior `ListCertificateMaps` call, and that
	// the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the Certificates Maps returned.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// A list of Certificate Map field names used to specify the order of the
	// returned results. The default sorting order is ascending. To specify
	// descending order for a field, add a suffix " desc".
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCertificateMapsRequest) Reset() {
	*x = ListCertificateMapsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCertificateMapsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCertificateMapsRequest) ProtoMessage() {}

func (x *ListCertificateMapsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCertificateMapsRequest.ProtoReflect.Descriptor instead.
func (*ListCertificateMapsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{6}
}

func (x *ListCertificateMapsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCertificateMapsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCertificateMapsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCertificateMapsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCertificateMapsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for the `ListCertificateMaps` method.
type ListCertificateMapsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of certificate maps for the parent resource.
	CertificateMaps []*CertificateMap `protobuf:"bytes,1,rep,name=certificate_maps,json=certificateMaps,proto3" json:"certificate_maps,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCertificateMapsResponse) Reset() {
	*x = ListCertificateMapsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCertificateMapsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCertificateMapsResponse) ProtoMessage() {}

func (x *ListCertificateMapsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCertificateMapsResponse.ProtoReflect.Descriptor instead.
func (*ListCertificateMapsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{7}
}

func (x *ListCertificateMapsResponse) GetCertificateMaps() []*CertificateMap {
	if x != nil {
		return x.CertificateMaps
	}
	return nil
}

func (x *ListCertificateMapsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCertificateMapsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `GetCertificateMap` method.
type GetCertificateMapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the certificate map to describe. Must be in the format
	// `projects/*/locations/*/certificateMaps/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCertificateMapRequest) Reset() {
	*x = GetCertificateMapRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCertificateMapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCertificateMapRequest) ProtoMessage() {}

func (x *GetCertificateMapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCertificateMapRequest.ProtoReflect.Descriptor instead.
func (*GetCertificateMapRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{8}
}

func (x *GetCertificateMapRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CreateCertificateMap` method.
type CreateCertificateMapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the certificate map. Must be in the format
	// `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A user-provided name of the certificate map.
	CertificateMapId string `protobuf:"bytes,2,opt,name=certificate_map_id,json=certificateMapId,proto3" json:"certificate_map_id,omitempty"`
	// Required. A definition of the certificate map to create.
	CertificateMap *CertificateMap `protobuf:"bytes,3,opt,name=certificate_map,json=certificateMap,proto3" json:"certificate_map,omitempty"`
}

func (x *CreateCertificateMapRequest) Reset() {
	*x = CreateCertificateMapRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCertificateMapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCertificateMapRequest) ProtoMessage() {}

func (x *CreateCertificateMapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCertificateMapRequest.ProtoReflect.Descriptor instead.
func (*CreateCertificateMapRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{9}
}

func (x *CreateCertificateMapRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCertificateMapRequest) GetCertificateMapId() string {
	if x != nil {
		return x.CertificateMapId
	}
	return ""
}

func (x *CreateCertificateMapRequest) GetCertificateMap() *CertificateMap {
	if x != nil {
		return x.CertificateMap
	}
	return nil
}

// Request for the `UpdateCertificateMap` method.
type UpdateCertificateMapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A definition of the certificate map to update.
	CertificateMap *CertificateMap `protobuf:"bytes,1,opt,name=certificate_map,json=certificateMap,proto3" json:"certificate_map,omitempty"`
	// Required. The update mask applies to the resource. For the `FieldMask` definition,
	// see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCertificateMapRequest) Reset() {
	*x = UpdateCertificateMapRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCertificateMapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCertificateMapRequest) ProtoMessage() {}

func (x *UpdateCertificateMapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCertificateMapRequest.ProtoReflect.Descriptor instead.
func (*UpdateCertificateMapRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateCertificateMapRequest) GetCertificateMap() *CertificateMap {
	if x != nil {
		return x.CertificateMap
	}
	return nil
}

func (x *UpdateCertificateMapRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `DeleteCertificateMap` method.
type DeleteCertificateMapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the certificate map to delete. Must be in the format
	// `projects/*/locations/*/certificateMaps/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCertificateMapRequest) Reset() {
	*x = DeleteCertificateMapRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCertificateMapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCertificateMapRequest) ProtoMessage() {}

func (x *DeleteCertificateMapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCertificateMapRequest.ProtoReflect.Descriptor instead.
func (*DeleteCertificateMapRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteCertificateMapRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `ListCertificateMapEntries` method.
type ListCertificateMapEntriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project, location and certificate map from which the certificate map
	// entries should be listed, specified in the format
	// `projects/*/locations/*/certificateMaps/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of certificate map entries to return. The service may return
	// fewer than this value.
	// If unspecified, at most 50 certificate map entries will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListCertificateMapEntriesResponse`.
	// Indicates that this is a continuation of a prior
	// `ListCertificateMapEntries` call, and that the system should return the
	// next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the returned Certificate Map Entries.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// A list of Certificate Map Entry field names used to specify
	// the order of the returned results. The default sorting order is ascending.
	// To specify descending order for a field, add a suffix " desc".
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCertificateMapEntriesRequest) Reset() {
	*x = ListCertificateMapEntriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCertificateMapEntriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCertificateMapEntriesRequest) ProtoMessage() {}

func (x *ListCertificateMapEntriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCertificateMapEntriesRequest.ProtoReflect.Descriptor instead.
func (*ListCertificateMapEntriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{12}
}

func (x *ListCertificateMapEntriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCertificateMapEntriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCertificateMapEntriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCertificateMapEntriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCertificateMapEntriesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for the `ListCertificateMapEntries` method.
type ListCertificateMapEntriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of certificate map entries for the parent resource.
	CertificateMapEntries []*CertificateMapEntry `protobuf:"bytes,1,rep,name=certificate_map_entries,json=certificateMapEntries,proto3" json:"certificate_map_entries,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCertificateMapEntriesResponse) Reset() {
	*x = ListCertificateMapEntriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCertificateMapEntriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCertificateMapEntriesResponse) ProtoMessage() {}

func (x *ListCertificateMapEntriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCertificateMapEntriesResponse.ProtoReflect.Descriptor instead.
func (*ListCertificateMapEntriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{13}
}

func (x *ListCertificateMapEntriesResponse) GetCertificateMapEntries() []*CertificateMapEntry {
	if x != nil {
		return x.CertificateMapEntries
	}
	return nil
}

func (x *ListCertificateMapEntriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCertificateMapEntriesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `GetCertificateMapEntry` method.
type GetCertificateMapEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the certificate map entry to describe. Must be in the
	// format `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCertificateMapEntryRequest) Reset() {
	*x = GetCertificateMapEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCertificateMapEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCertificateMapEntryRequest) ProtoMessage() {}

func (x *GetCertificateMapEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCertificateMapEntryRequest.ProtoReflect.Descriptor instead.
func (*GetCertificateMapEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{14}
}

func (x *GetCertificateMapEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CreateCertificateMapEntry` method.
type CreateCertificateMapEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the certificate map entry. Must be in the
	// format `projects/*/locations/*/certificateMaps/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A user-provided name of the certificate map entry.
	CertificateMapEntryId string `protobuf:"bytes,2,opt,name=certificate_map_entry_id,json=certificateMapEntryId,proto3" json:"certificate_map_entry_id,omitempty"`
	// Required. A definition of the certificate map entry to create.
	CertificateMapEntry *CertificateMapEntry `protobuf:"bytes,3,opt,name=certificate_map_entry,json=certificateMapEntry,proto3" json:"certificate_map_entry,omitempty"`
}

func (x *CreateCertificateMapEntryRequest) Reset() {
	*x = CreateCertificateMapEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCertificateMapEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCertificateMapEntryRequest) ProtoMessage() {}

func (x *CreateCertificateMapEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCertificateMapEntryRequest.ProtoReflect.Descriptor instead.
func (*CreateCertificateMapEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{15}
}

func (x *CreateCertificateMapEntryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCertificateMapEntryRequest) GetCertificateMapEntryId() string {
	if x != nil {
		return x.CertificateMapEntryId
	}
	return ""
}

func (x *CreateCertificateMapEntryRequest) GetCertificateMapEntry() *CertificateMapEntry {
	if x != nil {
		return x.CertificateMapEntry
	}
	return nil
}

// Request for the `UpdateCertificateMapEntry` method.
type UpdateCertificateMapEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A definition of the certificate map entry to create map entry.
	CertificateMapEntry *CertificateMapEntry `protobuf:"bytes,1,opt,name=certificate_map_entry,json=certificateMapEntry,proto3" json:"certificate_map_entry,omitempty"`
	// Required. The update mask applies to the resource. For the `FieldMask` definition,
	// see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCertificateMapEntryRequest) Reset() {
	*x = UpdateCertificateMapEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCertificateMapEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCertificateMapEntryRequest) ProtoMessage() {}

func (x *UpdateCertificateMapEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCertificateMapEntryRequest.ProtoReflect.Descriptor instead.
func (*UpdateCertificateMapEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateCertificateMapEntryRequest) GetCertificateMapEntry() *CertificateMapEntry {
	if x != nil {
		return x.CertificateMapEntry
	}
	return nil
}

func (x *UpdateCertificateMapEntryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `DeleteCertificateMapEntry` method.
type DeleteCertificateMapEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the certificate map entry to delete. Must be in the format
	// `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCertificateMapEntryRequest) Reset() {
	*x = DeleteCertificateMapEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCertificateMapEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCertificateMapEntryRequest) ProtoMessage() {}

func (x *DeleteCertificateMapEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCertificateMapEntryRequest.ProtoReflect.Descriptor instead.
func (*DeleteCertificateMapEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteCertificateMapEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `ListDnsAuthorizations` method.
type ListDnsAuthorizationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the dns authorizations should be
	// listed, specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of dns authorizations to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListDnsAuthorizationsResponse`. Indicates
	// that this is a continuation of a prior `ListDnsAuthorizations` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the Dns Authorizations returned.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// A list of Dns Authorization field names used to specify the order of the
	// returned results. The default sorting order is ascending. To specify
	// descending order for a field, add a suffix " desc".
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDnsAuthorizationsRequest) Reset() {
	*x = ListDnsAuthorizationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDnsAuthorizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDnsAuthorizationsRequest) ProtoMessage() {}

func (x *ListDnsAuthorizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDnsAuthorizationsRequest.ProtoReflect.Descriptor instead.
func (*ListDnsAuthorizationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{18}
}

func (x *ListDnsAuthorizationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDnsAuthorizationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDnsAuthorizationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDnsAuthorizationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDnsAuthorizationsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for the `ListDnsAuthorizations` method.
type ListDnsAuthorizationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of dns authorizations for the parent resource.
	DnsAuthorizations []*DnsAuthorization `protobuf:"bytes,1,rep,name=dns_authorizations,json=dnsAuthorizations,proto3" json:"dns_authorizations,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDnsAuthorizationsResponse) Reset() {
	*x = ListDnsAuthorizationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDnsAuthorizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDnsAuthorizationsResponse) ProtoMessage() {}

func (x *ListDnsAuthorizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDnsAuthorizationsResponse.ProtoReflect.Descriptor instead.
func (*ListDnsAuthorizationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{19}
}

func (x *ListDnsAuthorizationsResponse) GetDnsAuthorizations() []*DnsAuthorization {
	if x != nil {
		return x.DnsAuthorizations
	}
	return nil
}

func (x *ListDnsAuthorizationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDnsAuthorizationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `GetDnsAuthorization` method.
type GetDnsAuthorizationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the dns authorization to describe. Must be in the format
	// `projects/*/locations/*/dnsAuthorizations/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDnsAuthorizationRequest) Reset() {
	*x = GetDnsAuthorizationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDnsAuthorizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDnsAuthorizationRequest) ProtoMessage() {}

func (x *GetDnsAuthorizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDnsAuthorizationRequest.ProtoReflect.Descriptor instead.
func (*GetDnsAuthorizationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{20}
}

func (x *GetDnsAuthorizationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CreateDnsAuthorization` method.
type CreateDnsAuthorizationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the dns authorization. Must be in the format
	// `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A user-provided name of the dns authorization.
	DnsAuthorizationId string `protobuf:"bytes,2,opt,name=dns_authorization_id,json=dnsAuthorizationId,proto3" json:"dns_authorization_id,omitempty"`
	// Required. A definition of the dns authorization to create.
	DnsAuthorization *DnsAuthorization `protobuf:"bytes,3,opt,name=dns_authorization,json=dnsAuthorization,proto3" json:"dns_authorization,omitempty"`
}

func (x *CreateDnsAuthorizationRequest) Reset() {
	*x = CreateDnsAuthorizationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDnsAuthorizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDnsAuthorizationRequest) ProtoMessage() {}

func (x *CreateDnsAuthorizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDnsAuthorizationRequest.ProtoReflect.Descriptor instead.
func (*CreateDnsAuthorizationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{21}
}

func (x *CreateDnsAuthorizationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDnsAuthorizationRequest) GetDnsAuthorizationId() string {
	if x != nil {
		return x.DnsAuthorizationId
	}
	return ""
}

func (x *CreateDnsAuthorizationRequest) GetDnsAuthorization() *DnsAuthorization {
	if x != nil {
		return x.DnsAuthorization
	}
	return nil
}

// Request for the `UpdateDnsAuthorization` method.
type UpdateDnsAuthorizationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A definition of the dns authorization to update.
	DnsAuthorization *DnsAuthorization `protobuf:"bytes,1,opt,name=dns_authorization,json=dnsAuthorization,proto3" json:"dns_authorization,omitempty"`
	// Required. The update mask applies to the resource. For the `FieldMask` definition,
	// see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDnsAuthorizationRequest) Reset() {
	*x = UpdateDnsAuthorizationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDnsAuthorizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDnsAuthorizationRequest) ProtoMessage() {}

func (x *UpdateDnsAuthorizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDnsAuthorizationRequest.ProtoReflect.Descriptor instead.
func (*UpdateDnsAuthorizationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateDnsAuthorizationRequest) GetDnsAuthorization() *DnsAuthorization {
	if x != nil {
		return x.DnsAuthorization
	}
	return nil
}

func (x *UpdateDnsAuthorizationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `DeleteDnsAuthorization` method.
type DeleteDnsAuthorizationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the dns authorization to delete. Must be in the format
	// `projects/*/locations/*/dnsAuthorizations/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDnsAuthorizationRequest) Reset() {
	*x = DeleteDnsAuthorizationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDnsAuthorizationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDnsAuthorizationRequest) ProtoMessage() {}

func (x *DeleteDnsAuthorizationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDnsAuthorizationRequest.ProtoReflect.Descriptor instead.
func (*DeleteDnsAuthorizationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{23}
}

func (x *DeleteDnsAuthorizationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the metadata of the long-running operation. Output only.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{24}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Defines TLS certificate.
type Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-defined name of the certificate. Certificate names must be unique
	// globally and match pattern `projects/*/locations/*/certificates/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// One or more paragraphs of text description of a certificate.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The creation timestamp of a Certificate.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of a Certificate.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Set of labels associated with a Certificate.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Types that are assignable to Type:
	//	*Certificate_SelfManaged
	//	*Certificate_Managed
	Type isCertificate_Type `protobuf_oneof:"type"`
	// Output only. The list of Subject Alternative Names of dnsName type defined in the
	// certificate (see RFC 5280 4.2.1.6).
	// Managed certificates that haven't been provisioned yet have this field
	// populated with a value of the managed.domains field.
	SanDnsnames []string `protobuf:"bytes,6,rep,name=san_dnsnames,json=sanDnsnames,proto3" json:"san_dnsnames,omitempty"`
	// Output only. The PEM-encoded certificate chain.
	PemCertificate string `protobuf:"bytes,9,opt,name=pem_certificate,json=pemCertificate,proto3" json:"pem_certificate,omitempty"`
	// Output only. The expiry timestamp of a Certificate.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Immutable. The scope of the certificate.
	Scope Certificate_Scope `protobuf:"varint,12,opt,name=scope,proto3,enum=google.cloud.certificatemanager.v1.Certificate_Scope" json:"scope,omitempty"`
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25}
}

func (x *Certificate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Certificate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Certificate) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Certificate) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Certificate) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (m *Certificate) GetType() isCertificate_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Certificate) GetSelfManaged() *Certificate_SelfManagedCertificate {
	if x, ok := x.GetType().(*Certificate_SelfManaged); ok {
		return x.SelfManaged
	}
	return nil
}

func (x *Certificate) GetManaged() *Certificate_ManagedCertificate {
	if x, ok := x.GetType().(*Certificate_Managed); ok {
		return x.Managed
	}
	return nil
}

func (x *Certificate) GetSanDnsnames() []string {
	if x != nil {
		return x.SanDnsnames
	}
	return nil
}

func (x *Certificate) GetPemCertificate() string {
	if x != nil {
		return x.PemCertificate
	}
	return ""
}

func (x *Certificate) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Certificate) GetScope() Certificate_Scope {
	if x != nil {
		return x.Scope
	}
	return Certificate_DEFAULT
}

type isCertificate_Type interface {
	isCertificate_Type()
}

type Certificate_SelfManaged struct {
	// If set, defines data of a self-managed certificate.
	SelfManaged *Certificate_SelfManagedCertificate `protobuf:"bytes,5,opt,name=self_managed,json=selfManaged,proto3,oneof"`
}

type Certificate_Managed struct {
	// If set, contains configuration and state of a managed certificate.
	Managed *Certificate_ManagedCertificate `protobuf:"bytes,11,opt,name=managed,proto3,oneof"`
}

func (*Certificate_SelfManaged) isCertificate_Type() {}

func (*Certificate_Managed) isCertificate_Type() {}

// Defines a collection of certificate configurations.
type CertificateMap struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-defined name of the Certificate Map. Certificate Map names must be
	// unique globally and match pattern
	// `projects/*/locations/*/certificateMaps/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// One or more paragraphs of text description of a certificate map.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The creation timestamp of a Certificate Map.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update timestamp of a Certificate Map.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Set of labels associated with a Certificate Map.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. A list of GCLB targets which use this Certificate Map.
	GclbTargets []*CertificateMap_GclbTarget `protobuf:"bytes,4,rep,name=gclb_targets,json=gclbTargets,proto3" json:"gclb_targets,omitempty"`
}

func (x *CertificateMap) Reset() {
	*x = CertificateMap{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateMap) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateMap) ProtoMessage() {}

func (x *CertificateMap) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateMap.ProtoReflect.Descriptor instead.
func (*CertificateMap) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{26}
}

func (x *CertificateMap) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CertificateMap) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CertificateMap) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CertificateMap) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CertificateMap) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CertificateMap) GetGclbTargets() []*CertificateMap_GclbTarget {
	if x != nil {
		return x.GclbTargets
	}
	return nil
}

// Defines a certificate map entry.
type CertificateMapEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-defined name of the Certificate Map Entry. Certificate Map Entry
	// names must be unique globally and match pattern
	// `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// One or more paragraphs of text description of a certificate map entry.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The creation timestamp of a Certificate Map Entry.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update timestamp of a Certificate Map Entry.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Set of labels associated with a Certificate Map Entry.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Types that are assignable to Match:
	//	*CertificateMapEntry_Hostname
	//	*CertificateMapEntry_Matcher_
	Match isCertificateMapEntry_Match `protobuf_oneof:"match"`
	// A set of Certificates defines for the given `hostname`. There can be
	// defined up to fifteen certificates in each Certificate Map Entry. Each
	// certificate must match pattern `projects/*/locations/*/certificates/*`.
	Certificates []string `protobuf:"bytes,7,rep,name=certificates,proto3" json:"certificates,omitempty"`
	// Output only. A serving state of this Certificate Map Entry.
	State ServingState `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.certificatemanager.v1.ServingState" json:"state,omitempty"`
}

func (x *CertificateMapEntry) Reset() {
	*x = CertificateMapEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateMapEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateMapEntry) ProtoMessage() {}

func (x *CertificateMapEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateMapEntry.ProtoReflect.Descriptor instead.
func (*CertificateMapEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{27}
}

func (x *CertificateMapEntry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CertificateMapEntry) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CertificateMapEntry) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CertificateMapEntry) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CertificateMapEntry) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (m *CertificateMapEntry) GetMatch() isCertificateMapEntry_Match {
	if m != nil {
		return m.Match
	}
	return nil
}

func (x *CertificateMapEntry) GetHostname() string {
	if x, ok := x.GetMatch().(*CertificateMapEntry_Hostname); ok {
		return x.Hostname
	}
	return ""
}

func (x *CertificateMapEntry) GetMatcher() CertificateMapEntry_Matcher {
	if x, ok := x.GetMatch().(*CertificateMapEntry_Matcher_); ok {
		return x.Matcher
	}
	return CertificateMapEntry_MATCHER_UNSPECIFIED
}

func (x *CertificateMapEntry) GetCertificates() []string {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *CertificateMapEntry) GetState() ServingState {
	if x != nil {
		return x.State
	}
	return ServingState_SERVING_STATE_UNSPECIFIED
}

type isCertificateMapEntry_Match interface {
	isCertificateMapEntry_Match()
}

type CertificateMapEntry_Hostname struct {
	// A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression
	// (`*.example.com`) for a set of hostnames with common suffix. Used as
	// Server Name Indication (SNI) for selecting a proper certificate.
	Hostname string `protobuf:"bytes,5,opt,name=hostname,proto3,oneof"`
}

type CertificateMapEntry_Matcher_ struct {
	// A predefined matcher for particular cases, other than SNI selection.
	Matcher CertificateMapEntry_Matcher `protobuf:"varint,10,opt,name=matcher,proto3,enum=google.cloud.certificatemanager.v1.CertificateMapEntry_Matcher,oneof"`
}

func (*CertificateMapEntry_Hostname) isCertificateMapEntry_Match() {}

func (*CertificateMapEntry_Matcher_) isCertificateMapEntry_Match() {}

// A DnsAuthorization resource describes a way to perform domain authorization
// for certificate issuance.
type DnsAuthorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-defined name of the dns authorization. DnsAuthorization names must
	// be unique globally and match pattern
	// `projects/*/locations/*/dnsAuthorizations/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation timestamp of a DnsAuthorization.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of a DnsAuthorization.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Set of labels associated with a DnsAuthorization.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// One or more paragraphs of text description of a DnsAuthorization.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Immutable. A domain which is being authorized. A DnsAuthorization resource covers a
	// single domain and its wildcard, e.g. authorization for `example.com` can
	// be used to issue certificates for `example.com` and `*.example.com`.
	Domain string `protobuf:"bytes,6,opt,name=domain,proto3" json:"domain,omitempty"`
	// Output only. DNS Resource Record that needs to be added to DNS configuration.
	DnsResourceRecord *DnsAuthorization_DnsResourceRecord `protobuf:"bytes,10,opt,name=dns_resource_record,json=dnsResourceRecord,proto3" json:"dns_resource_record,omitempty"`
}

func (x *DnsAuthorization) Reset() {
	*x = DnsAuthorization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DnsAuthorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsAuthorization) ProtoMessage() {}

func (x *DnsAuthorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsAuthorization.ProtoReflect.Descriptor instead.
func (*DnsAuthorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{28}
}

func (x *DnsAuthorization) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DnsAuthorization) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DnsAuthorization) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DnsAuthorization) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DnsAuthorization) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DnsAuthorization) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *DnsAuthorization) GetDnsResourceRecord() *DnsAuthorization_DnsResourceRecord {
	if x != nil {
		return x.DnsResourceRecord
	}
	return nil
}

// Certificate data for a SelfManaged Certificate.
// SelfManaged Certificates are uploaded by the user. Updating such
// certificates before they expire remains the user's responsibility.
type Certificate_SelfManagedCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input only. The PEM-encoded certificate chain.
	// Leaf certificate comes first, followed by intermediate ones if any.
	PemCertificate string `protobuf:"bytes,1,opt,name=pem_certificate,json=pemCertificate,proto3" json:"pem_certificate,omitempty"`
	// Input only. The PEM-encoded private key of the leaf certificate.
	PemPrivateKey string `protobuf:"bytes,2,opt,name=pem_private_key,json=pemPrivateKey,proto3" json:"pem_private_key,omitempty"`
}

func (x *Certificate_SelfManagedCertificate) Reset() {
	*x = Certificate_SelfManagedCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate_SelfManagedCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate_SelfManagedCertificate) ProtoMessage() {}

func (x *Certificate_SelfManagedCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate_SelfManagedCertificate.ProtoReflect.Descriptor instead.
func (*Certificate_SelfManagedCertificate) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25, 0}
}

func (x *Certificate_SelfManagedCertificate) GetPemCertificate() string {
	if x != nil {
		return x.PemCertificate
	}
	return ""
}

func (x *Certificate_SelfManagedCertificate) GetPemPrivateKey() string {
	if x != nil {
		return x.PemPrivateKey
	}
	return ""
}

// Configuration and state of a Managed Certificate.
// Certificate Manager provisions and renews Managed Certificates
// automatically, for as long as it's authorized to do so.
type Certificate_ManagedCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The domains for which a managed SSL certificate will be generated.
	// Wildcard domains are only supported with DNS challenge resolution.
	Domains []string `protobuf:"bytes,1,rep,name=domains,proto3" json:"domains,omitempty"`
	// Immutable. Authorizations that will be used for performing domain authorization.
	DnsAuthorizations []string `protobuf:"bytes,2,rep,name=dns_authorizations,json=dnsAuthorizations,proto3" json:"dns_authorizations,omitempty"`
	// Output only. State of the managed certificate resource.
	State Certificate_ManagedCertificate_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.certificatemanager.v1.Certificate_ManagedCertificate_State" json:"state,omitempty"`
	// Information about issues with provisioning a Managed Certificate.
	ProvisioningIssue *Certificate_ManagedCertificate_ProvisioningIssue `protobuf:"bytes,3,opt,name=provisioning_issue,json=provisioningIssue,proto3" json:"provisioning_issue,omitempty"`
	// Output only. Detailed state of the latest authorization attempt for each domain
	// specified for managed certificate resource.
	AuthorizationAttemptInfo []*Certificate_ManagedCertificate_AuthorizationAttemptInfo `protobuf:"bytes,5,rep,name=authorization_attempt_info,json=authorizationAttemptInfo,proto3" json:"authorization_attempt_info,omitempty"`
}

func (x *Certificate_ManagedCertificate) Reset() {
	*x = Certificate_ManagedCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate_ManagedCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate_ManagedCertificate) ProtoMessage() {}

func (x *Certificate_ManagedCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate_ManagedCertificate.ProtoReflect.Descriptor instead.
func (*Certificate_ManagedCertificate) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25, 1}
}

func (x *Certificate_ManagedCertificate) GetDomains() []string {
	if x != nil {
		return x.Domains
	}
	return nil
}

func (x *Certificate_ManagedCertificate) GetDnsAuthorizations() []string {
	if x != nil {
		return x.DnsAuthorizations
	}
	return nil
}

func (x *Certificate_ManagedCertificate) GetState() Certificate_ManagedCertificate_State {
	if x != nil {
		return x.State
	}
	return Certificate_ManagedCertificate_STATE_UNSPECIFIED
}

func (x *Certificate_ManagedCertificate) GetProvisioningIssue() *Certificate_ManagedCertificate_ProvisioningIssue {
	if x != nil {
		return x.ProvisioningIssue
	}
	return nil
}

func (x *Certificate_ManagedCertificate) GetAuthorizationAttemptInfo() []*Certificate_ManagedCertificate_AuthorizationAttemptInfo {
	if x != nil {
		return x.AuthorizationAttemptInfo
	}
	return nil
}

// Information about issues with provisioning a Managed Certificate.
type Certificate_ManagedCertificate_ProvisioningIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reason for provisioning failures.
	Reason Certificate_ManagedCertificate_ProvisioningIssue_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=google.cloud.certificatemanager.v1.Certificate_ManagedCertificate_ProvisioningIssue_Reason" json:"reason,omitempty"`
	// Human readable explanation about the issue. Provided to help address
	// the configuration issues.
	// Not guaranteed to be stable. For programmatic access use Reason enum.
	Details string `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *Certificate_ManagedCertificate_ProvisioningIssue) Reset() {
	*x = Certificate_ManagedCertificate_ProvisioningIssue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate_ManagedCertificate_ProvisioningIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate_ManagedCertificate_ProvisioningIssue) ProtoMessage() {}

func (x *Certificate_ManagedCertificate_ProvisioningIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate_ManagedCertificate_ProvisioningIssue.ProtoReflect.Descriptor instead.
func (*Certificate_ManagedCertificate_ProvisioningIssue) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25, 1, 0}
}

func (x *Certificate_ManagedCertificate_ProvisioningIssue) GetReason() Certificate_ManagedCertificate_ProvisioningIssue_Reason {
	if x != nil {
		return x.Reason
	}
	return Certificate_ManagedCertificate_ProvisioningIssue_REASON_UNSPECIFIED
}

func (x *Certificate_ManagedCertificate_ProvisioningIssue) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

// State of the latest attempt to authorize a domain for certificate
// issuance.
type Certificate_ManagedCertificate_AuthorizationAttemptInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Domain name of the authorization attempt.
	Domain string `protobuf:"bytes,1,opt,name=domain,proto3" json:"domain,omitempty"`
	// State of the domain for managed certificate issuance.
	State Certificate_ManagedCertificate_AuthorizationAttemptInfo_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.certificatemanager.v1.Certificate_ManagedCertificate_AuthorizationAttemptInfo_State" json:"state,omitempty"`
	// Output only. Reason for failure of the authorization attempt for the domain.
	FailureReason Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason `protobuf:"varint,3,opt,name=failure_reason,json=failureReason,proto3,enum=google.cloud.certificatemanager.v1.Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason" json:"failure_reason,omitempty"`
	// Human readable explanation for reaching the state. Provided to help
	// address the configuration issues.
	// Not guaranteed to be stable. For programmatic access use Reason enum.
	Details string `protobuf:"bytes,4,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *Certificate_ManagedCertificate_AuthorizationAttemptInfo) Reset() {
	*x = Certificate_ManagedCertificate_AuthorizationAttemptInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate_ManagedCertificate_AuthorizationAttemptInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate_ManagedCertificate_AuthorizationAttemptInfo) ProtoMessage() {}

func (x *Certificate_ManagedCertificate_AuthorizationAttemptInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate_ManagedCertificate_AuthorizationAttemptInfo.ProtoReflect.Descriptor instead.
func (*Certificate_ManagedCertificate_AuthorizationAttemptInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{25, 1, 1}
}

func (x *Certificate_ManagedCertificate_AuthorizationAttemptInfo) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *Certificate_ManagedCertificate_AuthorizationAttemptInfo) GetState() Certificate_ManagedCertificate_AuthorizationAttemptInfo_State {
	if x != nil {
		return x.State
	}
	return Certificate_ManagedCertificate_AuthorizationAttemptInfo_STATE_UNSPECIFIED
}

func (x *Certificate_ManagedCertificate_AuthorizationAttemptInfo) GetFailureReason() Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason {
	if x != nil {
		return x.FailureReason
	}
	return Certificate_ManagedCertificate_AuthorizationAttemptInfo_FAILURE_REASON_UNSPECIFIED
}

func (x *Certificate_ManagedCertificate_AuthorizationAttemptInfo) GetDetails() string {
	if x != nil {
		return x.Details
	}
	return ""
}

// Describes a Target Proxy which uses this Certificate Map.
type CertificateMap_GclbTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Target Proxy to which this map is attached to.
	//
	// Types that are assignable to TargetProxy:
	//	*CertificateMap_GclbTarget_TargetHttpsProxy
	//	*CertificateMap_GclbTarget_TargetSslProxy
	TargetProxy isCertificateMap_GclbTarget_TargetProxy `protobuf_oneof:"target_proxy"`
	// IP configurations for this Target Proxy where the
	// Certificate Map is serving.
	IpConfigs []*CertificateMap_GclbTarget_IpConfig `protobuf:"bytes,2,rep,name=ip_configs,json=ipConfigs,proto3" json:"ip_configs,omitempty"`
}

func (x *CertificateMap_GclbTarget) Reset() {
	*x = CertificateMap_GclbTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateMap_GclbTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateMap_GclbTarget) ProtoMessage() {}

func (x *CertificateMap_GclbTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateMap_GclbTarget.ProtoReflect.Descriptor instead.
func (*CertificateMap_GclbTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{26, 0}
}

func (m *CertificateMap_GclbTarget) GetTargetProxy() isCertificateMap_GclbTarget_TargetProxy {
	if m != nil {
		return m.TargetProxy
	}
	return nil
}

func (x *CertificateMap_GclbTarget) GetTargetHttpsProxy() string {
	if x, ok := x.GetTargetProxy().(*CertificateMap_GclbTarget_TargetHttpsProxy); ok {
		return x.TargetHttpsProxy
	}
	return ""
}

func (x *CertificateMap_GclbTarget) GetTargetSslProxy() string {
	if x, ok := x.GetTargetProxy().(*CertificateMap_GclbTarget_TargetSslProxy); ok {
		return x.TargetSslProxy
	}
	return ""
}

func (x *CertificateMap_GclbTarget) GetIpConfigs() []*CertificateMap_GclbTarget_IpConfig {
	if x != nil {
		return x.IpConfigs
	}
	return nil
}

type isCertificateMap_GclbTarget_TargetProxy interface {
	isCertificateMap_GclbTarget_TargetProxy()
}

type CertificateMap_GclbTarget_TargetHttpsProxy struct {
	// A name must be in the format
	// `projects/*/locations/*/targetHttpsProxies/*`.
	TargetHttpsProxy string `protobuf:"bytes,1,opt,name=target_https_proxy,json=targetHttpsProxy,proto3,oneof"`
}

type CertificateMap_GclbTarget_TargetSslProxy struct {
	// A name must be in the format
	// `projects/*/locations/*/targetSslProxies/*`.
	TargetSslProxy string `protobuf:"bytes,3,opt,name=target_ssl_proxy,json=targetSslProxy,proto3,oneof"`
}

func (*CertificateMap_GclbTarget_TargetHttpsProxy) isCertificateMap_GclbTarget_TargetProxy() {}

func (*CertificateMap_GclbTarget_TargetSslProxy) isCertificateMap_GclbTarget_TargetProxy() {}

// Defines IP configuration where this Certificate Map is serving.
type CertificateMap_GclbTarget_IpConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An external IP address.
	IpAddress string `protobuf:"bytes,1,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Ports.
	Ports []uint32 `protobuf:"varint,3,rep,packed,name=ports,proto3" json:"ports,omitempty"`
}

func (x *CertificateMap_GclbTarget_IpConfig) Reset() {
	*x = CertificateMap_GclbTarget_IpConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateMap_GclbTarget_IpConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateMap_GclbTarget_IpConfig) ProtoMessage() {}

func (x *CertificateMap_GclbTarget_IpConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateMap_GclbTarget_IpConfig.ProtoReflect.Descriptor instead.
func (*CertificateMap_GclbTarget_IpConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{26, 0, 0}
}

func (x *CertificateMap_GclbTarget_IpConfig) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *CertificateMap_GclbTarget_IpConfig) GetPorts() []uint32 {
	if x != nil {
		return x.Ports
	}
	return nil
}

// The structure describing the DNS Resource Record that needs to be added
// to DNS configuration for the authorization to be usable by
// certificate.
type DnsAuthorization_DnsResourceRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Fully qualified name of the DNS Resource Record.
	// e.g. `_acme-challenge.example.com`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Type of the DNS Resource Record.
	// Currently always set to "CNAME".
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. Data of the DNS Resource Record.
	Data string `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *DnsAuthorization_DnsResourceRecord) Reset() {
	*x = DnsAuthorization_DnsResourceRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DnsAuthorization_DnsResourceRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsAuthorization_DnsResourceRecord) ProtoMessage() {}

func (x *DnsAuthorization_DnsResourceRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsAuthorization_DnsResourceRecord.ProtoReflect.Descriptor instead.
func (*DnsAuthorization_DnsResourceRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP(), []int{28, 0}
}

func (x *DnsAuthorization_DnsResourceRecord) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DnsAuthorization_DnsResourceRecord) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *DnsAuthorization_DnsResourceRecord) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

var File_google_cloud_certificatemanager_v1_certificate_manager_proto protoreflect.FileDescriptor

var file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcb, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb9, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52,
	0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x62, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe1, 0x01, 0x0a, 0x18,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x56, 0x0a, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22,
	0xb4, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0b,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x65, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xce, 0x01,
	0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc6,
	0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d,
	0x0a, 0x10, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x52, 0x0f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x68, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xf5, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x70, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x0f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x22, 0xc1, 0x01, 0x0a, 0x1b, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x0f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6b, 0x0a,
	0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x32, 0x0a, 0x30, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe3, 0x01, 0x0a, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x70, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xde, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a, 0x17, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x15, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70,
	0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x72, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x0a, 0x35, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x02, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x32, 0x0a, 0x30, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x18,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x15, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x49, 0x64, 0x12, 0x70, 0x0a, 0x15, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0xd6, 0x01, 0x0a,
	0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x70, 0x0a, 0x15, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x75, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x37, 0x0a,
	0x35, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd0, 0x01, 0x0a,
	0x1c, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22,
	0xce, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x63, 0x0a, 0x12, 0x64, 0x6e, 0x73, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x11, 0x64, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x6c, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x81,
	0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x14, 0x64, 0x6e, 0x73, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x64, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x66, 0x0a, 0x11, 0x64, 0x6e,
	0x73, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x10, 0x64, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xc9, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x66, 0x0a, 0x11, 0x64, 0x6e, 0x73, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x64, 0x6e, 0x73, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6f,
	0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xb2, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x35, 0x0a, 0x16,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x97, 0x13, 0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x53,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x6b, 0x0a, 0x0c, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x65, 0x6c, 0x66, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x65, 0x6c, 0x66, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x12, 0x5e, 0x0a, 0x07, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x12, 0x26, 0x0a, 0x0c, 0x73, 0x61, 0x6e, 0x5f, 0x64, 0x6e, 0x73, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x61, 0x6e,
	0x44, 0x6e, 0x73, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x65, 0x6d, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x1a, 0x73, 0x0a, 0x16, 0x53, 0x65,
	0x6c, 0x66, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x65, 0x6d, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x04, 0x52, 0x0e, 0x70, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x70, 0x65, 0x6d, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04,
	0x52, 0x0d, 0x70, 0x65, 0x6d, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x1a,
	0xeb, 0x0a, 0x0a, 0x12, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x69, 0x0a, 0x12, 0x64, 0x6e, 0x73, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x3a, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6e, 0x73,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x64,
	0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x63, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x83, 0x01, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x9e, 0x01, 0x0a, 0x1a,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x18, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xef, 0x01, 0x0a,
	0x11, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x12, 0x73, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52,
	0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x22, 0x4b, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52,
	0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c,
	0x52, 0x41, 0x54, 0x45, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x45, 0x44, 0x10, 0x02, 0x1a, 0x82,
	0x04, 0x0a, 0x18, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x12, 0x77, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x95, 0x01, 0x0a,
	0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x4b,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f,
	0x0a, 0x0b, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x06, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x22, 0x56, 0x0a, 0x0d, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a,
	0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x43, 0x41, 0x41, 0x10,
	0x02, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x41, 0x54, 0x45, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x45,
	0x44, 0x10, 0x03, 0x22, 0x48, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x24, 0x0a, 0x05, 0x53, 0x63, 0x6f, 0x70,
	0x65, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x45, 0x44, 0x47, 0x45, 0x5f, 0x43, 0x41, 0x43, 0x48, 0x45, 0x10, 0x01, 0x3a, 0x76,
	0xea, 0x41, 0x73, 0x0a, 0x2d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xc8,
	0x07, 0x0a, 0x0e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x65, 0x0a, 0x0c, 0x67, 0x63, 0x6c, 0x62, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x2e, 0x47, 0x63,
	0x6c, 0x62, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x67,
	0x63, 0x6c, 0x62, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x1a, 0xfe, 0x02, 0x0a, 0x0a, 0x47,
	0x63, 0x6c, 0x62, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x5e, 0x0a, 0x12, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x48, 0x74, 0x74, 0x70, 0x73, 0x50, 0x72,
	0x6f, 0x78, 0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x48,
	0x74, 0x74, 0x70, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x12, 0x58, 0x0a, 0x10, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x73, 0x73, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x50, 0x72, 0x6f, 0x78, 0x69, 0x65,
	0x73, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x50, 0x72,
	0x6f, 0x78, 0x79, 0x12, 0x65, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x2e, 0x47, 0x63, 0x6c, 0x62,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x09, 0x69, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0x3f, 0x0a, 0x08, 0x49, 0x70,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0d, 0x52, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x30, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x49,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x7d, 0x22, 0xf8, 0x06, 0x0a, 0x13, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x1c, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x68, 0x6f,
	0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x12, 0x56, 0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x32, 0xfa, 0x41, 0x2f, 0x0a, 0x2d,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x2f, 0x0a, 0x07, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x17,
	0x0a, 0x13, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x4d, 0x41,
	0x52, 0x59, 0x10, 0x01, 0x3a, 0xb4, 0x01, 0xea, 0x41, 0xb0, 0x01, 0x0a, 0x35, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x77, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x7d, 0x2f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x7d, 0x42, 0x07, 0x0a, 0x05, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x22, 0xe8, 0x05, 0x0a, 0x10, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x58, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a,
	0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x7b, 0x0a,
	0x13, 0x64, 0x6e, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x44, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x64, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x1a, 0x5e, 0x0a, 0x11, 0x44, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x87, 0x01, 0xea, 0x41, 0x83, 0x01, 0x0a, 0x32, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x6e, 0x73, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x64, 0x6e, 0x73,
	0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2a,
	0x46, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x53, 0x45, 0x52, 0x56, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x32, 0xde, 0x28, 0x0a, 0x12, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0xd0,
	0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0xbd, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xff, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x22, 0x30, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x3a,
	0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0xda, 0x41, 0x21, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x2c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64,
	0xca, 0x41, 0x20, 0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x81, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8e, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x32,
	0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0xda, 0x41, 0x17, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xde, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xdc, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc9, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x22,
	0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x97, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9e, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x46, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x3a, 0x0f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0xda, 0x41, 0x29, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x70, 0x2c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x23, 0x0a, 0x0e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x99, 0x02,
	0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa0, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x32,
	0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x70, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x70, 0xda, 0x41, 0x1b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0xca, 0x41, 0x23, 0x0a, 0x0e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe7, 0x01, 0x0a, 0x14, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x70, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x86, 0x02, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5c,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf0, 0x01, 0x0a,
	0x16, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xd0, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xcd, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x64, 0x22, 0x4b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x70, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x15, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0xda,
	0x41, 0x35, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2c, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xd2, 0x02, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xcf, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7a, 0x32, 0x61,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x15, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0xda, 0x41, 0x21, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x28, 0x0a,
	0x13, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x8a, 0x02, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4d, 0x2a, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0xe4, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6e, 0x73,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x64, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd1, 0x01, 0x0a, 0x13,
	0x47, 0x65, 0x74, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x6e, 0x73, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xa5, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6e, 0x73, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x11, 0x64, 0x6e,
	0x73, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xda,
	0x41, 0x2d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x6e, 0x73, 0x5f, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x64, 0x6e, 0x73, 0x5f, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0xca,
	0x41, 0x25, 0x0a, 0x10, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa7, 0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6e,
	0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaa, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x32, 0x47, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x64, 0x6e, 0x73, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x11, 0x64, 0x6e, 0x73, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x1d, 0x64, 0x6e, 0x73, 0x5f,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x44, 0x6e,
	0x73, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0xed, 0x01, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6e, 0x73, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x1a, 0x55, 0xca, 0x41, 0x21, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x83, 0x04, 0x0a, 0x26, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x42, 0x17, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x54,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x3b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02,
	0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0xea, 0x41, 0x7c, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x48, 0x74, 0x74, 0x70, 0x73, 0x50, 0x72, 0x6f,
	0x78, 0x69, 0x65, 0x73, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x48, 0x74, 0x74, 0x70, 0x73, 0x50, 0x72, 0x6f, 0x78, 0x69, 0x65, 0x73,
	0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x73, 0x5f, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x7d, 0xea, 0x41, 0x76, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x73, 0x6c, 0x50, 0x72, 0x6f, 0x78, 0x69, 0x65,
	0x73, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x53, 0x73, 0x6c, 0x50, 0x72, 0x6f, 0x78, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x73, 0x73, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x7d, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescOnce sync.Once
	file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescData = file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDesc
)

func file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescGZIP() []byte {
	file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescOnce.Do(func() {
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescData)
	})
	return file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDescData
}

var file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes = make([]protoimpl.MessageInfo, 40)
var file_google_cloud_certificatemanager_v1_certificate_manager_proto_goTypes = []interface{}{
	(ServingState)(0),                                                          // 0: google.cloud.certificatemanager.v1.ServingState
	(Certificate_Scope)(0),                                                     // 1: google.cloud.certificatemanager.v1.Certificate.Scope
	(Certificate_ManagedCertificate_State)(0),                                  // 2: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State
	(Certificate_ManagedCertificate_ProvisioningIssue_Reason)(0),               // 3: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason
	(Certificate_ManagedCertificate_AuthorizationAttemptInfo_State)(0),         // 4: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State
	(Certificate_ManagedCertificate_AuthorizationAttemptInfo_FailureReason)(0), // 5: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason
	(CertificateMapEntry_Matcher)(0),                                           // 6: google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher
	(*ListCertificatesRequest)(nil),                                            // 7: google.cloud.certificatemanager.v1.ListCertificatesRequest
	(*ListCertificatesResponse)(nil),                                           // 8: google.cloud.certificatemanager.v1.ListCertificatesResponse
	(*GetCertificateRequest)(nil),                                              // 9: google.cloud.certificatemanager.v1.GetCertificateRequest
	(*CreateCertificateRequest)(nil),                                           // 10: google.cloud.certificatemanager.v1.CreateCertificateRequest
	(*UpdateCertificateRequest)(nil),                                           // 11: google.cloud.certificatemanager.v1.UpdateCertificateRequest
	(*DeleteCertificateRequest)(nil),                                           // 12: google.cloud.certificatemanager.v1.DeleteCertificateRequest
	(*ListCertificateMapsRequest)(nil),                                         // 13: google.cloud.certificatemanager.v1.ListCertificateMapsRequest
	(*ListCertificateMapsResponse)(nil),                                        // 14: google.cloud.certificatemanager.v1.ListCertificateMapsResponse
	(*GetCertificateMapRequest)(nil),                                           // 15: google.cloud.certificatemanager.v1.GetCertificateMapRequest
	(*CreateCertificateMapRequest)(nil),                                        // 16: google.cloud.certificatemanager.v1.CreateCertificateMapRequest
	(*UpdateCertificateMapRequest)(nil),                                        // 17: google.cloud.certificatemanager.v1.UpdateCertificateMapRequest
	(*DeleteCertificateMapRequest)(nil),                                        // 18: google.cloud.certificatemanager.v1.DeleteCertificateMapRequest
	(*ListCertificateMapEntriesRequest)(nil),                                   // 19: google.cloud.certificatemanager.v1.ListCertificateMapEntriesRequest
	(*ListCertificateMapEntriesResponse)(nil),                                  // 20: google.cloud.certificatemanager.v1.ListCertificateMapEntriesResponse
	(*GetCertificateMapEntryRequest)(nil),                                      // 21: google.cloud.certificatemanager.v1.GetCertificateMapEntryRequest
	(*CreateCertificateMapEntryRequest)(nil),                                   // 22: google.cloud.certificatemanager.v1.CreateCertificateMapEntryRequest
	(*UpdateCertificateMapEntryRequest)(nil),                                   // 23: google.cloud.certificatemanager.v1.UpdateCertificateMapEntryRequest
	(*DeleteCertificateMapEntryRequest)(nil),                                   // 24: google.cloud.certificatemanager.v1.DeleteCertificateMapEntryRequest
	(*ListDnsAuthorizationsRequest)(nil),                                       // 25: google.cloud.certificatemanager.v1.ListDnsAuthorizationsRequest
	(*ListDnsAuthorizationsResponse)(nil),                                      // 26: google.cloud.certificatemanager.v1.ListDnsAuthorizationsResponse
	(*GetDnsAuthorizationRequest)(nil),                                         // 27: google.cloud.certificatemanager.v1.GetDnsAuthorizationRequest
	(*CreateDnsAuthorizationRequest)(nil),                                      // 28: google.cloud.certificatemanager.v1.CreateDnsAuthorizationRequest
	(*UpdateDnsAuthorizationRequest)(nil),                                      // 29: google.cloud.certificatemanager.v1.UpdateDnsAuthorizationRequest
	(*DeleteDnsAuthorizationRequest)(nil),                                      // 30: google.cloud.certificatemanager.v1.DeleteDnsAuthorizationRequest
	(*OperationMetadata)(nil),                                                  // 31: google.cloud.certificatemanager.v1.OperationMetadata
	(*Certificate)(nil),                                                        // 32: google.cloud.certificatemanager.v1.Certificate
	(*CertificateMap)(nil),                                                     // 33: google.cloud.certificatemanager.v1.CertificateMap
	(*CertificateMapEntry)(nil),                                                // 34: google.cloud.certificatemanager.v1.CertificateMapEntry
	(*DnsAuthorization)(nil),                                                   // 35: google.cloud.certificatemanager.v1.DnsAuthorization
	(*Certificate_SelfManagedCertificate)(nil),                                 // 36: google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
	(*Certificate_ManagedCertificate)(nil),                                     // 37: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
	nil,                                                                        // 38: google.cloud.certificatemanager.v1.Certificate.LabelsEntry
	(*Certificate_ManagedCertificate_ProvisioningIssue)(nil),                   // 39: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
	(*Certificate_ManagedCertificate_AuthorizationAttemptInfo)(nil),            // 40: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo
	(*CertificateMap_GclbTarget)(nil),                                          // 41: google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
	nil,                                                                        // 42: google.cloud.certificatemanager.v1.CertificateMap.LabelsEntry
	(*CertificateMap_GclbTarget_IpConfig)(nil),                                 // 43: google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
	nil, // 44: google.cloud.certificatemanager.v1.CertificateMapEntry.LabelsEntry
	(*DnsAuthorization_DnsResourceRecord)(nil), // 45: google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
	nil,                           // 46: google.cloud.certificatemanager.v1.DnsAuthorization.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil), // 47: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil), // 48: google.protobuf.Timestamp
	(*longrunning.Operation)(nil), // 49: google.longrunning.Operation
}
var file_google_cloud_certificatemanager_v1_certificate_manager_proto_depIdxs = []int32{
	32, // 0: google.cloud.certificatemanager.v1.ListCertificatesResponse.certificates:type_name -> google.cloud.certificatemanager.v1.Certificate
	32, // 1: google.cloud.certificatemanager.v1.CreateCertificateRequest.certificate:type_name -> google.cloud.certificatemanager.v1.Certificate
	32, // 2: google.cloud.certificatemanager.v1.UpdateCertificateRequest.certificate:type_name -> google.cloud.certificatemanager.v1.Certificate
	47, // 3: google.cloud.certificatemanager.v1.UpdateCertificateRequest.update_mask:type_name -> google.protobuf.FieldMask
	33, // 4: google.cloud.certificatemanager.v1.ListCertificateMapsResponse.certificate_maps:type_name -> google.cloud.certificatemanager.v1.CertificateMap
	33, // 5: google.cloud.certificatemanager.v1.CreateCertificateMapRequest.certificate_map:type_name -> google.cloud.certificatemanager.v1.CertificateMap
	33, // 6: google.cloud.certificatemanager.v1.UpdateCertificateMapRequest.certificate_map:type_name -> google.cloud.certificatemanager.v1.CertificateMap
	47, // 7: google.cloud.certificatemanager.v1.UpdateCertificateMapRequest.update_mask:type_name -> google.protobuf.FieldMask
	34, // 8: google.cloud.certificatemanager.v1.ListCertificateMapEntriesResponse.certificate_map_entries:type_name -> google.cloud.certificatemanager.v1.CertificateMapEntry
	34, // 9: google.cloud.certificatemanager.v1.CreateCertificateMapEntryRequest.certificate_map_entry:type_name -> google.cloud.certificatemanager.v1.CertificateMapEntry
	34, // 10: google.cloud.certificatemanager.v1.UpdateCertificateMapEntryRequest.certificate_map_entry:type_name -> google.cloud.certificatemanager.v1.CertificateMapEntry
	47, // 11: google.cloud.certificatemanager.v1.UpdateCertificateMapEntryRequest.update_mask:type_name -> google.protobuf.FieldMask
	35, // 12: google.cloud.certificatemanager.v1.ListDnsAuthorizationsResponse.dns_authorizations:type_name -> google.cloud.certificatemanager.v1.DnsAuthorization
	35, // 13: google.cloud.certificatemanager.v1.CreateDnsAuthorizationRequest.dns_authorization:type_name -> google.cloud.certificatemanager.v1.DnsAuthorization
	35, // 14: google.cloud.certificatemanager.v1.UpdateDnsAuthorizationRequest.dns_authorization:type_name -> google.cloud.certificatemanager.v1.DnsAuthorization
	47, // 15: google.cloud.certificatemanager.v1.UpdateDnsAuthorizationRequest.update_mask:type_name -> google.protobuf.FieldMask
	48, // 16: google.cloud.certificatemanager.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	48, // 17: google.cloud.certificatemanager.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	48, // 18: google.cloud.certificatemanager.v1.Certificate.create_time:type_name -> google.protobuf.Timestamp
	48, // 19: google.cloud.certificatemanager.v1.Certificate.update_time:type_name -> google.protobuf.Timestamp
	38, // 20: google.cloud.certificatemanager.v1.Certificate.labels:type_name -> google.cloud.certificatemanager.v1.Certificate.LabelsEntry
	36, // 21: google.cloud.certificatemanager.v1.Certificate.self_managed:type_name -> google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate
	37, // 22: google.cloud.certificatemanager.v1.Certificate.managed:type_name -> google.cloud.certificatemanager.v1.Certificate.ManagedCertificate
	48, // 23: google.cloud.certificatemanager.v1.Certificate.expire_time:type_name -> google.protobuf.Timestamp
	1,  // 24: google.cloud.certificatemanager.v1.Certificate.scope:type_name -> google.cloud.certificatemanager.v1.Certificate.Scope
	48, // 25: google.cloud.certificatemanager.v1.CertificateMap.create_time:type_name -> google.protobuf.Timestamp
	48, // 26: google.cloud.certificatemanager.v1.CertificateMap.update_time:type_name -> google.protobuf.Timestamp
	42, // 27: google.cloud.certificatemanager.v1.CertificateMap.labels:type_name -> google.cloud.certificatemanager.v1.CertificateMap.LabelsEntry
	41, // 28: google.cloud.certificatemanager.v1.CertificateMap.gclb_targets:type_name -> google.cloud.certificatemanager.v1.CertificateMap.GclbTarget
	48, // 29: google.cloud.certificatemanager.v1.CertificateMapEntry.create_time:type_name -> google.protobuf.Timestamp
	48, // 30: google.cloud.certificatemanager.v1.CertificateMapEntry.update_time:type_name -> google.protobuf.Timestamp
	44, // 31: google.cloud.certificatemanager.v1.CertificateMapEntry.labels:type_name -> google.cloud.certificatemanager.v1.CertificateMapEntry.LabelsEntry
	6,  // 32: google.cloud.certificatemanager.v1.CertificateMapEntry.matcher:type_name -> google.cloud.certificatemanager.v1.CertificateMapEntry.Matcher
	0,  // 33: google.cloud.certificatemanager.v1.CertificateMapEntry.state:type_name -> google.cloud.certificatemanager.v1.ServingState
	48, // 34: google.cloud.certificatemanager.v1.DnsAuthorization.create_time:type_name -> google.protobuf.Timestamp
	48, // 35: google.cloud.certificatemanager.v1.DnsAuthorization.update_time:type_name -> google.protobuf.Timestamp
	46, // 36: google.cloud.certificatemanager.v1.DnsAuthorization.labels:type_name -> google.cloud.certificatemanager.v1.DnsAuthorization.LabelsEntry
	45, // 37: google.cloud.certificatemanager.v1.DnsAuthorization.dns_resource_record:type_name -> google.cloud.certificatemanager.v1.DnsAuthorization.DnsResourceRecord
	2,  // 38: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.state:type_name -> google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.State
	39, // 39: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.provisioning_issue:type_name -> google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue
	40, // 40: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.authorization_attempt_info:type_name -> google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo
	3,  // 41: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.reason:type_name -> google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.ProvisioningIssue.Reason
	4,  // 42: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.state:type_name -> google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.State
	5,  // 43: google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.failure_reason:type_name -> google.cloud.certificatemanager.v1.Certificate.ManagedCertificate.AuthorizationAttemptInfo.FailureReason
	43, // 44: google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.ip_configs:type_name -> google.cloud.certificatemanager.v1.CertificateMap.GclbTarget.IpConfig
	7,  // 45: google.cloud.certificatemanager.v1.CertificateManager.ListCertificates:input_type -> google.cloud.certificatemanager.v1.ListCertificatesRequest
	9,  // 46: google.cloud.certificatemanager.v1.CertificateManager.GetCertificate:input_type -> google.cloud.certificatemanager.v1.GetCertificateRequest
	10, // 47: google.cloud.certificatemanager.v1.CertificateManager.CreateCertificate:input_type -> google.cloud.certificatemanager.v1.CreateCertificateRequest
	11, // 48: google.cloud.certificatemanager.v1.CertificateManager.UpdateCertificate:input_type -> google.cloud.certificatemanager.v1.UpdateCertificateRequest
	12, // 49: google.cloud.certificatemanager.v1.CertificateManager.DeleteCertificate:input_type -> google.cloud.certificatemanager.v1.DeleteCertificateRequest
	13, // 50: google.cloud.certificatemanager.v1.CertificateManager.ListCertificateMaps:input_type -> google.cloud.certificatemanager.v1.ListCertificateMapsRequest
	15, // 51: google.cloud.certificatemanager.v1.CertificateManager.GetCertificateMap:input_type -> google.cloud.certificatemanager.v1.GetCertificateMapRequest
	16, // 52: google.cloud.certificatemanager.v1.CertificateManager.CreateCertificateMap:input_type -> google.cloud.certificatemanager.v1.CreateCertificateMapRequest
	17, // 53: google.cloud.certificatemanager.v1.CertificateManager.UpdateCertificateMap:input_type -> google.cloud.certificatemanager.v1.UpdateCertificateMapRequest
	18, // 54: google.cloud.certificatemanager.v1.CertificateManager.DeleteCertificateMap:input_type -> google.cloud.certificatemanager.v1.DeleteCertificateMapRequest
	19, // 55: google.cloud.certificatemanager.v1.CertificateManager.ListCertificateMapEntries:input_type -> google.cloud.certificatemanager.v1.ListCertificateMapEntriesRequest
	21, // 56: google.cloud.certificatemanager.v1.CertificateManager.GetCertificateMapEntry:input_type -> google.cloud.certificatemanager.v1.GetCertificateMapEntryRequest
	22, // 57: google.cloud.certificatemanager.v1.CertificateManager.CreateCertificateMapEntry:input_type -> google.cloud.certificatemanager.v1.CreateCertificateMapEntryRequest
	23, // 58: google.cloud.certificatemanager.v1.CertificateManager.UpdateCertificateMapEntry:input_type -> google.cloud.certificatemanager.v1.UpdateCertificateMapEntryRequest
	24, // 59: google.cloud.certificatemanager.v1.CertificateManager.DeleteCertificateMapEntry:input_type -> google.cloud.certificatemanager.v1.DeleteCertificateMapEntryRequest
	25, // 60: google.cloud.certificatemanager.v1.CertificateManager.ListDnsAuthorizations:input_type -> google.cloud.certificatemanager.v1.ListDnsAuthorizationsRequest
	27, // 61: google.cloud.certificatemanager.v1.CertificateManager.GetDnsAuthorization:input_type -> google.cloud.certificatemanager.v1.GetDnsAuthorizationRequest
	28, // 62: google.cloud.certificatemanager.v1.CertificateManager.CreateDnsAuthorization:input_type -> google.cloud.certificatemanager.v1.CreateDnsAuthorizationRequest
	29, // 63: google.cloud.certificatemanager.v1.CertificateManager.UpdateDnsAuthorization:input_type -> google.cloud.certificatemanager.v1.UpdateDnsAuthorizationRequest
	30, // 64: google.cloud.certificatemanager.v1.CertificateManager.DeleteDnsAuthorization:input_type -> google.cloud.certificatemanager.v1.DeleteDnsAuthorizationRequest
	8,  // 65: google.cloud.certificatemanager.v1.CertificateManager.ListCertificates:output_type -> google.cloud.certificatemanager.v1.ListCertificatesResponse
	32, // 66: google.cloud.certificatemanager.v1.CertificateManager.GetCertificate:output_type -> google.cloud.certificatemanager.v1.Certificate
	49, // 67: google.cloud.certificatemanager.v1.CertificateManager.CreateCertificate:output_type -> google.longrunning.Operation
	49, // 68: google.cloud.certificatemanager.v1.CertificateManager.UpdateCertificate:output_type -> google.longrunning.Operation
	49, // 69: google.cloud.certificatemanager.v1.CertificateManager.DeleteCertificate:output_type -> google.longrunning.Operation
	14, // 70: google.cloud.certificatemanager.v1.CertificateManager.ListCertificateMaps:output_type -> google.cloud.certificatemanager.v1.ListCertificateMapsResponse
	33, // 71: google.cloud.certificatemanager.v1.CertificateManager.GetCertificateMap:output_type -> google.cloud.certificatemanager.v1.CertificateMap
	49, // 72: google.cloud.certificatemanager.v1.CertificateManager.CreateCertificateMap:output_type -> google.longrunning.Operation
	49, // 73: google.cloud.certificatemanager.v1.CertificateManager.UpdateCertificateMap:output_type -> google.longrunning.Operation
	49, // 74: google.cloud.certificatemanager.v1.CertificateManager.DeleteCertificateMap:output_type -> google.longrunning.Operation
	20, // 75: google.cloud.certificatemanager.v1.CertificateManager.ListCertificateMapEntries:output_type -> google.cloud.certificatemanager.v1.ListCertificateMapEntriesResponse
	34, // 76: google.cloud.certificatemanager.v1.CertificateManager.GetCertificateMapEntry:output_type -> google.cloud.certificatemanager.v1.CertificateMapEntry
	49, // 77: google.cloud.certificatemanager.v1.CertificateManager.CreateCertificateMapEntry:output_type -> google.longrunning.Operation
	49, // 78: google.cloud.certificatemanager.v1.CertificateManager.UpdateCertificateMapEntry:output_type -> google.longrunning.Operation
	49, // 79: google.cloud.certificatemanager.v1.CertificateManager.DeleteCertificateMapEntry:output_type -> google.longrunning.Operation
	26, // 80: google.cloud.certificatemanager.v1.CertificateManager.ListDnsAuthorizations:output_type -> google.cloud.certificatemanager.v1.ListDnsAuthorizationsResponse
	35, // 81: google.cloud.certificatemanager.v1.CertificateManager.GetDnsAuthorization:output_type -> google.cloud.certificatemanager.v1.DnsAuthorization
	49, // 82: google.cloud.certificatemanager.v1.CertificateManager.CreateDnsAuthorization:output_type -> google.longrunning.Operation
	49, // 83: google.cloud.certificatemanager.v1.CertificateManager.UpdateDnsAuthorization:output_type -> google.longrunning.Operation
	49, // 84: google.cloud.certificatemanager.v1.CertificateManager.DeleteDnsAuthorization:output_type -> google.longrunning.Operation
	65, // [65:85] is the sub-list for method output_type
	45, // [45:65] is the sub-list for method input_type
	45, // [45:45] is the sub-list for extension type_name
	45, // [45:45] is the sub-list for extension extendee
	0,  // [0:45] is the sub-list for field type_name
}

func init() { file_google_cloud_certificatemanager_v1_certificate_manager_proto_init() }
func file_google_cloud_certificatemanager_v1_certificate_manager_proto_init() {
	if File_google_cloud_certificatemanager_v1_certificate_manager_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCertificatesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCertificatesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCertificateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCertificateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCertificateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCertificateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCertificateMapsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCertificateMapsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCertificateMapRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCertificateMapRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCertificateMapRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCertificateMapRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCertificateMapEntriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCertificateMapEntriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCertificateMapEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCertificateMapEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCertificateMapEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCertificateMapEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDnsAuthorizationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDnsAuthorizationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDnsAuthorizationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDnsAuthorizationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDnsAuthorizationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDnsAuthorizationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateMap); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateMapEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DnsAuthorization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate_SelfManagedCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate_ManagedCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate_ManagedCertificate_ProvisioningIssue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate_ManagedCertificate_AuthorizationAttemptInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateMap_GclbTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateMap_GclbTarget_IpConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DnsAuthorization_DnsResourceRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[25].OneofWrappers = []interface{}{
		(*Certificate_SelfManaged)(nil),
		(*Certificate_Managed)(nil),
	}
	file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*CertificateMapEntry_Hostname)(nil),
		(*CertificateMapEntry_Matcher_)(nil),
	}
	file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes[34].OneofWrappers = []interface{}{
		(*CertificateMap_GclbTarget_TargetHttpsProxy)(nil),
		(*CertificateMap_GclbTarget_TargetSslProxy)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   40,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_certificatemanager_v1_certificate_manager_proto_goTypes,
		DependencyIndexes: file_google_cloud_certificatemanager_v1_certificate_manager_proto_depIdxs,
		EnumInfos:         file_google_cloud_certificatemanager_v1_certificate_manager_proto_enumTypes,
		MessageInfos:      file_google_cloud_certificatemanager_v1_certificate_manager_proto_msgTypes,
	}.Build()
	File_google_cloud_certificatemanager_v1_certificate_manager_proto = out.File
	file_google_cloud_certificatemanager_v1_certificate_manager_proto_rawDesc = nil
	file_google_cloud_certificatemanager_v1_certificate_manager_proto_goTypes = nil
	file_google_cloud_certificatemanager_v1_certificate_manager_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CertificateManagerClient is the client API for CertificateManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CertificateManagerClient interface {
	// Lists Certificates in a given project and location.
	ListCertificates(ctx context.Context, in *ListCertificatesRequest, opts ...grpc.CallOption) (*ListCertificatesResponse, error)
	// Gets details of a single Certificate.
	GetCertificate(ctx context.Context, in *GetCertificateRequest, opts ...grpc.CallOption) (*Certificate, error)
	// Creates a new Certificate in a given project and location.
	CreateCertificate(ctx context.Context, in *CreateCertificateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a Certificate.
	UpdateCertificate(ctx context.Context, in *UpdateCertificateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single Certificate.
	DeleteCertificate(ctx context.Context, in *DeleteCertificateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists CertificateMaps in a given project and location.
	ListCertificateMaps(ctx context.Context, in *ListCertificateMapsRequest, opts ...grpc.CallOption) (*ListCertificateMapsResponse, error)
	// Gets details of a single CertificateMap.
	GetCertificateMap(ctx context.Context, in *GetCertificateMapRequest, opts ...grpc.CallOption) (*CertificateMap, error)
	// Creates a new CertificateMap in a given project and location.
	CreateCertificateMap(ctx context.Context, in *CreateCertificateMapRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a CertificateMap.
	UpdateCertificateMap(ctx context.Context, in *UpdateCertificateMapRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single CertificateMap. A Certificate Map can't be deleted
	// if it contains Certificate Map Entries. Remove all the entries from
	// the map before calling this method.
	DeleteCertificateMap(ctx context.Context, in *DeleteCertificateMapRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists CertificateMapEntries in a given project and location.
	ListCertificateMapEntries(ctx context.Context, in *ListCertificateMapEntriesRequest, opts ...grpc.CallOption) (*ListCertificateMapEntriesResponse, error)
	// Gets details of a single CertificateMapEntry.
	GetCertificateMapEntry(ctx context.Context, in *GetCertificateMapEntryRequest, opts ...grpc.CallOption) (*CertificateMapEntry, error)
	// Creates a new CertificateMapEntry in a given project and location.
	CreateCertificateMapEntry(ctx context.Context, in *CreateCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a CertificateMapEntry.
	UpdateCertificateMapEntry(ctx context.Context, in *UpdateCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single CertificateMapEntry.
	DeleteCertificateMapEntry(ctx context.Context, in *DeleteCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists DnsAuthorizations in a given project and location.
	ListDnsAuthorizations(ctx context.Context, in *ListDnsAuthorizationsRequest, opts ...grpc.CallOption) (*ListDnsAuthorizationsResponse, error)
	// Gets details of a single DnsAuthorization.
	GetDnsAuthorization(ctx context.Context, in *GetDnsAuthorizationRequest, opts ...grpc.CallOption) (*DnsAuthorization, error)
	// Creates a new DnsAuthorization in a given project and location.
	CreateDnsAuthorization(ctx context.Context, in *CreateDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates a DnsAuthorization.
	UpdateDnsAuthorization(ctx context.Context, in *UpdateDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single DnsAuthorization.
	DeleteDnsAuthorization(ctx context.Context, in *DeleteDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type certificateManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewCertificateManagerClient(cc grpc.ClientConnInterface) CertificateManagerClient {
	return &certificateManagerClient{cc}
}

func (c *certificateManagerClient) ListCertificates(ctx context.Context, in *ListCertificatesRequest, opts ...grpc.CallOption) (*ListCertificatesResponse, error) {
	out := new(ListCertificatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetCertificate(ctx context.Context, in *GetCertificateRequest, opts ...grpc.CallOption) (*Certificate, error) {
	out := new(Certificate)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateCertificate(ctx context.Context, in *CreateCertificateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) UpdateCertificate(ctx context.Context, in *UpdateCertificateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/UpdateCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteCertificate(ctx context.Context, in *DeleteCertificateRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) ListCertificateMaps(ctx context.Context, in *ListCertificateMapsRequest, opts ...grpc.CallOption) (*ListCertificateMapsResponse, error) {
	out := new(ListCertificateMapsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificateMaps", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetCertificateMap(ctx context.Context, in *GetCertificateMapRequest, opts ...grpc.CallOption) (*CertificateMap, error) {
	out := new(CertificateMap)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificateMap", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateCertificateMap(ctx context.Context, in *CreateCertificateMapRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificateMap", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) UpdateCertificateMap(ctx context.Context, in *UpdateCertificateMapRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/UpdateCertificateMap", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteCertificateMap(ctx context.Context, in *DeleteCertificateMapRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificateMap", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) ListCertificateMapEntries(ctx context.Context, in *ListCertificateMapEntriesRequest, opts ...grpc.CallOption) (*ListCertificateMapEntriesResponse, error) {
	out := new(ListCertificateMapEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificateMapEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetCertificateMapEntry(ctx context.Context, in *GetCertificateMapEntryRequest, opts ...grpc.CallOption) (*CertificateMapEntry, error) {
	out := new(CertificateMapEntry)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificateMapEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateCertificateMapEntry(ctx context.Context, in *CreateCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificateMapEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) UpdateCertificateMapEntry(ctx context.Context, in *UpdateCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/UpdateCertificateMapEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteCertificateMapEntry(ctx context.Context, in *DeleteCertificateMapEntryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificateMapEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) ListDnsAuthorizations(ctx context.Context, in *ListDnsAuthorizationsRequest, opts ...grpc.CallOption) (*ListDnsAuthorizationsResponse, error) {
	out := new(ListDnsAuthorizationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/ListDnsAuthorizations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) GetDnsAuthorization(ctx context.Context, in *GetDnsAuthorizationRequest, opts ...grpc.CallOption) (*DnsAuthorization, error) {
	out := new(DnsAuthorization)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/GetDnsAuthorization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) CreateDnsAuthorization(ctx context.Context, in *CreateDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/CreateDnsAuthorization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) UpdateDnsAuthorization(ctx context.Context, in *UpdateDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/UpdateDnsAuthorization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagerClient) DeleteDnsAuthorization(ctx context.Context, in *DeleteDnsAuthorizationRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.certificatemanager.v1.CertificateManager/DeleteDnsAuthorization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CertificateManagerServer is the server API for CertificateManager service.
type CertificateManagerServer interface {
	// Lists Certificates in a given project and location.
	ListCertificates(context.Context, *ListCertificatesRequest) (*ListCertificatesResponse, error)
	// Gets details of a single Certificate.
	GetCertificate(context.Context, *GetCertificateRequest) (*Certificate, error)
	// Creates a new Certificate in a given project and location.
	CreateCertificate(context.Context, *CreateCertificateRequest) (*longrunning.Operation, error)
	// Updates a Certificate.
	UpdateCertificate(context.Context, *UpdateCertificateRequest) (*longrunning.Operation, error)
	// Deletes a single Certificate.
	DeleteCertificate(context.Context, *DeleteCertificateRequest) (*longrunning.Operation, error)
	// Lists CertificateMaps in a given project and location.
	ListCertificateMaps(context.Context, *ListCertificateMapsRequest) (*ListCertificateMapsResponse, error)
	// Gets details of a single CertificateMap.
	GetCertificateMap(context.Context, *GetCertificateMapRequest) (*CertificateMap, error)
	// Creates a new CertificateMap in a given project and location.
	CreateCertificateMap(context.Context, *CreateCertificateMapRequest) (*longrunning.Operation, error)
	// Updates a CertificateMap.
	UpdateCertificateMap(context.Context, *UpdateCertificateMapRequest) (*longrunning.Operation, error)
	// Deletes a single CertificateMap. A Certificate Map can't be deleted
	// if it contains Certificate Map Entries. Remove all the entries from
	// the map before calling this method.
	DeleteCertificateMap(context.Context, *DeleteCertificateMapRequest) (*longrunning.Operation, error)
	// Lists CertificateMapEntries in a given project and location.
	ListCertificateMapEntries(context.Context, *ListCertificateMapEntriesRequest) (*ListCertificateMapEntriesResponse, error)
	// Gets details of a single CertificateMapEntry.
	GetCertificateMapEntry(context.Context, *GetCertificateMapEntryRequest) (*CertificateMapEntry, error)
	// Creates a new CertificateMapEntry in a given project and location.
	CreateCertificateMapEntry(context.Context, *CreateCertificateMapEntryRequest) (*longrunning.Operation, error)
	// Updates a CertificateMapEntry.
	UpdateCertificateMapEntry(context.Context, *UpdateCertificateMapEntryRequest) (*longrunning.Operation, error)
	// Deletes a single CertificateMapEntry.
	DeleteCertificateMapEntry(context.Context, *DeleteCertificateMapEntryRequest) (*longrunning.Operation, error)
	// Lists DnsAuthorizations in a given project and location.
	ListDnsAuthorizations(context.Context, *ListDnsAuthorizationsRequest) (*ListDnsAuthorizationsResponse, error)
	// Gets details of a single DnsAuthorization.
	GetDnsAuthorization(context.Context, *GetDnsAuthorizationRequest) (*DnsAuthorization, error)
	// Creates a new DnsAuthorization in a given project and location.
	CreateDnsAuthorization(context.Context, *CreateDnsAuthorizationRequest) (*longrunning.Operation, error)
	// Updates a DnsAuthorization.
	UpdateDnsAuthorization(context.Context, *UpdateDnsAuthorizationRequest) (*longrunning.Operation, error)
	// Deletes a single DnsAuthorization.
	DeleteDnsAuthorization(context.Context, *DeleteDnsAuthorizationRequest) (*longrunning.Operation, error)
}

// UnimplementedCertificateManagerServer can be embedded to have forward compatible implementations.
type UnimplementedCertificateManagerServer struct {
}

func (*UnimplementedCertificateManagerServer) ListCertificates(context.Context, *ListCertificatesRequest) (*ListCertificatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificates not implemented")
}
func (*UnimplementedCertificateManagerServer) GetCertificate(context.Context, *GetCertificateRequest) (*Certificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificate not implemented")
}
func (*UnimplementedCertificateManagerServer) CreateCertificate(context.Context, *CreateCertificateRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificate not implemented")
}
func (*UnimplementedCertificateManagerServer) UpdateCertificate(context.Context, *UpdateCertificateRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificate not implemented")
}
func (*UnimplementedCertificateManagerServer) DeleteCertificate(context.Context, *DeleteCertificateRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificate not implemented")
}
func (*UnimplementedCertificateManagerServer) ListCertificateMaps(context.Context, *ListCertificateMapsRequest) (*ListCertificateMapsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificateMaps not implemented")
}
func (*UnimplementedCertificateManagerServer) GetCertificateMap(context.Context, *GetCertificateMapRequest) (*CertificateMap, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateMap not implemented")
}
func (*UnimplementedCertificateManagerServer) CreateCertificateMap(context.Context, *CreateCertificateMapRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificateMap not implemented")
}
func (*UnimplementedCertificateManagerServer) UpdateCertificateMap(context.Context, *UpdateCertificateMapRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificateMap not implemented")
}
func (*UnimplementedCertificateManagerServer) DeleteCertificateMap(context.Context, *DeleteCertificateMapRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificateMap not implemented")
}
func (*UnimplementedCertificateManagerServer) ListCertificateMapEntries(context.Context, *ListCertificateMapEntriesRequest) (*ListCertificateMapEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCertificateMapEntries not implemented")
}
func (*UnimplementedCertificateManagerServer) GetCertificateMapEntry(context.Context, *GetCertificateMapEntryRequest) (*CertificateMapEntry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateMapEntry not implemented")
}
func (*UnimplementedCertificateManagerServer) CreateCertificateMapEntry(context.Context, *CreateCertificateMapEntryRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCertificateMapEntry not implemented")
}
func (*UnimplementedCertificateManagerServer) UpdateCertificateMapEntry(context.Context, *UpdateCertificateMapEntryRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCertificateMapEntry not implemented")
}
func (*UnimplementedCertificateManagerServer) DeleteCertificateMapEntry(context.Context, *DeleteCertificateMapEntryRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCertificateMapEntry not implemented")
}
func (*UnimplementedCertificateManagerServer) ListDnsAuthorizations(context.Context, *ListDnsAuthorizationsRequest) (*ListDnsAuthorizationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDnsAuthorizations not implemented")
}
func (*UnimplementedCertificateManagerServer) GetDnsAuthorization(context.Context, *GetDnsAuthorizationRequest) (*DnsAuthorization, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDnsAuthorization not implemented")
}
func (*UnimplementedCertificateManagerServer) CreateDnsAuthorization(context.Context, *CreateDnsAuthorizationRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDnsAuthorization not implemented")
}
func (*UnimplementedCertificateManagerServer) UpdateDnsAuthorization(context.Context, *UpdateDnsAuthorizationRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDnsAuthorization not implemented")
}
func (*UnimplementedCertificateManagerServer) DeleteDnsAuthorization(context.Context, *DeleteDnsAuthorizationRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDnsAuthorization not implemented")
}

func RegisterCertificateManagerServer(s *grpc.Server, srv CertificateManagerServer) {
	s.RegisterService(&_CertificateManager_serviceDesc, srv)
}

func _CertificateManager_ListCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListCertificates(ctx, req.(*ListCertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetCertificate(ctx, req.(*GetCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateCertificate(ctx, req.(*CreateCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_UpdateCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).UpdateCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/UpdateCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).UpdateCertificate(ctx, req.(*UpdateCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteCertificate(ctx, req.(*DeleteCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_ListCertificateMaps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificateMapsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListCertificateMaps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificateMaps",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListCertificateMaps(ctx, req.(*ListCertificateMapsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetCertificateMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetCertificateMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificateMap",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetCertificateMap(ctx, req.(*GetCertificateMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateCertificateMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateCertificateMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificateMap",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateCertificateMap(ctx, req.(*CreateCertificateMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_UpdateCertificateMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).UpdateCertificateMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/UpdateCertificateMap",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).UpdateCertificateMap(ctx, req.(*UpdateCertificateMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteCertificateMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCertificateMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteCertificateMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificateMap",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteCertificateMap(ctx, req.(*DeleteCertificateMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_ListCertificateMapEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCertificateMapEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListCertificateMapEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/ListCertificateMapEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListCertificateMapEntries(ctx, req.(*ListCertificateMapEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetCertificateMapEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateMapEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetCertificateMapEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/GetCertificateMapEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetCertificateMapEntry(ctx, req.(*GetCertificateMapEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateCertificateMapEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCertificateMapEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateCertificateMapEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/CreateCertificateMapEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateCertificateMapEntry(ctx, req.(*CreateCertificateMapEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_UpdateCertificateMapEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCertificateMapEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).UpdateCertificateMapEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/UpdateCertificateMapEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).UpdateCertificateMapEntry(ctx, req.(*UpdateCertificateMapEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteCertificateMapEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCertificateMapEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteCertificateMapEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/DeleteCertificateMapEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteCertificateMapEntry(ctx, req.(*DeleteCertificateMapEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_ListDnsAuthorizations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDnsAuthorizationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).ListDnsAuthorizations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/ListDnsAuthorizations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).ListDnsAuthorizations(ctx, req.(*ListDnsAuthorizationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_GetDnsAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDnsAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).GetDnsAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/GetDnsAuthorization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).GetDnsAuthorization(ctx, req.(*GetDnsAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_CreateDnsAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDnsAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).CreateDnsAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/CreateDnsAuthorization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).CreateDnsAuthorization(ctx, req.(*CreateDnsAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_UpdateDnsAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDnsAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).UpdateDnsAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/UpdateDnsAuthorization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).UpdateDnsAuthorization(ctx, req.(*UpdateDnsAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManager_DeleteDnsAuthorization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDnsAuthorizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagerServer).DeleteDnsAuthorization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.certificatemanager.v1.CertificateManager/DeleteDnsAuthorization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagerServer).DeleteDnsAuthorization(ctx, req.(*DeleteDnsAuthorizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CertificateManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.certificatemanager.v1.CertificateManager",
	HandlerType: (*CertificateManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCertificates",
			Handler:    _CertificateManager_ListCertificates_Handler,
		},
		{
			MethodName: "GetCertificate",
			Handler:    _CertificateManager_GetCertificate_Handler,
		},
		{
			MethodName: "CreateCertificate",
			Handler:    _CertificateManager_CreateCertificate_Handler,
		},
		{
			MethodName: "UpdateCertificate",
			Handler:    _CertificateManager_UpdateCertificate_Handler,
		},
		{
			MethodName: "DeleteCertificate",
			Handler:    _CertificateManager_DeleteCertificate_Handler,
		},
		{
			MethodName: "ListCertificateMaps",
			Handler:    _CertificateManager_ListCertificateMaps_Handler,
		},
		{
			MethodName: "GetCertificateMap",
			Handler:    _CertificateManager_GetCertificateMap_Handler,
		},
		{
			MethodName: "CreateCertificateMap",
			Handler:    _CertificateManager_CreateCertificateMap_Handler,
		},
		{
			MethodName: "UpdateCertificateMap",
			Handler:    _CertificateManager_UpdateCertificateMap_Handler,
		},
		{
			MethodName: "DeleteCertificateMap",
			Handler:    _CertificateManager_DeleteCertificateMap_Handler,
		},
		{
			MethodName: "ListCertificateMapEntries",
			Handler:    _CertificateManager_ListCertificateMapEntries_Handler,
		},
		{
			MethodName: "GetCertificateMapEntry",
			Handler:    _CertificateManager_GetCertificateMapEntry_Handler,
		},
		{
			MethodName: "CreateCertificateMapEntry",
			Handler:    _CertificateManager_CreateCertificateMapEntry_Handler,
		},
		{
			MethodName: "UpdateCertificateMapEntry",
			Handler:    _CertificateManager_UpdateCertificateMapEntry_Handler,
		},
		{
			MethodName: "DeleteCertificateMapEntry",
			Handler:    _CertificateManager_DeleteCertificateMapEntry_Handler,
		},
		{
			MethodName: "ListDnsAuthorizations",
			Handler:    _CertificateManager_ListDnsAuthorizations_Handler,
		},
		{
			MethodName: "GetDnsAuthorization",
			Handler:    _CertificateManager_GetDnsAuthorization_Handler,
		},
		{
			MethodName: "CreateDnsAuthorization",
			Handler:    _CertificateManager_CreateDnsAuthorization_Handler,
		},
		{
			MethodName: "UpdateDnsAuthorization",
			Handler:    _CertificateManager_UpdateDnsAuthorization_Handler,
		},
		{
			MethodName: "DeleteDnsAuthorization",
			Handler:    _CertificateManager_DeleteDnsAuthorization_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/certificatemanager/v1/certificate_manager.proto",
}
