// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contactcenterinsights/v1/resources.proto

package contactcenterinsights

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible media for the conversation.
type Conversation_Medium int32

const (
	// Default value, if unspecified will default to PHONE_CALL.
	Conversation_MEDIUM_UNSPECIFIED Conversation_Medium = 0
	// The format for conversations that took place over the phone.
	Conversation_PHONE_CALL Conversation_Medium = 1
	// The format for conversations that took place over chat.
	Conversation_CHAT Conversation_Medium = 2
)

// Enum value maps for Conversation_Medium.
var (
	Conversation_Medium_name = map[int32]string{
		0: "MEDIUM_UNSPECIFIED",
		1: "PHONE_CALL",
		2: "CHAT",
	}
	Conversation_Medium_value = map[string]int32{
		"MEDIUM_UNSPECIFIED": 0,
		"PHONE_CALL":         1,
		"CHAT":               2,
	}
)

func (x Conversation_Medium) Enum() *Conversation_Medium {
	p := new(Conversation_Medium)
	*p = x
	return p
}

func (x Conversation_Medium) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Conversation_Medium) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[0].Descriptor()
}

func (Conversation_Medium) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[0]
}

func (x Conversation_Medium) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Conversation_Medium.Descriptor instead.
func (Conversation_Medium) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

// The type of the entity. For most entity types, the associated metadata is a
// Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID (`mid`). The table
// below lists the associated fields for entities that have different
// metadata.
type Entity_Type int32

const (
	// Unspecified.
	Entity_TYPE_UNSPECIFIED Entity_Type = 0
	// Person.
	Entity_PERSON Entity_Type = 1
	// Location.
	Entity_LOCATION Entity_Type = 2
	// Organization.
	Entity_ORGANIZATION Entity_Type = 3
	// Event.
	Entity_EVENT Entity_Type = 4
	// Artwork.
	Entity_WORK_OF_ART Entity_Type = 5
	// Consumer product.
	Entity_CONSUMER_GOOD Entity_Type = 6
	// Other types of entities.
	Entity_OTHER Entity_Type = 7
	// Phone number.
	//
	// The metadata lists the phone number (formatted according to local
	// convention), plus whichever additional elements appear in the text:
	//
	// * `number` - The actual number, broken down into sections according to
	// local convention.
	// * `national_prefix` - Country code, if detected.
	// * `area_code` - Region or area code, if detected.
	// * `extension` - Phone extension (to be dialed after connection), if
	// detected.
	Entity_PHONE_NUMBER Entity_Type = 9
	// Address.
	//
	// The metadata identifies the street number and locality plus whichever
	// additional elements appear in the text:
	//
	// * `street_number` - Street number.
	// * `locality` - City or town.
	// * `street_name` - Street/route name, if detected.
	// * `postal_code` - Postal code, if detected.
	// * `country` - Country, if detected.
	// * `broad_region` - Administrative area, such as the state, if detected.
	// * `narrow_region` - Smaller administrative area, such as county, if
	// detected.
	// * `sublocality` - Used in Asian addresses to demark a district within a
	// city, if detected.
	Entity_ADDRESS Entity_Type = 10
	// Date.
	//
	// The metadata identifies the components of the date:
	//
	// * `year` - Four digit year, if detected.
	// * `month` - Two digit month number, if detected.
	// * `day` - Two digit day number, if detected.
	Entity_DATE Entity_Type = 11
	// Number.
	//
	// The metadata is the number itself.
	Entity_NUMBER Entity_Type = 12
	// Price.
	//
	// The metadata identifies the `value` and `currency`.
	Entity_PRICE Entity_Type = 13
)

// Enum value maps for Entity_Type.
var (
	Entity_Type_name = map[int32]string{
		0:  "TYPE_UNSPECIFIED",
		1:  "PERSON",
		2:  "LOCATION",
		3:  "ORGANIZATION",
		4:  "EVENT",
		5:  "WORK_OF_ART",
		6:  "CONSUMER_GOOD",
		7:  "OTHER",
		9:  "PHONE_NUMBER",
		10: "ADDRESS",
		11: "DATE",
		12: "NUMBER",
		13: "PRICE",
	}
	Entity_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"PERSON":           1,
		"LOCATION":         2,
		"ORGANIZATION":     3,
		"EVENT":            4,
		"WORK_OF_ART":      5,
		"CONSUMER_GOOD":    6,
		"OTHER":            7,
		"PHONE_NUMBER":     9,
		"ADDRESS":          10,
		"DATE":             11,
		"NUMBER":           12,
		"PRICE":            13,
	}
)

func (x Entity_Type) Enum() *Entity_Type {
	p := new(Entity_Type)
	*p = x
	return p
}

func (x Entity_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Entity_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[1].Descriptor()
}

func (Entity_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[1]
}

func (x Entity_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Entity_Type.Descriptor instead.
func (Entity_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{11, 0}
}

// The supported types of mentions.
type EntityMentionData_MentionType int32

const (
	// Unspecified.
	EntityMentionData_MENTION_TYPE_UNSPECIFIED EntityMentionData_MentionType = 0
	// Proper noun.
	EntityMentionData_PROPER EntityMentionData_MentionType = 1
	// Common noun (or noun compound).
	EntityMentionData_COMMON EntityMentionData_MentionType = 2
)

// Enum value maps for EntityMentionData_MentionType.
var (
	EntityMentionData_MentionType_name = map[int32]string{
		0: "MENTION_TYPE_UNSPECIFIED",
		1: "PROPER",
		2: "COMMON",
	}
	EntityMentionData_MentionType_value = map[string]int32{
		"MENTION_TYPE_UNSPECIFIED": 0,
		"PROPER":                   1,
		"COMMON":                   2,
	}
)

func (x EntityMentionData_MentionType) Enum() *EntityMentionData_MentionType {
	p := new(EntityMentionData_MentionType)
	*p = x
	return p
}

func (x EntityMentionData_MentionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntityMentionData_MentionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[2].Descriptor()
}

func (EntityMentionData_MentionType) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[2]
}

func (x EntityMentionData_MentionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntityMentionData_MentionType.Descriptor instead.
func (EntityMentionData_MentionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{18, 0}
}

// State of the model.
type IssueModel_State int32

const (
	// Unspecified.
	IssueModel_STATE_UNSPECIFIED IssueModel_State = 0
	// Model is not deployed but is ready to deploy.
	IssueModel_UNDEPLOYED IssueModel_State = 1
	// Model is being deployed.
	IssueModel_DEPLOYING IssueModel_State = 2
	// Model is deployed and is ready to be used. A model can only be used in
	// analysis if it's in this state.
	IssueModel_DEPLOYED IssueModel_State = 3
	// Model is being undeployed.
	IssueModel_UNDEPLOYING IssueModel_State = 4
	// Model is being deleted.
	IssueModel_DELETING IssueModel_State = 5
)

// Enum value maps for IssueModel_State.
var (
	IssueModel_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "UNDEPLOYED",
		2: "DEPLOYING",
		3: "DEPLOYED",
		4: "UNDEPLOYING",
		5: "DELETING",
	}
	IssueModel_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"UNDEPLOYED":        1,
		"DEPLOYING":         2,
		"DEPLOYED":          3,
		"UNDEPLOYING":       4,
		"DELETING":          5,
	}
)

func (x IssueModel_State) Enum() *IssueModel_State {
	p := new(IssueModel_State)
	*p = x
	return p
}

func (x IssueModel_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IssueModel_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[3].Descriptor()
}

func (IssueModel_State) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[3]
}

func (x IssueModel_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IssueModel_State.Descriptor instead.
func (IssueModel_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{21, 0}
}

// Specifies how to combine each phrase match rule group to determine whether
// there is a match.
type PhraseMatcher_PhraseMatcherType int32

const (
	// Unspecified.
	PhraseMatcher_PHRASE_MATCHER_TYPE_UNSPECIFIED PhraseMatcher_PhraseMatcherType = 0
	// Must meet all phrase match rule groups or there is no match.
	PhraseMatcher_ALL_OF PhraseMatcher_PhraseMatcherType = 1
	// If any of the phrase match rule groups are met, there is a match.
	PhraseMatcher_ANY_OF PhraseMatcher_PhraseMatcherType = 2
)

// Enum value maps for PhraseMatcher_PhraseMatcherType.
var (
	PhraseMatcher_PhraseMatcherType_name = map[int32]string{
		0: "PHRASE_MATCHER_TYPE_UNSPECIFIED",
		1: "ALL_OF",
		2: "ANY_OF",
	}
	PhraseMatcher_PhraseMatcherType_value = map[string]int32{
		"PHRASE_MATCHER_TYPE_UNSPECIFIED": 0,
		"ALL_OF":                          1,
		"ANY_OF":                          2,
	}
)

func (x PhraseMatcher_PhraseMatcherType) Enum() *PhraseMatcher_PhraseMatcherType {
	p := new(PhraseMatcher_PhraseMatcherType)
	*p = x
	return p
}

func (x PhraseMatcher_PhraseMatcherType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PhraseMatcher_PhraseMatcherType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[4].Descriptor()
}

func (PhraseMatcher_PhraseMatcherType) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[4]
}

func (x PhraseMatcher_PhraseMatcherType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PhraseMatcher_PhraseMatcherType.Descriptor instead.
func (PhraseMatcher_PhraseMatcherType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{24, 0}
}

// Specifies how to combine each phrase match rule for whether there is a
// match.
type PhraseMatchRuleGroup_PhraseMatchRuleGroupType int32

const (
	// Unspecified.
	PhraseMatchRuleGroup_PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED PhraseMatchRuleGroup_PhraseMatchRuleGroupType = 0
	// Must meet all phrase match rules or there is no match.
	PhraseMatchRuleGroup_ALL_OF PhraseMatchRuleGroup_PhraseMatchRuleGroupType = 1
	// If any of the phrase match rules are met, there is a match.
	PhraseMatchRuleGroup_ANY_OF PhraseMatchRuleGroup_PhraseMatchRuleGroupType = 2
)

// Enum value maps for PhraseMatchRuleGroup_PhraseMatchRuleGroupType.
var (
	PhraseMatchRuleGroup_PhraseMatchRuleGroupType_name = map[int32]string{
		0: "PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED",
		1: "ALL_OF",
		2: "ANY_OF",
	}
	PhraseMatchRuleGroup_PhraseMatchRuleGroupType_value = map[string]int32{
		"PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED": 0,
		"ALL_OF": 1,
		"ANY_OF": 2,
	}
)

func (x PhraseMatchRuleGroup_PhraseMatchRuleGroupType) Enum() *PhraseMatchRuleGroup_PhraseMatchRuleGroupType {
	p := new(PhraseMatchRuleGroup_PhraseMatchRuleGroupType)
	*p = x
	return p
}

func (x PhraseMatchRuleGroup_PhraseMatchRuleGroupType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PhraseMatchRuleGroup_PhraseMatchRuleGroupType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[5].Descriptor()
}

func (PhraseMatchRuleGroup_PhraseMatchRuleGroupType) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[5]
}

func (x PhraseMatchRuleGroup_PhraseMatchRuleGroupType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PhraseMatchRuleGroup_PhraseMatchRuleGroupType.Descriptor instead.
func (PhraseMatchRuleGroup_PhraseMatchRuleGroupType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{25, 0}
}

// The correctness level of an answer.
type AnswerFeedback_CorrectnessLevel int32

const (
	// Correctness level unspecified.
	AnswerFeedback_CORRECTNESS_LEVEL_UNSPECIFIED AnswerFeedback_CorrectnessLevel = 0
	// Answer is totally wrong.
	AnswerFeedback_NOT_CORRECT AnswerFeedback_CorrectnessLevel = 1
	// Answer is partially correct.
	AnswerFeedback_PARTIALLY_CORRECT AnswerFeedback_CorrectnessLevel = 2
	// Answer is fully correct.
	AnswerFeedback_FULLY_CORRECT AnswerFeedback_CorrectnessLevel = 3
)

// Enum value maps for AnswerFeedback_CorrectnessLevel.
var (
	AnswerFeedback_CorrectnessLevel_name = map[int32]string{
		0: "CORRECTNESS_LEVEL_UNSPECIFIED",
		1: "NOT_CORRECT",
		2: "PARTIALLY_CORRECT",
		3: "FULLY_CORRECT",
	}
	AnswerFeedback_CorrectnessLevel_value = map[string]int32{
		"CORRECTNESS_LEVEL_UNSPECIFIED": 0,
		"NOT_CORRECT":                   1,
		"PARTIALLY_CORRECT":             2,
		"FULLY_CORRECT":                 3,
	}
)

func (x AnswerFeedback_CorrectnessLevel) Enum() *AnswerFeedback_CorrectnessLevel {
	p := new(AnswerFeedback_CorrectnessLevel)
	*p = x
	return p
}

func (x AnswerFeedback_CorrectnessLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnswerFeedback_CorrectnessLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[6].Descriptor()
}

func (AnswerFeedback_CorrectnessLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[6]
}

func (x AnswerFeedback_CorrectnessLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnswerFeedback_CorrectnessLevel.Descriptor instead.
func (AnswerFeedback_CorrectnessLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{31, 0}
}

// The role of the participant.
type ConversationParticipant_Role int32

const (
	// Participant's role is not set.
	ConversationParticipant_ROLE_UNSPECIFIED ConversationParticipant_Role = 0
	// Participant is a human agent.
	ConversationParticipant_HUMAN_AGENT ConversationParticipant_Role = 1
	// Participant is an automated agent.
	ConversationParticipant_AUTOMATED_AGENT ConversationParticipant_Role = 2
	// Participant is an end user who conversed with the contact center.
	ConversationParticipant_END_USER ConversationParticipant_Role = 3
	// Participant is either a human or automated agent.
	ConversationParticipant_ANY_AGENT ConversationParticipant_Role = 4
)

// Enum value maps for ConversationParticipant_Role.
var (
	ConversationParticipant_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "HUMAN_AGENT",
		2: "AUTOMATED_AGENT",
		3: "END_USER",
		4: "ANY_AGENT",
	}
	ConversationParticipant_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"HUMAN_AGENT":      1,
		"AUTOMATED_AGENT":  2,
		"END_USER":         3,
		"ANY_AGENT":        4,
	}
)

func (x ConversationParticipant_Role) Enum() *ConversationParticipant_Role {
	p := new(ConversationParticipant_Role)
	*p = x
	return p
}

func (x ConversationParticipant_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConversationParticipant_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[7].Descriptor()
}

func (ConversationParticipant_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes[7]
}

func (x ConversationParticipant_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConversationParticipant_Role.Descriptor instead.
func (ConversationParticipant_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{37, 0}
}

// The conversation resource.
type Conversation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata that applies to the conversation.
	//
	// Types that are assignable to Metadata:
	//	*Conversation_CallMetadata_
	Metadata isConversation_Metadata `protobuf_oneof:"metadata"`
	// A time to live expiration setting, can be either a specified timestamp or a
	// duration from the time that the conversation creation request was received.
	// Conversations with an expiration set will be removed up to 24 hours after
	// the specified time.
	//
	// Types that are assignable to Expiration:
	//	*Conversation_ExpireTime
	//	*Conversation_Ttl
	Expiration isConversation_Expiration `protobuf_oneof:"expiration"`
	// Immutable. The resource name of the conversation.
	// Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The source of the audio and transcription for the conversation.
	DataSource *ConversationDataSource `protobuf:"bytes,2,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	// Output only. The time at which the conversation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The most recent time at which the conversation was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The time at which the conversation started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// A user-specified language code for the conversation.
	LanguageCode string `protobuf:"bytes,14,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// An opaque, user-specified string representing the human agent who handled
	// the conversation.
	AgentId string `protobuf:"bytes,5,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	// A map for the user to specify any custom fields. A maximum of 20 labels per
	// conversation is allowed, with a maximum of 256 characters per entry.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The conversation transcript.
	Transcript *Conversation_Transcript `protobuf:"bytes,8,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// Immutable. The conversation medium, if unspecified will default to PHONE_CALL.
	Medium Conversation_Medium `protobuf:"varint,9,opt,name=medium,proto3,enum=google.cloud.contactcenterinsights.v1.Conversation_Medium" json:"medium,omitempty"`
	// Output only. The duration of the conversation.
	Duration *durationpb.Duration `protobuf:"bytes,10,opt,name=duration,proto3" json:"duration,omitempty"`
	// Output only. The number of turns in the conversation.
	TurnCount int32 `protobuf:"varint,11,opt,name=turn_count,json=turnCount,proto3" json:"turn_count,omitempty"`
	// Output only. The conversation's latest analysis, if one exists.
	LatestAnalysis *Analysis `protobuf:"bytes,12,opt,name=latest_analysis,json=latestAnalysis,proto3" json:"latest_analysis,omitempty"`
	// Output only. The annotations that were generated during the customer and agent
	// interaction.
	RuntimeAnnotations []*RuntimeAnnotation `protobuf:"bytes,13,rep,name=runtime_annotations,json=runtimeAnnotations,proto3" json:"runtime_annotations,omitempty"`
	// Output only. All the matched Dialogflow intents in the call. The key corresponds to a
	// Dialogflow intent, format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntents map[string]*DialogflowIntent `protobuf:"bytes,18,rep,name=dialogflow_intents,json=dialogflowIntents,proto3" json:"dialogflow_intents,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Obfuscated user ID which the customer sent to us.
	ObfuscatedUserId string `protobuf:"bytes,21,opt,name=obfuscated_user_id,json=obfuscatedUserId,proto3" json:"obfuscated_user_id,omitempty"`
}

func (x *Conversation) Reset() {
	*x = Conversation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation) ProtoMessage() {}

func (x *Conversation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation.ProtoReflect.Descriptor instead.
func (*Conversation) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (m *Conversation) GetMetadata() isConversation_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *Conversation) GetCallMetadata() *Conversation_CallMetadata {
	if x, ok := x.GetMetadata().(*Conversation_CallMetadata_); ok {
		return x.CallMetadata
	}
	return nil
}

func (m *Conversation) GetExpiration() isConversation_Expiration {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (x *Conversation) GetExpireTime() *timestamppb.Timestamp {
	if x, ok := x.GetExpiration().(*Conversation_ExpireTime); ok {
		return x.ExpireTime
	}
	return nil
}

func (x *Conversation) GetTtl() *durationpb.Duration {
	if x, ok := x.GetExpiration().(*Conversation_Ttl); ok {
		return x.Ttl
	}
	return nil
}

func (x *Conversation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Conversation) GetDataSource() *ConversationDataSource {
	if x != nil {
		return x.DataSource
	}
	return nil
}

func (x *Conversation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Conversation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Conversation) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Conversation) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Conversation) GetAgentId() string {
	if x != nil {
		return x.AgentId
	}
	return ""
}

func (x *Conversation) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Conversation) GetTranscript() *Conversation_Transcript {
	if x != nil {
		return x.Transcript
	}
	return nil
}

func (x *Conversation) GetMedium() Conversation_Medium {
	if x != nil {
		return x.Medium
	}
	return Conversation_MEDIUM_UNSPECIFIED
}

func (x *Conversation) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *Conversation) GetTurnCount() int32 {
	if x != nil {
		return x.TurnCount
	}
	return 0
}

func (x *Conversation) GetLatestAnalysis() *Analysis {
	if x != nil {
		return x.LatestAnalysis
	}
	return nil
}

func (x *Conversation) GetRuntimeAnnotations() []*RuntimeAnnotation {
	if x != nil {
		return x.RuntimeAnnotations
	}
	return nil
}

func (x *Conversation) GetDialogflowIntents() map[string]*DialogflowIntent {
	if x != nil {
		return x.DialogflowIntents
	}
	return nil
}

func (x *Conversation) GetObfuscatedUserId() string {
	if x != nil {
		return x.ObfuscatedUserId
	}
	return ""
}

type isConversation_Metadata interface {
	isConversation_Metadata()
}

type Conversation_CallMetadata_ struct {
	// Call-specific metadata.
	CallMetadata *Conversation_CallMetadata `protobuf:"bytes,7,opt,name=call_metadata,json=callMetadata,proto3,oneof"`
}

func (*Conversation_CallMetadata_) isConversation_Metadata() {}

type isConversation_Expiration interface {
	isConversation_Expiration()
}

type Conversation_ExpireTime struct {
	// The time at which this conversation should expire. After this time, the
	// conversation data and any associated analyses will be deleted.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=expire_time,json=expireTime,proto3,oneof"`
}

type Conversation_Ttl struct {
	// Input only. The TTL for this resource. If specified, then this TTL will
	// be used to calculate the expire time.
	Ttl *durationpb.Duration `protobuf:"bytes,16,opt,name=ttl,proto3,oneof"`
}

func (*Conversation_ExpireTime) isConversation_Expiration() {}

func (*Conversation_Ttl) isConversation_Expiration() {}

// The analysis resource.
type Analysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the analysis.
	// Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which the analysis was requested.
	RequestTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// Output only. The time at which the analysis was created, which occurs when the
	// long-running operation completes.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The result of the analysis, which is populated when the analysis
	// finishes.
	AnalysisResult *AnalysisResult `protobuf:"bytes,7,opt,name=analysis_result,json=analysisResult,proto3" json:"analysis_result,omitempty"`
}

func (x *Analysis) Reset() {
	*x = Analysis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Analysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Analysis) ProtoMessage() {}

func (x *Analysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Analysis.ProtoReflect.Descriptor instead.
func (*Analysis) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *Analysis) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Analysis) GetRequestTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RequestTime
	}
	return nil
}

func (x *Analysis) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Analysis) GetAnalysisResult() *AnalysisResult {
	if x != nil {
		return x.AnalysisResult
	}
	return nil
}

// The conversation source, which is a combination of transcript and audio.
type ConversationDataSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the conversation.
	//
	// Types that are assignable to Source:
	//	*ConversationDataSource_GcsSource
	//	*ConversationDataSource_DialogflowSource
	Source isConversationDataSource_Source `protobuf_oneof:"source"`
}

func (x *ConversationDataSource) Reset() {
	*x = ConversationDataSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversationDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationDataSource) ProtoMessage() {}

func (x *ConversationDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationDataSource.ProtoReflect.Descriptor instead.
func (*ConversationDataSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (m *ConversationDataSource) GetSource() isConversationDataSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ConversationDataSource) GetGcsSource() *GcsSource {
	if x, ok := x.GetSource().(*ConversationDataSource_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ConversationDataSource) GetDialogflowSource() *DialogflowSource {
	if x, ok := x.GetSource().(*ConversationDataSource_DialogflowSource); ok {
		return x.DialogflowSource
	}
	return nil
}

type isConversationDataSource_Source interface {
	isConversationDataSource_Source()
}

type ConversationDataSource_GcsSource struct {
	// A Cloud Storage location specification for the audio and transcript.
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ConversationDataSource_DialogflowSource struct {
	// The source when the conversation comes from Dialogflow.
	DialogflowSource *DialogflowSource `protobuf:"bytes,3,opt,name=dialogflow_source,json=dialogflowSource,proto3,oneof"`
}

func (*ConversationDataSource_GcsSource) isConversationDataSource_Source() {}

func (*ConversationDataSource_DialogflowSource) isConversationDataSource_Source() {}

// A Cloud Storage source of conversation data.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage URI that points to a file that contains the conversation
	// audio.
	AudioUri string `protobuf:"bytes,1,opt,name=audio_uri,json=audioUri,proto3" json:"audio_uri,omitempty"`
	// Immutable. Cloud Storage URI that points to a file that contains the conversation
	// transcript.
	TranscriptUri string `protobuf:"bytes,2,opt,name=transcript_uri,json=transcriptUri,proto3" json:"transcript_uri,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *GcsSource) GetAudioUri() string {
	if x != nil {
		return x.AudioUri
	}
	return ""
}

func (x *GcsSource) GetTranscriptUri() string {
	if x != nil {
		return x.TranscriptUri
	}
	return ""
}

// A Dialogflow source of conversation data.
type DialogflowSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the Dialogflow conversation that this conversation
	// resource is derived from. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}
	DialogflowConversation string `protobuf:"bytes,1,opt,name=dialogflow_conversation,json=dialogflowConversation,proto3" json:"dialogflow_conversation,omitempty"`
	// Cloud Storage URI that points to a file that contains the conversation
	// audio.
	AudioUri string `protobuf:"bytes,3,opt,name=audio_uri,json=audioUri,proto3" json:"audio_uri,omitempty"`
}

func (x *DialogflowSource) Reset() {
	*x = DialogflowSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DialogflowSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DialogflowSource) ProtoMessage() {}

func (x *DialogflowSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DialogflowSource.ProtoReflect.Descriptor instead.
func (*DialogflowSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *DialogflowSource) GetDialogflowConversation() string {
	if x != nil {
		return x.DialogflowConversation
	}
	return ""
}

func (x *DialogflowSource) GetAudioUri() string {
	if x != nil {
		return x.AudioUri
	}
	return ""
}

// The result of an analysis.
type AnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata discovered during analysis.
	//
	// Types that are assignable to Metadata:
	//	*AnalysisResult_CallAnalysisMetadata_
	Metadata isAnalysisResult_Metadata `protobuf_oneof:"metadata"`
	// The time at which the analysis ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *AnalysisResult) Reset() {
	*x = AnalysisResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalysisResult) ProtoMessage() {}

func (x *AnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalysisResult.ProtoReflect.Descriptor instead.
func (*AnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (m *AnalysisResult) GetMetadata() isAnalysisResult_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *AnalysisResult) GetCallAnalysisMetadata() *AnalysisResult_CallAnalysisMetadata {
	if x, ok := x.GetMetadata().(*AnalysisResult_CallAnalysisMetadata_); ok {
		return x.CallAnalysisMetadata
	}
	return nil
}

func (x *AnalysisResult) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isAnalysisResult_Metadata interface {
	isAnalysisResult_Metadata()
}

type AnalysisResult_CallAnalysisMetadata_ struct {
	// Call-specific metadata created by the analysis.
	CallAnalysisMetadata *AnalysisResult_CallAnalysisMetadata `protobuf:"bytes,2,opt,name=call_analysis_metadata,json=callAnalysisMetadata,proto3,oneof"`
}

func (*AnalysisResult_CallAnalysisMetadata_) isAnalysisResult_Metadata() {}

// Issue Modeling result on a conversation.
type IssueModelResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Issue model that generates the result.
	// Format: projects/{project}/locations/{location}/issueModels/{issue_model}
	IssueModel string `protobuf:"bytes,1,opt,name=issue_model,json=issueModel,proto3" json:"issue_model,omitempty"`
	// All the matched issues.
	Issues []*IssueAssignment `protobuf:"bytes,2,rep,name=issues,proto3" json:"issues,omitempty"`
}

func (x *IssueModelResult) Reset() {
	*x = IssueModelResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IssueModelResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IssueModelResult) ProtoMessage() {}

func (x *IssueModelResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IssueModelResult.ProtoReflect.Descriptor instead.
func (*IssueModelResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *IssueModelResult) GetIssueModel() string {
	if x != nil {
		return x.IssueModel
	}
	return ""
}

func (x *IssueModelResult) GetIssues() []*IssueAssignment {
	if x != nil {
		return x.Issues
	}
	return nil
}

// One channel of conversation-level sentiment data.
type ConversationLevelSentiment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The channel of the audio that the data applies to.
	ChannelTag int32 `protobuf:"varint,1,opt,name=channel_tag,json=channelTag,proto3" json:"channel_tag,omitempty"`
	// Data specifying sentiment.
	SentimentData *SentimentData `protobuf:"bytes,2,opt,name=sentiment_data,json=sentimentData,proto3" json:"sentiment_data,omitempty"`
}

func (x *ConversationLevelSentiment) Reset() {
	*x = ConversationLevelSentiment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversationLevelSentiment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationLevelSentiment) ProtoMessage() {}

func (x *ConversationLevelSentiment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationLevelSentiment.ProtoReflect.Descriptor instead.
func (*ConversationLevelSentiment) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *ConversationLevelSentiment) GetChannelTag() int32 {
	if x != nil {
		return x.ChannelTag
	}
	return 0
}

func (x *ConversationLevelSentiment) GetSentimentData() *SentimentData {
	if x != nil {
		return x.SentimentData
	}
	return nil
}

// Information about the issue.
type IssueAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the assigned issue.
	Issue string `protobuf:"bytes,1,opt,name=issue,proto3" json:"issue,omitempty"`
	// Score indicating the likelihood of the issue assignment.
	// currently bounded on [0,1].
	Score float64 `protobuf:"fixed64,2,opt,name=score,proto3" json:"score,omitempty"`
	// Immutable. Display name of the assigned issue. This field is set at time of analyis
	// and immutable since then.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *IssueAssignment) Reset() {
	*x = IssueAssignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IssueAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IssueAssignment) ProtoMessage() {}

func (x *IssueAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IssueAssignment.ProtoReflect.Descriptor instead.
func (*IssueAssignment) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *IssueAssignment) GetIssue() string {
	if x != nil {
		return x.Issue
	}
	return ""
}

func (x *IssueAssignment) GetScore() float64 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *IssueAssignment) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// A piece of metadata that applies to a window of a call.
type CallAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data in the annotation.
	//
	// Types that are assignable to Data:
	//	*CallAnnotation_InterruptionData
	//	*CallAnnotation_SentimentData
	//	*CallAnnotation_SilenceData
	//	*CallAnnotation_HoldData
	//	*CallAnnotation_EntityMentionData
	//	*CallAnnotation_IntentMatchData
	//	*CallAnnotation_PhraseMatchData
	Data isCallAnnotation_Data `protobuf_oneof:"data"`
	// The channel of the audio where the annotation occurs. For single-channel
	// audio, this field is not populated.
	ChannelTag int32 `protobuf:"varint,1,opt,name=channel_tag,json=channelTag,proto3" json:"channel_tag,omitempty"`
	// The boundary in the conversation where the annotation starts, inclusive.
	AnnotationStartBoundary *AnnotationBoundary `protobuf:"bytes,4,opt,name=annotation_start_boundary,json=annotationStartBoundary,proto3" json:"annotation_start_boundary,omitempty"`
	// The boundary in the conversation where the annotation ends, inclusive.
	AnnotationEndBoundary *AnnotationBoundary `protobuf:"bytes,5,opt,name=annotation_end_boundary,json=annotationEndBoundary,proto3" json:"annotation_end_boundary,omitempty"`
}

func (x *CallAnnotation) Reset() {
	*x = CallAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CallAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallAnnotation) ProtoMessage() {}

func (x *CallAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallAnnotation.ProtoReflect.Descriptor instead.
func (*CallAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{9}
}

func (m *CallAnnotation) GetData() isCallAnnotation_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *CallAnnotation) GetInterruptionData() *InterruptionData {
	if x, ok := x.GetData().(*CallAnnotation_InterruptionData); ok {
		return x.InterruptionData
	}
	return nil
}

func (x *CallAnnotation) GetSentimentData() *SentimentData {
	if x, ok := x.GetData().(*CallAnnotation_SentimentData); ok {
		return x.SentimentData
	}
	return nil
}

func (x *CallAnnotation) GetSilenceData() *SilenceData {
	if x, ok := x.GetData().(*CallAnnotation_SilenceData); ok {
		return x.SilenceData
	}
	return nil
}

func (x *CallAnnotation) GetHoldData() *HoldData {
	if x, ok := x.GetData().(*CallAnnotation_HoldData); ok {
		return x.HoldData
	}
	return nil
}

func (x *CallAnnotation) GetEntityMentionData() *EntityMentionData {
	if x, ok := x.GetData().(*CallAnnotation_EntityMentionData); ok {
		return x.EntityMentionData
	}
	return nil
}

func (x *CallAnnotation) GetIntentMatchData() *IntentMatchData {
	if x, ok := x.GetData().(*CallAnnotation_IntentMatchData); ok {
		return x.IntentMatchData
	}
	return nil
}

func (x *CallAnnotation) GetPhraseMatchData() *PhraseMatchData {
	if x, ok := x.GetData().(*CallAnnotation_PhraseMatchData); ok {
		return x.PhraseMatchData
	}
	return nil
}

func (x *CallAnnotation) GetChannelTag() int32 {
	if x != nil {
		return x.ChannelTag
	}
	return 0
}

func (x *CallAnnotation) GetAnnotationStartBoundary() *AnnotationBoundary {
	if x != nil {
		return x.AnnotationStartBoundary
	}
	return nil
}

func (x *CallAnnotation) GetAnnotationEndBoundary() *AnnotationBoundary {
	if x != nil {
		return x.AnnotationEndBoundary
	}
	return nil
}

type isCallAnnotation_Data interface {
	isCallAnnotation_Data()
}

type CallAnnotation_InterruptionData struct {
	// Data specifying an interruption.
	InterruptionData *InterruptionData `protobuf:"bytes,10,opt,name=interruption_data,json=interruptionData,proto3,oneof"`
}

type CallAnnotation_SentimentData struct {
	// Data specifying sentiment.
	SentimentData *SentimentData `protobuf:"bytes,11,opt,name=sentiment_data,json=sentimentData,proto3,oneof"`
}

type CallAnnotation_SilenceData struct {
	// Data specifying silence.
	SilenceData *SilenceData `protobuf:"bytes,12,opt,name=silence_data,json=silenceData,proto3,oneof"`
}

type CallAnnotation_HoldData struct {
	// Data specifying a hold.
	HoldData *HoldData `protobuf:"bytes,13,opt,name=hold_data,json=holdData,proto3,oneof"`
}

type CallAnnotation_EntityMentionData struct {
	// Data specifying an entity mention.
	EntityMentionData *EntityMentionData `protobuf:"bytes,15,opt,name=entity_mention_data,json=entityMentionData,proto3,oneof"`
}

type CallAnnotation_IntentMatchData struct {
	// Data specifying an intent match.
	IntentMatchData *IntentMatchData `protobuf:"bytes,16,opt,name=intent_match_data,json=intentMatchData,proto3,oneof"`
}

type CallAnnotation_PhraseMatchData struct {
	// Data specifying a phrase match.
	PhraseMatchData *PhraseMatchData `protobuf:"bytes,17,opt,name=phrase_match_data,json=phraseMatchData,proto3,oneof"`
}

func (*CallAnnotation_InterruptionData) isCallAnnotation_Data() {}

func (*CallAnnotation_SentimentData) isCallAnnotation_Data() {}

func (*CallAnnotation_SilenceData) isCallAnnotation_Data() {}

func (*CallAnnotation_HoldData) isCallAnnotation_Data() {}

func (*CallAnnotation_EntityMentionData) isCallAnnotation_Data() {}

func (*CallAnnotation_IntentMatchData) isCallAnnotation_Data() {}

func (*CallAnnotation_PhraseMatchData) isCallAnnotation_Data() {}

// A point in a conversation that marks the start or the end of an annotation.
type AnnotationBoundary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A detailed boundary, which describes a more specific point.
	//
	// Types that are assignable to DetailedBoundary:
	//	*AnnotationBoundary_WordIndex
	DetailedBoundary isAnnotationBoundary_DetailedBoundary `protobuf_oneof:"detailed_boundary"`
	// The index in the sequence of transcribed pieces of the conversation where
	// the boundary is located. This index starts at zero.
	TranscriptIndex int32 `protobuf:"varint,1,opt,name=transcript_index,json=transcriptIndex,proto3" json:"transcript_index,omitempty"`
}

func (x *AnnotationBoundary) Reset() {
	*x = AnnotationBoundary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationBoundary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationBoundary) ProtoMessage() {}

func (x *AnnotationBoundary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationBoundary.ProtoReflect.Descriptor instead.
func (*AnnotationBoundary) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{10}
}

func (m *AnnotationBoundary) GetDetailedBoundary() isAnnotationBoundary_DetailedBoundary {
	if m != nil {
		return m.DetailedBoundary
	}
	return nil
}

func (x *AnnotationBoundary) GetWordIndex() int32 {
	if x, ok := x.GetDetailedBoundary().(*AnnotationBoundary_WordIndex); ok {
		return x.WordIndex
	}
	return 0
}

func (x *AnnotationBoundary) GetTranscriptIndex() int32 {
	if x != nil {
		return x.TranscriptIndex
	}
	return 0
}

type isAnnotationBoundary_DetailedBoundary interface {
	isAnnotationBoundary_DetailedBoundary()
}

type AnnotationBoundary_WordIndex struct {
	// The word index of this boundary with respect to the first word in the
	// transcript piece. This index starts at zero.
	WordIndex int32 `protobuf:"varint,3,opt,name=word_index,json=wordIndex,proto3,oneof"`
}

func (*AnnotationBoundary_WordIndex) isAnnotationBoundary_DetailedBoundary() {}

// The data for an entity annotation.
// Represents a phrase in the conversation that is a known entity, such
// as a person, an organization, or location.
type Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The representative name for the entity.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The entity type.
	Type Entity_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.contactcenterinsights.v1.Entity_Type" json:"type,omitempty"`
	// Metadata associated with the entity.
	//
	// For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`)
	// and Knowledge Graph MID (`mid`), if they are available. For the metadata
	// associated with other entity types, see the Type table below.
	Metadata map[string]string `protobuf:"bytes,3,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The salience score associated with the entity in the [0, 1.0] range.
	//
	// The salience score for an entity provides information about the
	// importance or centrality of that entity to the entire document text.
	// Scores closer to 0 are less salient, while scores closer to 1.0 are highly
	// salient.
	Salience float32 `protobuf:"fixed32,4,opt,name=salience,proto3" json:"salience,omitempty"`
	// The aggregate sentiment expressed for this entity in the conversation.
	Sentiment *SentimentData `protobuf:"bytes,5,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
}

func (x *Entity) Reset() {
	*x = Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity) ProtoMessage() {}

func (x *Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity.ProtoReflect.Descriptor instead.
func (*Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{11}
}

func (x *Entity) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Entity) GetType() Entity_Type {
	if x != nil {
		return x.Type
	}
	return Entity_TYPE_UNSPECIFIED
}

func (x *Entity) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Entity) GetSalience() float32 {
	if x != nil {
		return x.Salience
	}
	return 0
}

func (x *Entity) GetSentiment() *SentimentData {
	if x != nil {
		return x.Sentiment
	}
	return nil
}

// The data for an intent.
// Represents a detected intent in the conversation, for example MAKES_PROMISE.
type Intent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the intent.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The human-readable name of the intent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *Intent) Reset() {
	*x = Intent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent) ProtoMessage() {}

func (x *Intent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent.ProtoReflect.Descriptor instead.
func (*Intent) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{12}
}

func (x *Intent) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Intent) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// The data for a matched phrase matcher.
// Represents information identifying a phrase matcher for a given match.
type PhraseMatchData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier (the resource name) of the phrase matcher.
	PhraseMatcher string `protobuf:"bytes,1,opt,name=phrase_matcher,json=phraseMatcher,proto3" json:"phrase_matcher,omitempty"`
	// The human-readable name of the phrase matcher.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *PhraseMatchData) Reset() {
	*x = PhraseMatchData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhraseMatchData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhraseMatchData) ProtoMessage() {}

func (x *PhraseMatchData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhraseMatchData.ProtoReflect.Descriptor instead.
func (*PhraseMatchData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{13}
}

func (x *PhraseMatchData) GetPhraseMatcher() string {
	if x != nil {
		return x.PhraseMatcher
	}
	return ""
}

func (x *PhraseMatchData) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// The data for a Dialogflow intent.
// Represents a detected intent in the conversation, e.g. MAKES_PROMISE.
type DialogflowIntent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The human-readable name of the intent.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *DialogflowIntent) Reset() {
	*x = DialogflowIntent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DialogflowIntent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DialogflowIntent) ProtoMessage() {}

func (x *DialogflowIntent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DialogflowIntent.ProtoReflect.Descriptor instead.
func (*DialogflowIntent) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{14}
}

func (x *DialogflowIntent) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// The data for an interruption annotation.
type InterruptionData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InterruptionData) Reset() {
	*x = InterruptionData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterruptionData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterruptionData) ProtoMessage() {}

func (x *InterruptionData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterruptionData.ProtoReflect.Descriptor instead.
func (*InterruptionData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{15}
}

// The data for a silence annotation.
type SilenceData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SilenceData) Reset() {
	*x = SilenceData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SilenceData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SilenceData) ProtoMessage() {}

func (x *SilenceData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SilenceData.ProtoReflect.Descriptor instead.
func (*SilenceData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{16}
}

// The data for a hold annotation.
type HoldData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *HoldData) Reset() {
	*x = HoldData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HoldData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HoldData) ProtoMessage() {}

func (x *HoldData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HoldData.ProtoReflect.Descriptor instead.
func (*HoldData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{17}
}

// The data for an entity mention annotation.
// This represents a mention of an `Entity` in the conversation.
type EntityMentionData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key of this entity in conversation entities.
	// Can be used to retrieve the exact `Entity` this mention is attached to.
	EntityUniqueId string `protobuf:"bytes,1,opt,name=entity_unique_id,json=entityUniqueId,proto3" json:"entity_unique_id,omitempty"`
	// The type of the entity mention.
	Type EntityMentionData_MentionType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.contactcenterinsights.v1.EntityMentionData_MentionType" json:"type,omitempty"`
	// Sentiment expressed for this mention of the entity.
	Sentiment *SentimentData `protobuf:"bytes,3,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
}

func (x *EntityMentionData) Reset() {
	*x = EntityMentionData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntityMentionData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityMentionData) ProtoMessage() {}

func (x *EntityMentionData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityMentionData.ProtoReflect.Descriptor instead.
func (*EntityMentionData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{18}
}

func (x *EntityMentionData) GetEntityUniqueId() string {
	if x != nil {
		return x.EntityUniqueId
	}
	return ""
}

func (x *EntityMentionData) GetType() EntityMentionData_MentionType {
	if x != nil {
		return x.Type
	}
	return EntityMentionData_MENTION_TYPE_UNSPECIFIED
}

func (x *EntityMentionData) GetSentiment() *SentimentData {
	if x != nil {
		return x.Sentiment
	}
	return nil
}

// The data for an intent match.
// Represents an intent match for a text segment in the conversation. A text
// segment can be part of a sentence, a complete sentence, or an utterance
// with multiple sentences.
type IntentMatchData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the matched intent.
	// Can be used to retrieve the corresponding intent information.
	IntentUniqueId string `protobuf:"bytes,1,opt,name=intent_unique_id,json=intentUniqueId,proto3" json:"intent_unique_id,omitempty"`
}

func (x *IntentMatchData) Reset() {
	*x = IntentMatchData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentMatchData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentMatchData) ProtoMessage() {}

func (x *IntentMatchData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentMatchData.ProtoReflect.Descriptor instead.
func (*IntentMatchData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{19}
}

func (x *IntentMatchData) GetIntentUniqueId() string {
	if x != nil {
		return x.IntentUniqueId
	}
	return ""
}

// The data for a sentiment annotation.
type SentimentData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A non-negative number from 0 to infinity which represents the abolute
	// magnitude of sentiment regardless of score.
	Magnitude float32 `protobuf:"fixed32,1,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
	// The sentiment score between -1.0 (negative) and 1.0 (positive).
	Score float32 `protobuf:"fixed32,2,opt,name=score,proto3" json:"score,omitempty"`
}

func (x *SentimentData) Reset() {
	*x = SentimentData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SentimentData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SentimentData) ProtoMessage() {}

func (x *SentimentData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SentimentData.ProtoReflect.Descriptor instead.
func (*SentimentData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{20}
}

func (x *SentimentData) GetMagnitude() float32 {
	if x != nil {
		return x.Magnitude
	}
	return 0
}

func (x *SentimentData) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

// The issue model resource.
type IssueModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the issue model.
	// Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The representative name for the issue model.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The time at which this issue model was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The most recent time at which the issue model was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. State of the model.
	State IssueModel_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.contactcenterinsights.v1.IssueModel_State" json:"state,omitempty"`
	// Configs for the input data that used to create the issue model.
	InputDataConfig *IssueModel_InputDataConfig `protobuf:"bytes,6,opt,name=input_data_config,json=inputDataConfig,proto3" json:"input_data_config,omitempty"`
	// Output only. Immutable. The issue model's label statistics on its training data.
	TrainingStats *IssueModelLabelStats `protobuf:"bytes,7,opt,name=training_stats,json=trainingStats,proto3" json:"training_stats,omitempty"`
}

func (x *IssueModel) Reset() {
	*x = IssueModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IssueModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IssueModel) ProtoMessage() {}

func (x *IssueModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IssueModel.ProtoReflect.Descriptor instead.
func (*IssueModel) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{21}
}

func (x *IssueModel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IssueModel) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *IssueModel) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *IssueModel) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *IssueModel) GetState() IssueModel_State {
	if x != nil {
		return x.State
	}
	return IssueModel_STATE_UNSPECIFIED
}

func (x *IssueModel) GetInputDataConfig() *IssueModel_InputDataConfig {
	if x != nil {
		return x.InputDataConfig
	}
	return nil
}

func (x *IssueModel) GetTrainingStats() *IssueModelLabelStats {
	if x != nil {
		return x.TrainingStats
	}
	return nil
}

// The issue resource.
type Issue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the issue.
	// Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The representative name for the issue.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The time at which this issue was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The most recent time that this issue was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Issue) Reset() {
	*x = Issue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Issue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Issue) ProtoMessage() {}

func (x *Issue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Issue.ProtoReflect.Descriptor instead.
func (*Issue) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{22}
}

func (x *Issue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Issue) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Issue) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Issue) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Aggregated statistics about an issue model.
type IssueModelLabelStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of conversations the issue model has analyzed at this point in time.
	AnalyzedConversationsCount int64 `protobuf:"varint,1,opt,name=analyzed_conversations_count,json=analyzedConversationsCount,proto3" json:"analyzed_conversations_count,omitempty"`
	// Number of analyzed conversations for which no issue was applicable at this
	// point in time.
	UnclassifiedConversationsCount int64 `protobuf:"varint,2,opt,name=unclassified_conversations_count,json=unclassifiedConversationsCount,proto3" json:"unclassified_conversations_count,omitempty"`
	// Statistics on each issue. Key is the issue's resource name.
	IssueStats map[string]*IssueModelLabelStats_IssueStats `protobuf:"bytes,3,rep,name=issue_stats,json=issueStats,proto3" json:"issue_stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *IssueModelLabelStats) Reset() {
	*x = IssueModelLabelStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IssueModelLabelStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IssueModelLabelStats) ProtoMessage() {}

func (x *IssueModelLabelStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IssueModelLabelStats.ProtoReflect.Descriptor instead.
func (*IssueModelLabelStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{23}
}

func (x *IssueModelLabelStats) GetAnalyzedConversationsCount() int64 {
	if x != nil {
		return x.AnalyzedConversationsCount
	}
	return 0
}

func (x *IssueModelLabelStats) GetUnclassifiedConversationsCount() int64 {
	if x != nil {
		return x.UnclassifiedConversationsCount
	}
	return 0
}

func (x *IssueModelLabelStats) GetIssueStats() map[string]*IssueModelLabelStats_IssueStats {
	if x != nil {
		return x.IssueStats
	}
	return nil
}

// The phrase matcher resource.
type PhraseMatcher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the phrase matcher.
	// Format:
	// projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Immutable. The revision ID of the phrase matcher.
	// A new revision is committed whenever the matcher is changed, except when it
	// is activated or deactivated. A server generated random ID will be used.
	// Example: locations/global/phraseMatchers/my-first-matcher@1234567
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// The customized version tag to use for the phrase matcher. If not specified,
	// it will default to `revision_id`.
	VersionTag string `protobuf:"bytes,3,opt,name=version_tag,json=versionTag,proto3" json:"version_tag,omitempty"`
	// Output only. The timestamp of when the revision was created. It is also the create time
	// when a new matcher is added.
	RevisionCreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=revision_create_time,json=revisionCreateTime,proto3" json:"revision_create_time,omitempty"`
	// The human-readable name of the phrase matcher.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The type of this phrase matcher.
	Type PhraseMatcher_PhraseMatcherType `protobuf:"varint,6,opt,name=type,proto3,enum=google.cloud.contactcenterinsights.v1.PhraseMatcher_PhraseMatcherType" json:"type,omitempty"`
	// Applies the phrase matcher only when it is active.
	Active bool `protobuf:"varint,7,opt,name=active,proto3" json:"active,omitempty"`
	// A list of phase match rule groups that are included in this matcher.
	PhraseMatchRuleGroups []*PhraseMatchRuleGroup `protobuf:"bytes,8,rep,name=phrase_match_rule_groups,json=phraseMatchRuleGroups,proto3" json:"phrase_match_rule_groups,omitempty"`
	// Output only. The most recent time at which the activation status was updated.
	ActivationUpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=activation_update_time,json=activationUpdateTime,proto3" json:"activation_update_time,omitempty"`
	// The role whose utterances the phrase matcher should be matched
	// against. If the role is ROLE_UNSPECIFIED it will be matched against any
	// utterances in the transcript.
	RoleMatch ConversationParticipant_Role `protobuf:"varint,10,opt,name=role_match,json=roleMatch,proto3,enum=google.cloud.contactcenterinsights.v1.ConversationParticipant_Role" json:"role_match,omitempty"`
	// Output only. The most recent time at which the phrase matcher was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *PhraseMatcher) Reset() {
	*x = PhraseMatcher{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhraseMatcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhraseMatcher) ProtoMessage() {}

func (x *PhraseMatcher) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhraseMatcher.ProtoReflect.Descriptor instead.
func (*PhraseMatcher) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{24}
}

func (x *PhraseMatcher) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PhraseMatcher) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *PhraseMatcher) GetVersionTag() string {
	if x != nil {
		return x.VersionTag
	}
	return ""
}

func (x *PhraseMatcher) GetRevisionCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RevisionCreateTime
	}
	return nil
}

func (x *PhraseMatcher) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PhraseMatcher) GetType() PhraseMatcher_PhraseMatcherType {
	if x != nil {
		return x.Type
	}
	return PhraseMatcher_PHRASE_MATCHER_TYPE_UNSPECIFIED
}

func (x *PhraseMatcher) GetActive() bool {
	if x != nil {
		return x.Active
	}
	return false
}

func (x *PhraseMatcher) GetPhraseMatchRuleGroups() []*PhraseMatchRuleGroup {
	if x != nil {
		return x.PhraseMatchRuleGroups
	}
	return nil
}

func (x *PhraseMatcher) GetActivationUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ActivationUpdateTime
	}
	return nil
}

func (x *PhraseMatcher) GetRoleMatch() ConversationParticipant_Role {
	if x != nil {
		return x.RoleMatch
	}
	return ConversationParticipant_ROLE_UNSPECIFIED
}

func (x *PhraseMatcher) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A message representing a rule in the phrase matcher.
type PhraseMatchRuleGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of this phrase match rule group.
	Type PhraseMatchRuleGroup_PhraseMatchRuleGroupType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup_PhraseMatchRuleGroupType" json:"type,omitempty"`
	// A list of phase match rules that are included in this group.
	PhraseMatchRules []*PhraseMatchRule `protobuf:"bytes,2,rep,name=phrase_match_rules,json=phraseMatchRules,proto3" json:"phrase_match_rules,omitempty"`
}

func (x *PhraseMatchRuleGroup) Reset() {
	*x = PhraseMatchRuleGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhraseMatchRuleGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhraseMatchRuleGroup) ProtoMessage() {}

func (x *PhraseMatchRuleGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhraseMatchRuleGroup.ProtoReflect.Descriptor instead.
func (*PhraseMatchRuleGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{25}
}

func (x *PhraseMatchRuleGroup) GetType() PhraseMatchRuleGroup_PhraseMatchRuleGroupType {
	if x != nil {
		return x.Type
	}
	return PhraseMatchRuleGroup_PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED
}

func (x *PhraseMatchRuleGroup) GetPhraseMatchRules() []*PhraseMatchRule {
	if x != nil {
		return x.PhraseMatchRules
	}
	return nil
}

// The data for a phrase match rule.
type PhraseMatchRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The phrase to be matched.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Specifies whether the phrase must be missing from the transcript segment or
	// present in the transcript segment.
	Negated bool `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	// Provides additional information about the rule that specifies how to apply
	// the rule.
	Config *PhraseMatchRuleConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *PhraseMatchRule) Reset() {
	*x = PhraseMatchRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhraseMatchRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhraseMatchRule) ProtoMessage() {}

func (x *PhraseMatchRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhraseMatchRule.ProtoReflect.Descriptor instead.
func (*PhraseMatchRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{26}
}

func (x *PhraseMatchRule) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *PhraseMatchRule) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

func (x *PhraseMatchRule) GetConfig() *PhraseMatchRuleConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

// Configuration information of a phrase match rule.
type PhraseMatchRuleConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration of the phrase match rule.
	//
	// Types that are assignable to Config:
	//	*PhraseMatchRuleConfig_ExactMatchConfig
	Config isPhraseMatchRuleConfig_Config `protobuf_oneof:"config"`
}

func (x *PhraseMatchRuleConfig) Reset() {
	*x = PhraseMatchRuleConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhraseMatchRuleConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhraseMatchRuleConfig) ProtoMessage() {}

func (x *PhraseMatchRuleConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhraseMatchRuleConfig.ProtoReflect.Descriptor instead.
func (*PhraseMatchRuleConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{27}
}

func (m *PhraseMatchRuleConfig) GetConfig() isPhraseMatchRuleConfig_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *PhraseMatchRuleConfig) GetExactMatchConfig() *ExactMatchConfig {
	if x, ok := x.GetConfig().(*PhraseMatchRuleConfig_ExactMatchConfig); ok {
		return x.ExactMatchConfig
	}
	return nil
}

type isPhraseMatchRuleConfig_Config interface {
	isPhraseMatchRuleConfig_Config()
}

type PhraseMatchRuleConfig_ExactMatchConfig struct {
	// The configuration for the exact match rule.
	ExactMatchConfig *ExactMatchConfig `protobuf:"bytes,1,opt,name=exact_match_config,json=exactMatchConfig,proto3,oneof"`
}

func (*PhraseMatchRuleConfig_ExactMatchConfig) isPhraseMatchRuleConfig_Config() {}

// Exact match configuration.
type ExactMatchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to consider case sensitivity when performing an exact match.
	CaseSensitive bool `protobuf:"varint,1,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *ExactMatchConfig) Reset() {
	*x = ExactMatchConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExactMatchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExactMatchConfig) ProtoMessage() {}

func (x *ExactMatchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExactMatchConfig.ProtoReflect.Descriptor instead.
func (*ExactMatchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{28}
}

func (x *ExactMatchConfig) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// The settings resource.
type Settings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the settings resource.
	// Format:
	// projects/{project}/locations/{location}/settings
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which the settings was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the settings were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// A language code to be applied to each transcript segment unless the segment
	// already specifies a language code. Language code defaults to "en-US" if it
	// is neither specified on the segment nor here.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The default TTL for newly-created conversations. If a conversation has a
	// specified expiration, that value will be used instead. Changing this
	// value will not change the expiration of existing conversations.
	// Conversations with no expire time persist until they are deleted.
	ConversationTtl *durationpb.Duration `protobuf:"bytes,5,opt,name=conversation_ttl,json=conversationTtl,proto3" json:"conversation_ttl,omitempty"`
	// A map that maps a notification trigger to a Pub/Sub topic. Each time a
	// specified trigger occurs, Insights will notify the corresponding Pub/Sub
	// topic.
	//
	// Keys are notification triggers. Supported keys are:
	//
	// * "all-triggers": Notify each time any of the supported triggers occurs.
	// * "create-analysis": Notify each time an analysis is created.
	// * "create-conversation": Notify each time a conversation is created.
	// * "export-insights-data": Notify each time an export is complete.
	// * "update-conversation": Notify each time a conversation is updated via
	// UpdateConversation.
	//
	// Values are Pub/Sub topics. The format of each Pub/Sub topic is:
	// projects/{project}/topics/{topic}
	PubsubNotificationSettings map[string]string `protobuf:"bytes,6,rep,name=pubsub_notification_settings,json=pubsubNotificationSettings,proto3" json:"pubsub_notification_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Default analysis settings.
	AnalysisConfig *Settings_AnalysisConfig `protobuf:"bytes,7,opt,name=analysis_config,json=analysisConfig,proto3" json:"analysis_config,omitempty"`
}

func (x *Settings) Reset() {
	*x = Settings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Settings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings) ProtoMessage() {}

func (x *Settings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings.ProtoReflect.Descriptor instead.
func (*Settings) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{29}
}

func (x *Settings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Settings) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Settings) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Settings) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Settings) GetConversationTtl() *durationpb.Duration {
	if x != nil {
		return x.ConversationTtl
	}
	return nil
}

func (x *Settings) GetPubsubNotificationSettings() map[string]string {
	if x != nil {
		return x.PubsubNotificationSettings
	}
	return nil
}

func (x *Settings) GetAnalysisConfig() *Settings_AnalysisConfig {
	if x != nil {
		return x.AnalysisConfig
	}
	return nil
}

// An annotation that was generated during the customer and agent interaction.
type RuntimeAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data in the annotation.
	//
	// Types that are assignable to Data:
	//	*RuntimeAnnotation_ArticleSuggestion
	//	*RuntimeAnnotation_FaqAnswer
	//	*RuntimeAnnotation_SmartReply
	//	*RuntimeAnnotation_SmartComposeSuggestion
	//	*RuntimeAnnotation_DialogflowInteraction
	Data isRuntimeAnnotation_Data `protobuf_oneof:"data"`
	// The unique identifier of the annotation.
	// Format:
	// projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
	AnnotationId string `protobuf:"bytes,1,opt,name=annotation_id,json=annotationId,proto3" json:"annotation_id,omitempty"`
	// The time at which this annotation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The boundary in the conversation where the annotation starts, inclusive.
	StartBoundary *AnnotationBoundary `protobuf:"bytes,3,opt,name=start_boundary,json=startBoundary,proto3" json:"start_boundary,omitempty"`
	// The boundary in the conversation where the annotation ends, inclusive.
	EndBoundary *AnnotationBoundary `protobuf:"bytes,4,opt,name=end_boundary,json=endBoundary,proto3" json:"end_boundary,omitempty"`
	// The feedback that the customer has about the answer in `data`.
	AnswerFeedback *AnswerFeedback `protobuf:"bytes,5,opt,name=answer_feedback,json=answerFeedback,proto3" json:"answer_feedback,omitempty"`
}

func (x *RuntimeAnnotation) Reset() {
	*x = RuntimeAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeAnnotation) ProtoMessage() {}

func (x *RuntimeAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeAnnotation.ProtoReflect.Descriptor instead.
func (*RuntimeAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{30}
}

func (m *RuntimeAnnotation) GetData() isRuntimeAnnotation_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *RuntimeAnnotation) GetArticleSuggestion() *ArticleSuggestionData {
	if x, ok := x.GetData().(*RuntimeAnnotation_ArticleSuggestion); ok {
		return x.ArticleSuggestion
	}
	return nil
}

func (x *RuntimeAnnotation) GetFaqAnswer() *FaqAnswerData {
	if x, ok := x.GetData().(*RuntimeAnnotation_FaqAnswer); ok {
		return x.FaqAnswer
	}
	return nil
}

func (x *RuntimeAnnotation) GetSmartReply() *SmartReplyData {
	if x, ok := x.GetData().(*RuntimeAnnotation_SmartReply); ok {
		return x.SmartReply
	}
	return nil
}

func (x *RuntimeAnnotation) GetSmartComposeSuggestion() *SmartComposeSuggestionData {
	if x, ok := x.GetData().(*RuntimeAnnotation_SmartComposeSuggestion); ok {
		return x.SmartComposeSuggestion
	}
	return nil
}

func (x *RuntimeAnnotation) GetDialogflowInteraction() *DialogflowInteractionData {
	if x, ok := x.GetData().(*RuntimeAnnotation_DialogflowInteraction); ok {
		return x.DialogflowInteraction
	}
	return nil
}

func (x *RuntimeAnnotation) GetAnnotationId() string {
	if x != nil {
		return x.AnnotationId
	}
	return ""
}

func (x *RuntimeAnnotation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *RuntimeAnnotation) GetStartBoundary() *AnnotationBoundary {
	if x != nil {
		return x.StartBoundary
	}
	return nil
}

func (x *RuntimeAnnotation) GetEndBoundary() *AnnotationBoundary {
	if x != nil {
		return x.EndBoundary
	}
	return nil
}

func (x *RuntimeAnnotation) GetAnswerFeedback() *AnswerFeedback {
	if x != nil {
		return x.AnswerFeedback
	}
	return nil
}

type isRuntimeAnnotation_Data interface {
	isRuntimeAnnotation_Data()
}

type RuntimeAnnotation_ArticleSuggestion struct {
	// Agent Assist Article Suggestion data.
	ArticleSuggestion *ArticleSuggestionData `protobuf:"bytes,6,opt,name=article_suggestion,json=articleSuggestion,proto3,oneof"`
}

type RuntimeAnnotation_FaqAnswer struct {
	// Agent Assist FAQ answer data.
	FaqAnswer *FaqAnswerData `protobuf:"bytes,7,opt,name=faq_answer,json=faqAnswer,proto3,oneof"`
}

type RuntimeAnnotation_SmartReply struct {
	// Agent Assist Smart Reply data.
	SmartReply *SmartReplyData `protobuf:"bytes,8,opt,name=smart_reply,json=smartReply,proto3,oneof"`
}

type RuntimeAnnotation_SmartComposeSuggestion struct {
	// Agent Assist Smart Compose suggestion data.
	SmartComposeSuggestion *SmartComposeSuggestionData `protobuf:"bytes,9,opt,name=smart_compose_suggestion,json=smartComposeSuggestion,proto3,oneof"`
}

type RuntimeAnnotation_DialogflowInteraction struct {
	// Dialogflow interaction data.
	DialogflowInteraction *DialogflowInteractionData `protobuf:"bytes,10,opt,name=dialogflow_interaction,json=dialogflowInteraction,proto3,oneof"`
}

func (*RuntimeAnnotation_ArticleSuggestion) isRuntimeAnnotation_Data() {}

func (*RuntimeAnnotation_FaqAnswer) isRuntimeAnnotation_Data() {}

func (*RuntimeAnnotation_SmartReply) isRuntimeAnnotation_Data() {}

func (*RuntimeAnnotation_SmartComposeSuggestion) isRuntimeAnnotation_Data() {}

func (*RuntimeAnnotation_DialogflowInteraction) isRuntimeAnnotation_Data() {}

// The feedback that the customer has about a certain answer in the
// conversation.
type AnswerFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The correctness level of an answer.
	CorrectnessLevel AnswerFeedback_CorrectnessLevel `protobuf:"varint,1,opt,name=correctness_level,json=correctnessLevel,proto3,enum=google.cloud.contactcenterinsights.v1.AnswerFeedback_CorrectnessLevel" json:"correctness_level,omitempty"`
	// Indicates whether an answer or item was clicked by the human agent.
	Clicked bool `protobuf:"varint,2,opt,name=clicked,proto3" json:"clicked,omitempty"`
	// Indicates whether an answer or item was displayed to the human agent in the
	// agent desktop UI.
	Displayed bool `protobuf:"varint,3,opt,name=displayed,proto3" json:"displayed,omitempty"`
}

func (x *AnswerFeedback) Reset() {
	*x = AnswerFeedback{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnswerFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnswerFeedback) ProtoMessage() {}

func (x *AnswerFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnswerFeedback.ProtoReflect.Descriptor instead.
func (*AnswerFeedback) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{31}
}

func (x *AnswerFeedback) GetCorrectnessLevel() AnswerFeedback_CorrectnessLevel {
	if x != nil {
		return x.CorrectnessLevel
	}
	return AnswerFeedback_CORRECTNESS_LEVEL_UNSPECIFIED
}

func (x *AnswerFeedback) GetClicked() bool {
	if x != nil {
		return x.Clicked
	}
	return false
}

func (x *AnswerFeedback) GetDisplayed() bool {
	if x != nil {
		return x.Displayed
	}
	return false
}

// Agent Assist Article Suggestion data.
type ArticleSuggestionData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Article title.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Article URI.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// The system's confidence score that this article is a good match for this
	// conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely
	// certain).
	ConfidenceScore float32 `protobuf:"fixed32,3,opt,name=confidence_score,json=confidenceScore,proto3" json:"confidence_score,omitempty"`
	// Map that contains metadata about the Article Suggestion and the document
	// that it originates from.
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the answer record.
	// Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `protobuf:"bytes,5,opt,name=query_record,json=queryRecord,proto3" json:"query_record,omitempty"`
	// The knowledge document that this answer was extracted from.
	// Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}
	Source string `protobuf:"bytes,6,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *ArticleSuggestionData) Reset() {
	*x = ArticleSuggestionData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArticleSuggestionData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArticleSuggestionData) ProtoMessage() {}

func (x *ArticleSuggestionData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArticleSuggestionData.ProtoReflect.Descriptor instead.
func (*ArticleSuggestionData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{32}
}

func (x *ArticleSuggestionData) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *ArticleSuggestionData) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ArticleSuggestionData) GetConfidenceScore() float32 {
	if x != nil {
		return x.ConfidenceScore
	}
	return 0
}

func (x *ArticleSuggestionData) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ArticleSuggestionData) GetQueryRecord() string {
	if x != nil {
		return x.QueryRecord
	}
	return ""
}

func (x *ArticleSuggestionData) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

// Agent Assist frequently-asked-question answer data.
type FaqAnswerData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The piece of text from the `source` knowledge base document.
	Answer string `protobuf:"bytes,1,opt,name=answer,proto3" json:"answer,omitempty"`
	// The system's confidence score that this answer is a good match for this
	// conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely
	// certain).
	ConfidenceScore float32 `protobuf:"fixed32,2,opt,name=confidence_score,json=confidenceScore,proto3" json:"confidence_score,omitempty"`
	// The corresponding FAQ question.
	Question string `protobuf:"bytes,3,opt,name=question,proto3" json:"question,omitempty"`
	// Map that contains metadata about the FAQ answer and the document that
	// it originates from.
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the answer record.
	// Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `protobuf:"bytes,5,opt,name=query_record,json=queryRecord,proto3" json:"query_record,omitempty"`
	// The knowledge document that this answer was extracted from.
	// Format:
	// projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
	Source string `protobuf:"bytes,6,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *FaqAnswerData) Reset() {
	*x = FaqAnswerData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FaqAnswerData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaqAnswerData) ProtoMessage() {}

func (x *FaqAnswerData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaqAnswerData.ProtoReflect.Descriptor instead.
func (*FaqAnswerData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{33}
}

func (x *FaqAnswerData) GetAnswer() string {
	if x != nil {
		return x.Answer
	}
	return ""
}

func (x *FaqAnswerData) GetConfidenceScore() float32 {
	if x != nil {
		return x.ConfidenceScore
	}
	return 0
}

func (x *FaqAnswerData) GetQuestion() string {
	if x != nil {
		return x.Question
	}
	return ""
}

func (x *FaqAnswerData) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *FaqAnswerData) GetQueryRecord() string {
	if x != nil {
		return x.QueryRecord
	}
	return ""
}

func (x *FaqAnswerData) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

// Agent Assist Smart Reply data.
type SmartReplyData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The content of the reply.
	Reply string `protobuf:"bytes,1,opt,name=reply,proto3" json:"reply,omitempty"`
	// The system's confidence score that this reply is a good match for this
	// conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely
	// certain).
	ConfidenceScore float64 `protobuf:"fixed64,2,opt,name=confidence_score,json=confidenceScore,proto3" json:"confidence_score,omitempty"`
	// Map that contains metadata about the Smart Reply and the document from
	// which it originates.
	Metadata map[string]string `protobuf:"bytes,3,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the answer record.
	// Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `protobuf:"bytes,4,opt,name=query_record,json=queryRecord,proto3" json:"query_record,omitempty"`
}

func (x *SmartReplyData) Reset() {
	*x = SmartReplyData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SmartReplyData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SmartReplyData) ProtoMessage() {}

func (x *SmartReplyData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SmartReplyData.ProtoReflect.Descriptor instead.
func (*SmartReplyData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{34}
}

func (x *SmartReplyData) GetReply() string {
	if x != nil {
		return x.Reply
	}
	return ""
}

func (x *SmartReplyData) GetConfidenceScore() float64 {
	if x != nil {
		return x.ConfidenceScore
	}
	return 0
}

func (x *SmartReplyData) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *SmartReplyData) GetQueryRecord() string {
	if x != nil {
		return x.QueryRecord
	}
	return ""
}

// Agent Assist Smart Compose suggestion data.
type SmartComposeSuggestionData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The content of the suggestion.
	Suggestion string `protobuf:"bytes,1,opt,name=suggestion,proto3" json:"suggestion,omitempty"`
	// The system's confidence score that this suggestion is a good match for this
	// conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely
	// certain).
	ConfidenceScore float64 `protobuf:"fixed64,2,opt,name=confidence_score,json=confidenceScore,proto3" json:"confidence_score,omitempty"`
	// Map that contains metadata about the Smart Compose suggestion and the
	// document from which it originates.
	Metadata map[string]string `protobuf:"bytes,3,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of the answer record.
	// Format:
	// projects/{project}/locations/{location}/answerRecords/{answer_record}
	QueryRecord string `protobuf:"bytes,4,opt,name=query_record,json=queryRecord,proto3" json:"query_record,omitempty"`
}

func (x *SmartComposeSuggestionData) Reset() {
	*x = SmartComposeSuggestionData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SmartComposeSuggestionData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SmartComposeSuggestionData) ProtoMessage() {}

func (x *SmartComposeSuggestionData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SmartComposeSuggestionData.ProtoReflect.Descriptor instead.
func (*SmartComposeSuggestionData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{35}
}

func (x *SmartComposeSuggestionData) GetSuggestion() string {
	if x != nil {
		return x.Suggestion
	}
	return ""
}

func (x *SmartComposeSuggestionData) GetConfidenceScore() float64 {
	if x != nil {
		return x.ConfidenceScore
	}
	return 0
}

func (x *SmartComposeSuggestionData) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *SmartComposeSuggestionData) GetQueryRecord() string {
	if x != nil {
		return x.QueryRecord
	}
	return ""
}

// Dialogflow interaction data.
type DialogflowInteractionData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Dialogflow intent resource path. Format:
	// projects/{project}/agent/{agent}/intents/{intent}
	DialogflowIntentId string `protobuf:"bytes,1,opt,name=dialogflow_intent_id,json=dialogflowIntentId,proto3" json:"dialogflow_intent_id,omitempty"`
	// The confidence of the match ranging from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *DialogflowInteractionData) Reset() {
	*x = DialogflowInteractionData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DialogflowInteractionData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DialogflowInteractionData) ProtoMessage() {}

func (x *DialogflowInteractionData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DialogflowInteractionData.ProtoReflect.Descriptor instead.
func (*DialogflowInteractionData) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{36}
}

func (x *DialogflowInteractionData) GetDialogflowIntentId() string {
	if x != nil {
		return x.DialogflowIntentId
	}
	return ""
}

func (x *DialogflowInteractionData) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// The call participant speaking for a given utterance.
type ConversationParticipant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Participant:
	//	*ConversationParticipant_DialogflowParticipantName
	//	*ConversationParticipant_UserId
	Participant isConversationParticipant_Participant `protobuf_oneof:"participant"`
	// Deprecated. Use `dialogflow_participant_name` instead.
	// The name of the Dialogflow participant. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
	//
	// Deprecated: Do not use.
	DialogflowParticipant string `protobuf:"bytes,1,opt,name=dialogflow_participant,json=dialogflowParticipant,proto3" json:"dialogflow_participant,omitempty"`
	// Obfuscated user ID from Dialogflow.
	ObfuscatedExternalUserId string `protobuf:"bytes,3,opt,name=obfuscated_external_user_id,json=obfuscatedExternalUserId,proto3" json:"obfuscated_external_user_id,omitempty"`
	// The role of the participant.
	Role ConversationParticipant_Role `protobuf:"varint,2,opt,name=role,proto3,enum=google.cloud.contactcenterinsights.v1.ConversationParticipant_Role" json:"role,omitempty"`
}

func (x *ConversationParticipant) Reset() {
	*x = ConversationParticipant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConversationParticipant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationParticipant) ProtoMessage() {}

func (x *ConversationParticipant) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationParticipant.ProtoReflect.Descriptor instead.
func (*ConversationParticipant) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{37}
}

func (m *ConversationParticipant) GetParticipant() isConversationParticipant_Participant {
	if m != nil {
		return m.Participant
	}
	return nil
}

func (x *ConversationParticipant) GetDialogflowParticipantName() string {
	if x, ok := x.GetParticipant().(*ConversationParticipant_DialogflowParticipantName); ok {
		return x.DialogflowParticipantName
	}
	return ""
}

func (x *ConversationParticipant) GetUserId() string {
	if x, ok := x.GetParticipant().(*ConversationParticipant_UserId); ok {
		return x.UserId
	}
	return ""
}

// Deprecated: Do not use.
func (x *ConversationParticipant) GetDialogflowParticipant() string {
	if x != nil {
		return x.DialogflowParticipant
	}
	return ""
}

func (x *ConversationParticipant) GetObfuscatedExternalUserId() string {
	if x != nil {
		return x.ObfuscatedExternalUserId
	}
	return ""
}

func (x *ConversationParticipant) GetRole() ConversationParticipant_Role {
	if x != nil {
		return x.Role
	}
	return ConversationParticipant_ROLE_UNSPECIFIED
}

type isConversationParticipant_Participant interface {
	isConversationParticipant_Participant()
}

type ConversationParticipant_DialogflowParticipantName struct {
	// The name of the participant provided by Dialogflow. Format:
	// projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
	DialogflowParticipantName string `protobuf:"bytes,5,opt,name=dialogflow_participant_name,json=dialogflowParticipantName,proto3,oneof"`
}

type ConversationParticipant_UserId struct {
	// A user-specified ID representing the participant.
	UserId string `protobuf:"bytes,6,opt,name=user_id,json=userId,proto3,oneof"`
}

func (*ConversationParticipant_DialogflowParticipantName) isConversationParticipant_Participant() {}

func (*ConversationParticipant_UserId) isConversationParticipant_Participant() {}

// The View resource.
type View struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the view.
	// Format:
	// projects/{project}/locations/{location}/views/{view}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The human-readable display name of the view.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The time at which this view was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The most recent time at which the view was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// String with specific view properties.
	Value string `protobuf:"bytes,5,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *View) Reset() {
	*x = View{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *View) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*View) ProtoMessage() {}

func (x *View) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use View.ProtoReflect.Descriptor instead.
func (*View) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{38}
}

func (x *View) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *View) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *View) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *View) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *View) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Call-specific metadata.
type Conversation_CallMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The audio channel that contains the customer.
	CustomerChannel int32 `protobuf:"varint,1,opt,name=customer_channel,json=customerChannel,proto3" json:"customer_channel,omitempty"`
	// The audio channel that contains the agent.
	AgentChannel int32 `protobuf:"varint,2,opt,name=agent_channel,json=agentChannel,proto3" json:"agent_channel,omitempty"`
}

func (x *Conversation_CallMetadata) Reset() {
	*x = Conversation_CallMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_CallMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_CallMetadata) ProtoMessage() {}

func (x *Conversation_CallMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_CallMetadata.ProtoReflect.Descriptor instead.
func (*Conversation_CallMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Conversation_CallMetadata) GetCustomerChannel() int32 {
	if x != nil {
		return x.CustomerChannel
	}
	return 0
}

func (x *Conversation_CallMetadata) GetAgentChannel() int32 {
	if x != nil {
		return x.AgentChannel
	}
	return 0
}

// A message representing the transcript of a conversation.
type Conversation_Transcript struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of sequential transcript segments that comprise the conversation.
	TranscriptSegments []*Conversation_Transcript_TranscriptSegment `protobuf:"bytes,1,rep,name=transcript_segments,json=transcriptSegments,proto3" json:"transcript_segments,omitempty"`
}

func (x *Conversation_Transcript) Reset() {
	*x = Conversation_Transcript{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_Transcript) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_Transcript) ProtoMessage() {}

func (x *Conversation_Transcript) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_Transcript.ProtoReflect.Descriptor instead.
func (*Conversation_Transcript) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Conversation_Transcript) GetTranscriptSegments() []*Conversation_Transcript_TranscriptSegment {
	if x != nil {
		return x.TranscriptSegments
	}
	return nil
}

// A segment of a full transcript.
type Conversation_Transcript_TranscriptSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that the message occurred, if provided.
	MessageTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=message_time,json=messageTime,proto3" json:"message_time,omitempty"`
	// The text of this segment.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// A confidence estimate between 0.0 and 1.0 of the fidelity of this
	// segment. A default value of 0.0 indicates that the value is unset.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// A list of the word-specific information for each word in the segment.
	Words []*Conversation_Transcript_TranscriptSegment_WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
	// The language code of this segment as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// For conversations derived from multi-channel audio, this is the channel
	// number corresponding to the audio from that channel. For
	// audioChannelCount = N, its output values can range from '1' to 'N'. A
	// channel tag of 0 indicates that the audio is mono.
	ChannelTag int32 `protobuf:"varint,5,opt,name=channel_tag,json=channelTag,proto3" json:"channel_tag,omitempty"`
	// The participant of this segment.
	SegmentParticipant *ConversationParticipant `protobuf:"bytes,9,opt,name=segment_participant,json=segmentParticipant,proto3" json:"segment_participant,omitempty"`
	// CCAI metadata relating to the current transcript segment.
	DialogflowSegmentMetadata *Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata `protobuf:"bytes,10,opt,name=dialogflow_segment_metadata,json=dialogflowSegmentMetadata,proto3" json:"dialogflow_segment_metadata,omitempty"`
	// The sentiment for this transcript segment.
	Sentiment *SentimentData `protobuf:"bytes,11,opt,name=sentiment,proto3" json:"sentiment,omitempty"`
}

func (x *Conversation_Transcript_TranscriptSegment) Reset() {
	*x = Conversation_Transcript_TranscriptSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_Transcript_TranscriptSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_Transcript_TranscriptSegment) ProtoMessage() {}

func (x *Conversation_Transcript_TranscriptSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_Transcript_TranscriptSegment.ProtoReflect.Descriptor instead.
func (*Conversation_Transcript_TranscriptSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Conversation_Transcript_TranscriptSegment) GetMessageTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MessageTime
	}
	return nil
}

func (x *Conversation_Transcript_TranscriptSegment) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *Conversation_Transcript_TranscriptSegment) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *Conversation_Transcript_TranscriptSegment) GetWords() []*Conversation_Transcript_TranscriptSegment_WordInfo {
	if x != nil {
		return x.Words
	}
	return nil
}

func (x *Conversation_Transcript_TranscriptSegment) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Conversation_Transcript_TranscriptSegment) GetChannelTag() int32 {
	if x != nil {
		return x.ChannelTag
	}
	return 0
}

func (x *Conversation_Transcript_TranscriptSegment) GetSegmentParticipant() *ConversationParticipant {
	if x != nil {
		return x.SegmentParticipant
	}
	return nil
}

func (x *Conversation_Transcript_TranscriptSegment) GetDialogflowSegmentMetadata() *Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata {
	if x != nil {
		return x.DialogflowSegmentMetadata
	}
	return nil
}

func (x *Conversation_Transcript_TranscriptSegment) GetSentiment() *SentimentData {
	if x != nil {
		return x.Sentiment
	}
	return nil
}

// Word-level info for words in a transcript.
type Conversation_Transcript_TranscriptSegment_WordInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time offset of the start of this word relative to the beginning of
	// the total conversation.
	StartOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// Time offset of the end of this word relative to the beginning of the
	// total conversation.
	EndOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
	// The word itself. Includes punctuation marks that surround the word.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// A confidence estimate between 0.0 and 1.0 of the fidelity of this
	// word. A default value of 0.0 indicates that the value is unset.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *Conversation_Transcript_TranscriptSegment_WordInfo) Reset() {
	*x = Conversation_Transcript_TranscriptSegment_WordInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_Transcript_TranscriptSegment_WordInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_Transcript_TranscriptSegment_WordInfo) ProtoMessage() {}

func (x *Conversation_Transcript_TranscriptSegment_WordInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_Transcript_TranscriptSegment_WordInfo.ProtoReflect.Descriptor instead.
func (*Conversation_Transcript_TranscriptSegment_WordInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

func (x *Conversation_Transcript_TranscriptSegment_WordInfo) GetStartOffset() *durationpb.Duration {
	if x != nil {
		return x.StartOffset
	}
	return nil
}

func (x *Conversation_Transcript_TranscriptSegment_WordInfo) GetEndOffset() *durationpb.Duration {
	if x != nil {
		return x.EndOffset
	}
	return nil
}

func (x *Conversation_Transcript_TranscriptSegment_WordInfo) GetWord() string {
	if x != nil {
		return x.Word
	}
	return ""
}

func (x *Conversation_Transcript_TranscriptSegment_WordInfo) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Metadata from Dialogflow relating to the current transcript segment.
type Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the transcript segment was covered under the configured smart
	// reply allowlist in Agent Assist.
	SmartReplyAllowlistCovered bool `protobuf:"varint,1,opt,name=smart_reply_allowlist_covered,json=smartReplyAllowlistCovered,proto3" json:"smart_reply_allowlist_covered,omitempty"`
}

func (x *Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata) Reset() {
	*x = Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata) ProtoMessage() {}

func (x *Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata.ProtoReflect.Descriptor instead.
func (*Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{0, 1, 0, 1}
}

func (x *Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata) GetSmartReplyAllowlistCovered() bool {
	if x != nil {
		return x.SmartReplyAllowlistCovered
	}
	return false
}

// Call-specific metadata created during analysis.
type AnalysisResult_CallAnalysisMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of call annotations that apply to this call.
	Annotations []*CallAnnotation `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// All the entities in the call.
	Entities map[string]*Entity `protobuf:"bytes,3,rep,name=entities,proto3" json:"entities,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Overall conversation-level sentiment for each channel of the call.
	Sentiments []*ConversationLevelSentiment `protobuf:"bytes,4,rep,name=sentiments,proto3" json:"sentiments,omitempty"`
	// All the matched intents in the call.
	Intents map[string]*Intent `protobuf:"bytes,6,rep,name=intents,proto3" json:"intents,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// All the matched phrase matchers in the call.
	PhraseMatchers map[string]*PhraseMatchData `protobuf:"bytes,7,rep,name=phrase_matchers,json=phraseMatchers,proto3" json:"phrase_matchers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Overall conversation-level issue modeling result.
	IssueModelResult *IssueModelResult `protobuf:"bytes,8,opt,name=issue_model_result,json=issueModelResult,proto3" json:"issue_model_result,omitempty"`
}

func (x *AnalysisResult_CallAnalysisMetadata) Reset() {
	*x = AnalysisResult_CallAnalysisMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalysisResult_CallAnalysisMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalysisResult_CallAnalysisMetadata) ProtoMessage() {}

func (x *AnalysisResult_CallAnalysisMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalysisResult_CallAnalysisMetadata.ProtoReflect.Descriptor instead.
func (*AnalysisResult_CallAnalysisMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{5, 0}
}

func (x *AnalysisResult_CallAnalysisMetadata) GetAnnotations() []*CallAnnotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *AnalysisResult_CallAnalysisMetadata) GetEntities() map[string]*Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *AnalysisResult_CallAnalysisMetadata) GetSentiments() []*ConversationLevelSentiment {
	if x != nil {
		return x.Sentiments
	}
	return nil
}

func (x *AnalysisResult_CallAnalysisMetadata) GetIntents() map[string]*Intent {
	if x != nil {
		return x.Intents
	}
	return nil
}

func (x *AnalysisResult_CallAnalysisMetadata) GetPhraseMatchers() map[string]*PhraseMatchData {
	if x != nil {
		return x.PhraseMatchers
	}
	return nil
}

func (x *AnalysisResult_CallAnalysisMetadata) GetIssueModelResult() *IssueModelResult {
	if x != nil {
		return x.IssueModelResult
	}
	return nil
}

// Configs for the input data used to create the issue model.
type IssueModel_InputDataConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Medium of conversations used in training data. This field is being
	// deprecated. To specify the medium to be used in training a new issue
	// model, set the `medium` field on `filter`.
	//
	// Deprecated: Do not use.
	Medium Conversation_Medium `protobuf:"varint,1,opt,name=medium,proto3,enum=google.cloud.contactcenterinsights.v1.Conversation_Medium" json:"medium,omitempty"`
	// Output only. Number of conversations used in training. Output only.
	TrainingConversationsCount int64 `protobuf:"varint,2,opt,name=training_conversations_count,json=trainingConversationsCount,proto3" json:"training_conversations_count,omitempty"`
	// A filter to reduce the conversations used for training the model to a
	// specific subset.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *IssueModel_InputDataConfig) Reset() {
	*x = IssueModel_InputDataConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IssueModel_InputDataConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IssueModel_InputDataConfig) ProtoMessage() {}

func (x *IssueModel_InputDataConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IssueModel_InputDataConfig.ProtoReflect.Descriptor instead.
func (*IssueModel_InputDataConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{21, 0}
}

// Deprecated: Do not use.
func (x *IssueModel_InputDataConfig) GetMedium() Conversation_Medium {
	if x != nil {
		return x.Medium
	}
	return Conversation_MEDIUM_UNSPECIFIED
}

func (x *IssueModel_InputDataConfig) GetTrainingConversationsCount() int64 {
	if x != nil {
		return x.TrainingConversationsCount
	}
	return 0
}

func (x *IssueModel_InputDataConfig) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Aggregated statistics about an issue.
type IssueModelLabelStats_IssueStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Issue resource.
	// Format:
	// projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
	Issue string `protobuf:"bytes,1,opt,name=issue,proto3" json:"issue,omitempty"`
	// Number of conversations attached to the issue at this point in time.
	LabeledConversationsCount int64 `protobuf:"varint,2,opt,name=labeled_conversations_count,json=labeledConversationsCount,proto3" json:"labeled_conversations_count,omitempty"`
	// Display name of the issue.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *IssueModelLabelStats_IssueStats) Reset() {
	*x = IssueModelLabelStats_IssueStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IssueModelLabelStats_IssueStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IssueModelLabelStats_IssueStats) ProtoMessage() {}

func (x *IssueModelLabelStats_IssueStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IssueModelLabelStats_IssueStats.ProtoReflect.Descriptor instead.
func (*IssueModelLabelStats_IssueStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{23, 0}
}

func (x *IssueModelLabelStats_IssueStats) GetIssue() string {
	if x != nil {
		return x.Issue
	}
	return ""
}

func (x *IssueModelLabelStats_IssueStats) GetLabeledConversationsCount() int64 {
	if x != nil {
		return x.LabeledConversationsCount
	}
	return 0
}

func (x *IssueModelLabelStats_IssueStats) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Default configuration when creating Analyses in Insights.
type Settings_AnalysisConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Percentage of conversations created using Dialogflow runtime integration
	// to analyze automatically, between [0, 100].
	RuntimeIntegrationAnalysisPercentage float64 `protobuf:"fixed64,1,opt,name=runtime_integration_analysis_percentage,json=runtimeIntegrationAnalysisPercentage,proto3" json:"runtime_integration_analysis_percentage,omitempty"`
}

func (x *Settings_AnalysisConfig) Reset() {
	*x = Settings_AnalysisConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Settings_AnalysisConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings_AnalysisConfig) ProtoMessage() {}

func (x *Settings_AnalysisConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings_AnalysisConfig.ProtoReflect.Descriptor instead.
func (*Settings_AnalysisConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP(), []int{29, 0}
}

func (x *Settings_AnalysisConfig) GetRuntimeIntegrationAnalysisPercentage() float64 {
	if x != nil {
		return x.RuntimeIntegrationAnalysisPercentage
	}
	return 0
}

var File_google_cloud_contactcenterinsights_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_contactcenterinsights_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2, 0x17, 0x0a, 0x0c,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x0d,
	0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0c, 0x63, 0x61, 0x6c, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3d, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x01, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x04, 0x48, 0x01, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x5e, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x63, 0x0a, 0x0a, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x57,
	0x0a, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x12, 0x3a, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x74, 0x75,
	0x72, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x0f, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x6e, 0x0a, 0x13, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x12, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7e, 0x0a, 0x12, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x12, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x11, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x62, 0x66, 0x75, 0x73, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x6f, 0x62, 0x66, 0x75, 0x73, 0x63, 0x61, 0x74, 0x65, 0x64, 0x55, 0x73,
	0x65, 0x72, 0x49, 0x64, 0x1a, 0x5e, 0x0a, 0x0c, 0x43, 0x61, 0x6c, 0x6c, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x1a, 0xdb, 0x08, 0x0a, 0x0a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x12, 0x81, 0x01, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0xc8, 0x07, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x0a,
	0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x6f, 0x0a, 0x05, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x57, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x77, 0x6f, 0x72, 0x64,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x61, 0x67, 0x12, 0x6f, 0x0a, 0x13, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x52, 0x12, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0xaa, 0x01, 0x0a, 0x1b, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x6a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x19, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x52, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09,
	0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0xb6, 0x01, 0x0a, 0x08, 0x57, 0x6f,
	0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3c, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x12, 0x38, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x77, 0x6f,
	0x72, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x1a, 0x5e, 0x0a, 0x19, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x41, 0x0a, 0x1d, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1a, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x76, 0x65, 0x72,
	0x65, 0x64, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x7d, 0x0a,
	0x16, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4d, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3a, 0x0a, 0x06,
	0x4d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x43, 0x48, 0x41, 0x54, 0x10, 0x02, 0x3a, 0x7c, 0xea, 0x41, 0x79, 0x0a, 0x31, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x44, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x0a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x42, 0x0c, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x9e, 0x03, 0x0a, 0x08, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x0f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x3a, 0x8d, 0x01, 0xea, 0x41, 0x89, 0x01, 0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x7d, 0x22, 0xdd, 0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x51, 0x0a, 0x0a,
	0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x66, 0x0a, 0x11, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x10, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x54, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x55, 0x72, 0x69, 0x12, 0x2a, 0x0a, 0x0e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x55, 0x72, 0x69, 0x22, 0x6d, 0x0a, 0x10, 0x44, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x17, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x16, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x55, 0x72, 0x69, 0x22, 0xd9, 0x09, 0x0a, 0x0e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x16, 0x63, 0x61,
	0x6c, 0x6c, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x14, 0x63, 0x61, 0x6c, 0x6c, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x35,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xfe, 0x07, 0x0a, 0x14, 0x43, 0x61, 0x6c, 0x6c, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x57,
	0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x6c,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x74, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x61, 0x0a,
	0x0a, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x53, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x71, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x87, 0x01, 0x0a, 0x0f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x12, 0x65, 0x0a,
	0x12, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x10, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x1a, 0x6a, 0x0a, 0x0d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x43, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x69, 0x0a, 0x0c, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x43, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x79, 0x0a, 0x13, 0x50,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x4c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0xb9, 0x01, 0x0a, 0x10, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x55, 0x0a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x4e,
	0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x22, 0x9a,
	0x01, 0x0a, 0x1a, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x61, 0x67, 0x12, 0x5b,
	0x0a, 0x0e, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0d, 0x73, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x22, 0x65, 0x0a, 0x0f, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x69, 0x73, 0x73, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0xcb, 0x07, 0x0a, 0x0e, 0x43, 0x61, 0x6c, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x10, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x5d, 0x0a,
	0x0e, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0d, 0x73,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x57, 0x0a, 0x0c,
	0x73, 0x69, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6c, 0x65, 0x6e,
	0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x69, 0x6c, 0x65, 0x6e, 0x63,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x4e, 0x0a, 0x09, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x6f, 0x6c, 0x64, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x08, 0x68, 0x6f, 0x6c,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x12, 0x6a, 0x0a, 0x13, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x11,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x64, 0x0a, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x11, 0x70, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73,
	0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x68,
	0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x61, 0x67, 0x12, 0x75,
	0x0a, 0x19, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x52, 0x17, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x12, 0x71, 0x0a, 0x17, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x52, 0x15, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x22, 0x75, 0x0a, 0x12, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x0a, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x09, 0x77, 0x6f,
	0x72, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x42, 0x13, 0x0a, 0x11, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x22, 0xbe, 0x04, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x57, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x61, 0x6c, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x08, 0x73, 0x61, 0x6c, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x52, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09, 0x73, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xc2, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c,
	0x4f, 0x52, 0x47, 0x41, 0x4e, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x09,
	0x0a, 0x05, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x57, 0x4f, 0x52,
	0x4b, 0x5f, 0x4f, 0x46, 0x5f, 0x41, 0x52, 0x54, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x4f,
	0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x47, 0x4f, 0x4f, 0x44, 0x10, 0x06, 0x12, 0x09, 0x0a,
	0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x07, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x48, 0x4f, 0x4e,
	0x45, 0x5f, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x09, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x44,
	0x44, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0a, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x54, 0x45, 0x10,
	0x0b, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x0c, 0x12, 0x09, 0x0a,
	0x05, 0x50, 0x52, 0x49, 0x43, 0x45, 0x10, 0x0d, 0x22, 0x3b, 0x0a, 0x06, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x5b, 0x0a, 0x0f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x35, 0x0a, 0x10, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x12, 0x0a, 0x10, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x22, 0x0d, 0x0a,
	0x0b, 0x53, 0x69, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x22, 0x0a, 0x0a, 0x08,
	0x48, 0x6f, 0x6c, 0x64, 0x44, 0x61, 0x74, 0x61, 0x22, 0xb0, 0x02, 0x0a, 0x11, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x28,
	0x0a, 0x10, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x12, 0x58, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x2e, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x52, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x09, 0x73, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x43, 0x0a, 0x0b, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x4d, 0x4d, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x3b, 0x0a, 0x0f, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x28,
	0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x22, 0x43, 0x0a, 0x0d, 0x53, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x61, 0x67,
	0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x6d, 0x61,
	0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xab, 0x07,
	0x0a, 0x0a, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x6d, 0x0a, 0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x6a, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x73, 0x1a, 0xc8, 0x01, 0x0a, 0x0f,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x56, 0x0a, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x12, 0x45, 0x0a, 0x1c, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x1a, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x6a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x55, 0x4e, 0x44, 0x45, 0x50, 0x4c,
	0x4f, 0x59, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x05, 0x3a, 0x77, 0xea, 0x41, 0x74, 0x0a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d, 0x22, 0xcb, 0x02, 0x0a, 0x05,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x2a, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x50, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x7d, 0x2f, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x73, 0x2f, 0x7b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x7d, 0x22, 0xa0, 0x04, 0x0a, 0x14, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x40, 0x0a, 0x1c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x64, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x20, 0x75, 0x6e, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1e,
	0x75, 0x6e, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x6c,
	0x0a, 0x0b, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x69, 0x73, 0x73, 0x75, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x1a, 0x85, 0x01, 0x0a,
	0x0a, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x73, 0x73, 0x75,
	0x65, 0x12, 0x3e, 0x0a, 0x1b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x65, 0x64, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x85, 0x01, 0x0a, 0x0f, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x5c, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa4, 0x07, 0x0a,
	0x0d, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x67, 0x12, 0x51, 0x0a, 0x14,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x74, 0x0a, 0x18, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x75, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x15, 0x70, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x12, 0x55, 0x0a, 0x16, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x0a, 0x72, 0x6f, 0x6c, 0x65,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c,
	0x65, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x50,
	0x0a, 0x11, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x50, 0x48, 0x52, 0x41, 0x53, 0x45, 0x5f, 0x4d, 0x41,
	0x54, 0x43, 0x48, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4c, 0x4c, 0x5f,
	0x4f, 0x46, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4e, 0x59, 0x5f, 0x4f, 0x46, 0x10, 0x02,
	0x3a, 0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x32, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x68, 0x72,
	0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x7d, 0x22, 0xcd, 0x02, 0x0a, 0x14, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x6d, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75,
	0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x64, 0x0a, 0x12, 0x70,
	0x68, 0x72, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x10, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x22, 0x60, 0x0a, 0x18, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x75, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a,
	0x28, 0x50, 0x48, 0x52, 0x41, 0x53, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x52, 0x55,
	0x4c, 0x45, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x4c, 0x4c, 0x5f, 0x4f, 0x46, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4e, 0x59, 0x5f, 0x4f,
	0x46, 0x10, 0x02, 0x22, 0x9c, 0x01, 0x0a, 0x0f, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x12, 0x54, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x8a, 0x01, 0x0a, 0x15, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x12,
	0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x10, 0x65, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x39, 0x0a, 0x10, 0x45, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x61, 0x73,
	0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22, 0xad, 0x06, 0x0a, 0x08, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x74, 0x6c, 0x12,
	0x91, 0x01, 0x0a, 0x1c, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x1a, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x67, 0x0a, 0x0f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x67, 0x0a, 0x0e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55,
	0x0a, 0x27, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x24, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x1a, 0x4d, 0x0a, 0x1f, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x64, 0xea, 0x41, 0x61, 0x0a, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x30, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xb7, 0x07, 0x0a, 0x11, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x6d, 0x0a, 0x12, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x11, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x55, 0x0a, 0x0a, 0x66, 0x61, 0x71, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x71, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x09, 0x66, 0x61, 0x71,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x58, 0x0a, 0x0b, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x44, 0x61,
	0x74, 0x61, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79,
	0x12, 0x7d, 0x0a, 0x18, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73,
	0x65, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74,
	0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x16, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x73, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x79, 0x0a, 0x16, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74,
	0x61, 0x48, 0x00, 0x52, 0x15, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x0e,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x52,
	0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x12, 0x5c,
	0x0a, 0x0c, 0x65, 0x6e, 0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x52,
	0x0b, 0x65, 0x6e, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x12, 0x5e, 0x0a, 0x0f,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x0e, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x42, 0x06, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x22, 0xaf, 0x02, 0x0a, 0x0e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x46,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x73, 0x0a, 0x11, 0x63, 0x6f, 0x72, 0x72, 0x65,
	0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63,
	0x74, 0x6e, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x10, 0x63, 0x6f, 0x72, 0x72,
	0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6c, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x63,
	0x6c, 0x69, 0x63, 0x6b, 0x65, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x65, 0x64, 0x22, 0x70, 0x0a, 0x10, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e,
	0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4f, 0x52, 0x52,
	0x45, 0x43, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4e,
	0x4f, 0x54, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11,
	0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43,
	0x54, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x46, 0x55, 0x4c, 0x4c, 0x59, 0x5f, 0x43, 0x4f, 0x52,
	0x52, 0x45, 0x43, 0x54, 0x10, 0x03, 0x22, 0xca, 0x02, 0x0a, 0x15, 0x41, 0x72, 0x74, 0x69, 0x63,
	0x6c, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x12, 0x66, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x72,
	0x74, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x21, 0x0a, 0x0c, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xc6, 0x02, 0x0a, 0x0d, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x44, 0x61, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x29, 0x0a,
	0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x21, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a,
	0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x92, 0x02, 0x0a,
	0x0e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x14, 0x0a, 0x05, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x72, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65,
	0x12, 0x5f, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x79, 0x44, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x21, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xb4, 0x02, 0x0a, 0x1a, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x73, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x6b, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x73, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61,
	0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x21, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6d, 0x0a, 0x19, 0x44, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x30, 0x0a, 0x14, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xe5, 0x03, 0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x12, 0x6c, 0x0a, 0x1b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x19, 0x0a, 0x07, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x16,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x15, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x1b, 0x6f, 0x62, 0x66, 0x75, 0x73,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x6f, 0x62,
	0x66, 0x75, 0x73, 0x63, 0x61, 0x74, 0x65, 0x64, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x57, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x22,
	0x5f, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x48, 0x55, 0x4d, 0x41, 0x4e, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x13,
	0x0a, 0x0f, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x47, 0x45, 0x4e,
	0x54, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x44, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10,
	0x03, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x4e, 0x59, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x04,
	0x42, 0x0d, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x22,
	0xc2, 0x02, 0x0a, 0x04, 0x56, 0x69, 0x65, 0x77, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x64,
	0xea, 0x41, 0x61, 0x0a, 0x29, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x69, 0x65, 0x77, 0x12, 0x34,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x7b, 0x76,
	0x69, 0x65, 0x77, 0x7d, 0x42, 0xec, 0x03, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x42, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0xea, 0x41, 0xd4, 0x01, 0x0a,
	0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x4a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x7d, 0x12, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescData = file_google_cloud_contactcenterinsights_v1_resources_proto_rawDesc
)

func file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_contactcenterinsights_v1_resources_proto_rawDescData
}

var file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 60)
var file_google_cloud_contactcenterinsights_v1_resources_proto_goTypes = []interface{}{
	(Conversation_Medium)(0),                           // 0: google.cloud.contactcenterinsights.v1.Conversation.Medium
	(Entity_Type)(0),                                   // 1: google.cloud.contactcenterinsights.v1.Entity.Type
	(EntityMentionData_MentionType)(0),                 // 2: google.cloud.contactcenterinsights.v1.EntityMentionData.MentionType
	(IssueModel_State)(0),                              // 3: google.cloud.contactcenterinsights.v1.IssueModel.State
	(PhraseMatcher_PhraseMatcherType)(0),               // 4: google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType
	(PhraseMatchRuleGroup_PhraseMatchRuleGroupType)(0), // 5: google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
	(AnswerFeedback_CorrectnessLevel)(0),               // 6: google.cloud.contactcenterinsights.v1.AnswerFeedback.CorrectnessLevel
	(ConversationParticipant_Role)(0),                  // 7: google.cloud.contactcenterinsights.v1.ConversationParticipant.Role
	(*Conversation)(nil),                               // 8: google.cloud.contactcenterinsights.v1.Conversation
	(*Analysis)(nil),                                   // 9: google.cloud.contactcenterinsights.v1.Analysis
	(*ConversationDataSource)(nil),                     // 10: google.cloud.contactcenterinsights.v1.ConversationDataSource
	(*GcsSource)(nil),                                  // 11: google.cloud.contactcenterinsights.v1.GcsSource
	(*DialogflowSource)(nil),                           // 12: google.cloud.contactcenterinsights.v1.DialogflowSource
	(*AnalysisResult)(nil),                             // 13: google.cloud.contactcenterinsights.v1.AnalysisResult
	(*IssueModelResult)(nil),                           // 14: google.cloud.contactcenterinsights.v1.IssueModelResult
	(*ConversationLevelSentiment)(nil),                 // 15: google.cloud.contactcenterinsights.v1.ConversationLevelSentiment
	(*IssueAssignment)(nil),                            // 16: google.cloud.contactcenterinsights.v1.IssueAssignment
	(*CallAnnotation)(nil),                             // 17: google.cloud.contactcenterinsights.v1.CallAnnotation
	(*AnnotationBoundary)(nil),                         // 18: google.cloud.contactcenterinsights.v1.AnnotationBoundary
	(*Entity)(nil),                                     // 19: google.cloud.contactcenterinsights.v1.Entity
	(*Intent)(nil),                                     // 20: google.cloud.contactcenterinsights.v1.Intent
	(*PhraseMatchData)(nil),                            // 21: google.cloud.contactcenterinsights.v1.PhraseMatchData
	(*DialogflowIntent)(nil),                           // 22: google.cloud.contactcenterinsights.v1.DialogflowIntent
	(*InterruptionData)(nil),                           // 23: google.cloud.contactcenterinsights.v1.InterruptionData
	(*SilenceData)(nil),                                // 24: google.cloud.contactcenterinsights.v1.SilenceData
	(*HoldData)(nil),                                   // 25: google.cloud.contactcenterinsights.v1.HoldData
	(*EntityMentionData)(nil),                          // 26: google.cloud.contactcenterinsights.v1.EntityMentionData
	(*IntentMatchData)(nil),                            // 27: google.cloud.contactcenterinsights.v1.IntentMatchData
	(*SentimentData)(nil),                              // 28: google.cloud.contactcenterinsights.v1.SentimentData
	(*IssueModel)(nil),                                 // 29: google.cloud.contactcenterinsights.v1.IssueModel
	(*Issue)(nil),                                      // 30: google.cloud.contactcenterinsights.v1.Issue
	(*IssueModelLabelStats)(nil),                       // 31: google.cloud.contactcenterinsights.v1.IssueModelLabelStats
	(*PhraseMatcher)(nil),                              // 32: google.cloud.contactcenterinsights.v1.PhraseMatcher
	(*PhraseMatchRuleGroup)(nil),                       // 33: google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup
	(*PhraseMatchRule)(nil),                            // 34: google.cloud.contactcenterinsights.v1.PhraseMatchRule
	(*PhraseMatchRuleConfig)(nil),                      // 35: google.cloud.contactcenterinsights.v1.PhraseMatchRuleConfig
	(*ExactMatchConfig)(nil),                           // 36: google.cloud.contactcenterinsights.v1.ExactMatchConfig
	(*Settings)(nil),                                   // 37: google.cloud.contactcenterinsights.v1.Settings
	(*RuntimeAnnotation)(nil),                          // 38: google.cloud.contactcenterinsights.v1.RuntimeAnnotation
	(*AnswerFeedback)(nil),                             // 39: google.cloud.contactcenterinsights.v1.AnswerFeedback
	(*ArticleSuggestionData)(nil),                      // 40: google.cloud.contactcenterinsights.v1.ArticleSuggestionData
	(*FaqAnswerData)(nil),                              // 41: google.cloud.contactcenterinsights.v1.FaqAnswerData
	(*SmartReplyData)(nil),                             // 42: google.cloud.contactcenterinsights.v1.SmartReplyData
	(*SmartComposeSuggestionData)(nil),                 // 43: google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
	(*DialogflowInteractionData)(nil),                  // 44: google.cloud.contactcenterinsights.v1.DialogflowInteractionData
	(*ConversationParticipant)(nil),                    // 45: google.cloud.contactcenterinsights.v1.ConversationParticipant
	(*View)(nil),                                       // 46: google.cloud.contactcenterinsights.v1.View
	(*Conversation_CallMetadata)(nil),                  // 47: google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
	(*Conversation_Transcript)(nil),                    // 48: google.cloud.contactcenterinsights.v1.Conversation.Transcript
	nil,                                                // 49: google.cloud.contactcenterinsights.v1.Conversation.LabelsEntry
	nil,                                                // 50: google.cloud.contactcenterinsights.v1.Conversation.DialogflowIntentsEntry
	(*Conversation_Transcript_TranscriptSegment)(nil),  // 51: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
	(*Conversation_Transcript_TranscriptSegment_WordInfo)(nil),                  // 52: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo
	(*Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata)(nil), // 53: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata
	(*AnalysisResult_CallAnalysisMetadata)(nil),                                 // 54: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
	nil,                                     // 55: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.EntitiesEntry
	nil,                                     // 56: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.IntentsEntry
	nil,                                     // 57: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.PhraseMatchersEntry
	nil,                                     // 58: google.cloud.contactcenterinsights.v1.Entity.MetadataEntry
	(*IssueModel_InputDataConfig)(nil),      // 59: google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
	(*IssueModelLabelStats_IssueStats)(nil), // 60: google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
	nil,                                     // 61: google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsEntry
	(*Settings_AnalysisConfig)(nil),         // 62: google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
	nil,                                     // 63: google.cloud.contactcenterinsights.v1.Settings.PubsubNotificationSettingsEntry
	nil,                                     // 64: google.cloud.contactcenterinsights.v1.ArticleSuggestionData.MetadataEntry
	nil,                                     // 65: google.cloud.contactcenterinsights.v1.FaqAnswerData.MetadataEntry
	nil,                                     // 66: google.cloud.contactcenterinsights.v1.SmartReplyData.MetadataEntry
	nil,                                     // 67: google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData.MetadataEntry
	(*timestamppb.Timestamp)(nil),           // 68: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),             // 69: google.protobuf.Duration
}
var file_google_cloud_contactcenterinsights_v1_resources_proto_depIdxs = []int32{
	47, // 0: google.cloud.contactcenterinsights.v1.Conversation.call_metadata:type_name -> google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
	68, // 1: google.cloud.contactcenterinsights.v1.Conversation.expire_time:type_name -> google.protobuf.Timestamp
	69, // 2: google.cloud.contactcenterinsights.v1.Conversation.ttl:type_name -> google.protobuf.Duration
	10, // 3: google.cloud.contactcenterinsights.v1.Conversation.data_source:type_name -> google.cloud.contactcenterinsights.v1.ConversationDataSource
	68, // 4: google.cloud.contactcenterinsights.v1.Conversation.create_time:type_name -> google.protobuf.Timestamp
	68, // 5: google.cloud.contactcenterinsights.v1.Conversation.update_time:type_name -> google.protobuf.Timestamp
	68, // 6: google.cloud.contactcenterinsights.v1.Conversation.start_time:type_name -> google.protobuf.Timestamp
	49, // 7: google.cloud.contactcenterinsights.v1.Conversation.labels:type_name -> google.cloud.contactcenterinsights.v1.Conversation.LabelsEntry
	48, // 8: google.cloud.contactcenterinsights.v1.Conversation.transcript:type_name -> google.cloud.contactcenterinsights.v1.Conversation.Transcript
	0,  // 9: google.cloud.contactcenterinsights.v1.Conversation.medium:type_name -> google.cloud.contactcenterinsights.v1.Conversation.Medium
	69, // 10: google.cloud.contactcenterinsights.v1.Conversation.duration:type_name -> google.protobuf.Duration
	9,  // 11: google.cloud.contactcenterinsights.v1.Conversation.latest_analysis:type_name -> google.cloud.contactcenterinsights.v1.Analysis
	38, // 12: google.cloud.contactcenterinsights.v1.Conversation.runtime_annotations:type_name -> google.cloud.contactcenterinsights.v1.RuntimeAnnotation
	50, // 13: google.cloud.contactcenterinsights.v1.Conversation.dialogflow_intents:type_name -> google.cloud.contactcenterinsights.v1.Conversation.DialogflowIntentsEntry
	68, // 14: google.cloud.contactcenterinsights.v1.Analysis.request_time:type_name -> google.protobuf.Timestamp
	68, // 15: google.cloud.contactcenterinsights.v1.Analysis.create_time:type_name -> google.protobuf.Timestamp
	13, // 16: google.cloud.contactcenterinsights.v1.Analysis.analysis_result:type_name -> google.cloud.contactcenterinsights.v1.AnalysisResult
	11, // 17: google.cloud.contactcenterinsights.v1.ConversationDataSource.gcs_source:type_name -> google.cloud.contactcenterinsights.v1.GcsSource
	12, // 18: google.cloud.contactcenterinsights.v1.ConversationDataSource.dialogflow_source:type_name -> google.cloud.contactcenterinsights.v1.DialogflowSource
	54, // 19: google.cloud.contactcenterinsights.v1.AnalysisResult.call_analysis_metadata:type_name -> google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
	68, // 20: google.cloud.contactcenterinsights.v1.AnalysisResult.end_time:type_name -> google.protobuf.Timestamp
	16, // 21: google.cloud.contactcenterinsights.v1.IssueModelResult.issues:type_name -> google.cloud.contactcenterinsights.v1.IssueAssignment
	28, // 22: google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.sentiment_data:type_name -> google.cloud.contactcenterinsights.v1.SentimentData
	23, // 23: google.cloud.contactcenterinsights.v1.CallAnnotation.interruption_data:type_name -> google.cloud.contactcenterinsights.v1.InterruptionData
	28, // 24: google.cloud.contactcenterinsights.v1.CallAnnotation.sentiment_data:type_name -> google.cloud.contactcenterinsights.v1.SentimentData
	24, // 25: google.cloud.contactcenterinsights.v1.CallAnnotation.silence_data:type_name -> google.cloud.contactcenterinsights.v1.SilenceData
	25, // 26: google.cloud.contactcenterinsights.v1.CallAnnotation.hold_data:type_name -> google.cloud.contactcenterinsights.v1.HoldData
	26, // 27: google.cloud.contactcenterinsights.v1.CallAnnotation.entity_mention_data:type_name -> google.cloud.contactcenterinsights.v1.EntityMentionData
	27, // 28: google.cloud.contactcenterinsights.v1.CallAnnotation.intent_match_data:type_name -> google.cloud.contactcenterinsights.v1.IntentMatchData
	21, // 29: google.cloud.contactcenterinsights.v1.CallAnnotation.phrase_match_data:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatchData
	18, // 30: google.cloud.contactcenterinsights.v1.CallAnnotation.annotation_start_boundary:type_name -> google.cloud.contactcenterinsights.v1.AnnotationBoundary
	18, // 31: google.cloud.contactcenterinsights.v1.CallAnnotation.annotation_end_boundary:type_name -> google.cloud.contactcenterinsights.v1.AnnotationBoundary
	1,  // 32: google.cloud.contactcenterinsights.v1.Entity.type:type_name -> google.cloud.contactcenterinsights.v1.Entity.Type
	58, // 33: google.cloud.contactcenterinsights.v1.Entity.metadata:type_name -> google.cloud.contactcenterinsights.v1.Entity.MetadataEntry
	28, // 34: google.cloud.contactcenterinsights.v1.Entity.sentiment:type_name -> google.cloud.contactcenterinsights.v1.SentimentData
	2,  // 35: google.cloud.contactcenterinsights.v1.EntityMentionData.type:type_name -> google.cloud.contactcenterinsights.v1.EntityMentionData.MentionType
	28, // 36: google.cloud.contactcenterinsights.v1.EntityMentionData.sentiment:type_name -> google.cloud.contactcenterinsights.v1.SentimentData
	68, // 37: google.cloud.contactcenterinsights.v1.IssueModel.create_time:type_name -> google.protobuf.Timestamp
	68, // 38: google.cloud.contactcenterinsights.v1.IssueModel.update_time:type_name -> google.protobuf.Timestamp
	3,  // 39: google.cloud.contactcenterinsights.v1.IssueModel.state:type_name -> google.cloud.contactcenterinsights.v1.IssueModel.State
	59, // 40: google.cloud.contactcenterinsights.v1.IssueModel.input_data_config:type_name -> google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
	31, // 41: google.cloud.contactcenterinsights.v1.IssueModel.training_stats:type_name -> google.cloud.contactcenterinsights.v1.IssueModelLabelStats
	68, // 42: google.cloud.contactcenterinsights.v1.Issue.create_time:type_name -> google.protobuf.Timestamp
	68, // 43: google.cloud.contactcenterinsights.v1.Issue.update_time:type_name -> google.protobuf.Timestamp
	61, // 44: google.cloud.contactcenterinsights.v1.IssueModelLabelStats.issue_stats:type_name -> google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsEntry
	68, // 45: google.cloud.contactcenterinsights.v1.PhraseMatcher.revision_create_time:type_name -> google.protobuf.Timestamp
	4,  // 46: google.cloud.contactcenterinsights.v1.PhraseMatcher.type:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType
	33, // 47: google.cloud.contactcenterinsights.v1.PhraseMatcher.phrase_match_rule_groups:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup
	68, // 48: google.cloud.contactcenterinsights.v1.PhraseMatcher.activation_update_time:type_name -> google.protobuf.Timestamp
	7,  // 49: google.cloud.contactcenterinsights.v1.PhraseMatcher.role_match:type_name -> google.cloud.contactcenterinsights.v1.ConversationParticipant.Role
	68, // 50: google.cloud.contactcenterinsights.v1.PhraseMatcher.update_time:type_name -> google.protobuf.Timestamp
	5,  // 51: google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.type:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
	34, // 52: google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.phrase_match_rules:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatchRule
	35, // 53: google.cloud.contactcenterinsights.v1.PhraseMatchRule.config:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatchRuleConfig
	36, // 54: google.cloud.contactcenterinsights.v1.PhraseMatchRuleConfig.exact_match_config:type_name -> google.cloud.contactcenterinsights.v1.ExactMatchConfig
	68, // 55: google.cloud.contactcenterinsights.v1.Settings.create_time:type_name -> google.protobuf.Timestamp
	68, // 56: google.cloud.contactcenterinsights.v1.Settings.update_time:type_name -> google.protobuf.Timestamp
	69, // 57: google.cloud.contactcenterinsights.v1.Settings.conversation_ttl:type_name -> google.protobuf.Duration
	63, // 58: google.cloud.contactcenterinsights.v1.Settings.pubsub_notification_settings:type_name -> google.cloud.contactcenterinsights.v1.Settings.PubsubNotificationSettingsEntry
	62, // 59: google.cloud.contactcenterinsights.v1.Settings.analysis_config:type_name -> google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
	40, // 60: google.cloud.contactcenterinsights.v1.RuntimeAnnotation.article_suggestion:type_name -> google.cloud.contactcenterinsights.v1.ArticleSuggestionData
	41, // 61: google.cloud.contactcenterinsights.v1.RuntimeAnnotation.faq_answer:type_name -> google.cloud.contactcenterinsights.v1.FaqAnswerData
	42, // 62: google.cloud.contactcenterinsights.v1.RuntimeAnnotation.smart_reply:type_name -> google.cloud.contactcenterinsights.v1.SmartReplyData
	43, // 63: google.cloud.contactcenterinsights.v1.RuntimeAnnotation.smart_compose_suggestion:type_name -> google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
	44, // 64: google.cloud.contactcenterinsights.v1.RuntimeAnnotation.dialogflow_interaction:type_name -> google.cloud.contactcenterinsights.v1.DialogflowInteractionData
	68, // 65: google.cloud.contactcenterinsights.v1.RuntimeAnnotation.create_time:type_name -> google.protobuf.Timestamp
	18, // 66: google.cloud.contactcenterinsights.v1.RuntimeAnnotation.start_boundary:type_name -> google.cloud.contactcenterinsights.v1.AnnotationBoundary
	18, // 67: google.cloud.contactcenterinsights.v1.RuntimeAnnotation.end_boundary:type_name -> google.cloud.contactcenterinsights.v1.AnnotationBoundary
	39, // 68: google.cloud.contactcenterinsights.v1.RuntimeAnnotation.answer_feedback:type_name -> google.cloud.contactcenterinsights.v1.AnswerFeedback
	6,  // 69: google.cloud.contactcenterinsights.v1.AnswerFeedback.correctness_level:type_name -> google.cloud.contactcenterinsights.v1.AnswerFeedback.CorrectnessLevel
	64, // 70: google.cloud.contactcenterinsights.v1.ArticleSuggestionData.metadata:type_name -> google.cloud.contactcenterinsights.v1.ArticleSuggestionData.MetadataEntry
	65, // 71: google.cloud.contactcenterinsights.v1.FaqAnswerData.metadata:type_name -> google.cloud.contactcenterinsights.v1.FaqAnswerData.MetadataEntry
	66, // 72: google.cloud.contactcenterinsights.v1.SmartReplyData.metadata:type_name -> google.cloud.contactcenterinsights.v1.SmartReplyData.MetadataEntry
	67, // 73: google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData.metadata:type_name -> google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData.MetadataEntry
	7,  // 74: google.cloud.contactcenterinsights.v1.ConversationParticipant.role:type_name -> google.cloud.contactcenterinsights.v1.ConversationParticipant.Role
	68, // 75: google.cloud.contactcenterinsights.v1.View.create_time:type_name -> google.protobuf.Timestamp
	68, // 76: google.cloud.contactcenterinsights.v1.View.update_time:type_name -> google.protobuf.Timestamp
	51, // 77: google.cloud.contactcenterinsights.v1.Conversation.Transcript.transcript_segments:type_name -> google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
	22, // 78: google.cloud.contactcenterinsights.v1.Conversation.DialogflowIntentsEntry.value:type_name -> google.cloud.contactcenterinsights.v1.DialogflowIntent
	68, // 79: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.message_time:type_name -> google.protobuf.Timestamp
	52, // 80: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.words:type_name -> google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo
	45, // 81: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.segment_participant:type_name -> google.cloud.contactcenterinsights.v1.ConversationParticipant
	53, // 82: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.dialogflow_segment_metadata:type_name -> google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata
	28, // 83: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.sentiment:type_name -> google.cloud.contactcenterinsights.v1.SentimentData
	69, // 84: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo.start_offset:type_name -> google.protobuf.Duration
	69, // 85: google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo.end_offset:type_name -> google.protobuf.Duration
	17, // 86: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.annotations:type_name -> google.cloud.contactcenterinsights.v1.CallAnnotation
	55, // 87: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.entities:type_name -> google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.EntitiesEntry
	15, // 88: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.sentiments:type_name -> google.cloud.contactcenterinsights.v1.ConversationLevelSentiment
	56, // 89: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.intents:type_name -> google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.IntentsEntry
	57, // 90: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.phrase_matchers:type_name -> google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.PhraseMatchersEntry
	14, // 91: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.issue_model_result:type_name -> google.cloud.contactcenterinsights.v1.IssueModelResult
	19, // 92: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.EntitiesEntry.value:type_name -> google.cloud.contactcenterinsights.v1.Entity
	20, // 93: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.IntentsEntry.value:type_name -> google.cloud.contactcenterinsights.v1.Intent
	21, // 94: google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.PhraseMatchersEntry.value:type_name -> google.cloud.contactcenterinsights.v1.PhraseMatchData
	0,  // 95: google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium:type_name -> google.cloud.contactcenterinsights.v1.Conversation.Medium
	60, // 96: google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsEntry.value:type_name -> google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
	97, // [97:97] is the sub-list for method output_type
	97, // [97:97] is the sub-list for method input_type
	97, // [97:97] is the sub-list for extension type_name
	97, // [97:97] is the sub-list for extension extendee
	0,  // [0:97] is the sub-list for field type_name
}

func init() { file_google_cloud_contactcenterinsights_v1_resources_proto_init() }
func file_google_cloud_contactcenterinsights_v1_resources_proto_init() {
	if File_google_cloud_contactcenterinsights_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Conversation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Analysis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversationDataSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DialogflowSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalysisResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IssueModelResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversationLevelSentiment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IssueAssignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CallAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationBoundary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhraseMatchData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DialogflowIntent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterruptionData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SilenceData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HoldData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntityMentionData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentMatchData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SentimentData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IssueModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Issue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IssueModelLabelStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhraseMatcher); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhraseMatchRuleGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhraseMatchRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhraseMatchRuleConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExactMatchConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Settings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnswerFeedback); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArticleSuggestionData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FaqAnswerData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SmartReplyData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SmartComposeSuggestionData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DialogflowInteractionData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConversationParticipant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*View); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Conversation_CallMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Conversation_Transcript); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Conversation_Transcript_TranscriptSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Conversation_Transcript_TranscriptSegment_WordInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalysisResult_CallAnalysisMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IssueModel_InputDataConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IssueModelLabelStats_IssueStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Settings_AnalysisConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Conversation_CallMetadata_)(nil),
		(*Conversation_ExpireTime)(nil),
		(*Conversation_Ttl)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ConversationDataSource_GcsSource)(nil),
		(*ConversationDataSource_DialogflowSource)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*AnalysisResult_CallAnalysisMetadata_)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*CallAnnotation_InterruptionData)(nil),
		(*CallAnnotation_SentimentData)(nil),
		(*CallAnnotation_SilenceData)(nil),
		(*CallAnnotation_HoldData)(nil),
		(*CallAnnotation_EntityMentionData)(nil),
		(*CallAnnotation_IntentMatchData)(nil),
		(*CallAnnotation_PhraseMatchData)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*AnnotationBoundary_WordIndex)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[27].OneofWrappers = []interface{}{
		(*PhraseMatchRuleConfig_ExactMatchConfig)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[30].OneofWrappers = []interface{}{
		(*RuntimeAnnotation_ArticleSuggestion)(nil),
		(*RuntimeAnnotation_FaqAnswer)(nil),
		(*RuntimeAnnotation_SmartReply)(nil),
		(*RuntimeAnnotation_SmartComposeSuggestion)(nil),
		(*RuntimeAnnotation_DialogflowInteraction)(nil),
	}
	file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes[37].OneofWrappers = []interface{}{
		(*ConversationParticipant_DialogflowParticipantName)(nil),
		(*ConversationParticipant_UserId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contactcenterinsights_v1_resources_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   60,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contactcenterinsights_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_contactcenterinsights_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_contactcenterinsights_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_contactcenterinsights_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_contactcenterinsights_v1_resources_proto = out.File
	file_google_cloud_contactcenterinsights_v1_resources_proto_rawDesc = nil
	file_google_cloud_contactcenterinsights_v1_resources_proto_goTypes = nil
	file_google_cloud_contactcenterinsights_v1_resources_proto_depIdxs = nil
}
