package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDBResourcePool invokes the adb.DeleteDBResourcePool API synchronously
func (client *Client) DeleteDBResourcePool(request *DeleteDBResourcePoolRequest) (response *DeleteDBResourcePoolResponse, err error) {
	response = CreateDeleteDBResourcePoolResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDBResourcePoolWithChan invokes the adb.DeleteDBResourcePool API asynchronously
func (client *Client) DeleteDBResourcePoolWithChan(request *DeleteDBResourcePoolRequest) (<-chan *DeleteDBResourcePoolResponse, <-chan error) {
	responseChan := make(chan *DeleteDBResourcePoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDBResourcePool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDBResourcePoolWithCallback invokes the adb.DeleteDBResourcePool API asynchronously
func (client *Client) DeleteDBResourcePoolWithCallback(request *DeleteDBResourcePoolRequest, callback func(response *DeleteDBResourcePoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDBResourcePoolResponse
		var err error
		defer close(result)
		response, err = client.DeleteDBResourcePool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDBResourcePoolRequest is the request struct for api DeleteDBResourcePool
type DeleteDBResourcePoolRequest struct {
	*requests.RpcRequest
	PoolName             string           `position:"Query" name:"PoolName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteDBResourcePoolResponse is the response struct for api DeleteDBResourcePool
type DeleteDBResourcePoolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDBResourcePoolRequest creates a request to invoke DeleteDBResourcePool API
func CreateDeleteDBResourcePoolRequest() (request *DeleteDBResourcePoolRequest) {
	request = &DeleteDBResourcePoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DeleteDBResourcePool", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDBResourcePoolResponse creates a response to parse from DeleteDBResourcePool response
func CreateDeleteDBResourcePoolResponse() (response *DeleteDBResourcePoolResponse) {
	response = &DeleteDBResourcePoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
