package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHotParamRulesOfResource invokes the ahas_openapi.ListHotParamRulesOfResource API synchronously
func (client *Client) ListHotParamRulesOfResource(request *ListHotParamRulesOfResourceRequest) (response *ListHotParamRulesOfResourceResponse, err error) {
	response = CreateListHotParamRulesOfResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ListHotParamRulesOfResourceWithChan invokes the ahas_openapi.ListHotParamRulesOfResource API asynchronously
func (client *Client) ListHotParamRulesOfResourceWithChan(request *ListHotParamRulesOfResourceRequest) (<-chan *ListHotParamRulesOfResourceResponse, <-chan error) {
	responseChan := make(chan *ListHotParamRulesOfResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHotParamRulesOfResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHotParamRulesOfResourceWithCallback invokes the ahas_openapi.ListHotParamRulesOfResource API asynchronously
func (client *Client) ListHotParamRulesOfResourceWithCallback(request *ListHotParamRulesOfResourceRequest, callback func(response *ListHotParamRulesOfResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHotParamRulesOfResourceResponse
		var err error
		defer close(result)
		response, err = client.ListHotParamRulesOfResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHotParamRulesOfResourceRequest is the request struct for api ListHotParamRulesOfResource
type ListHotParamRulesOfResourceRequest struct {
	*requests.RpcRequest
	Resource     string           `position:"Query" name:"Resource"`
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
}

// ListHotParamRulesOfResourceResponse is the response struct for api ListHotParamRulesOfResource
type ListHotParamRulesOfResourceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListHotParamRulesOfResourceRequest creates a request to invoke ListHotParamRulesOfResource API
func CreateListHotParamRulesOfResourceRequest() (request *ListHotParamRulesOfResourceRequest) {
	request = &ListHotParamRulesOfResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListHotParamRulesOfResource", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListHotParamRulesOfResourceResponse creates a response to parse from ListHotParamRulesOfResource response
func CreateListHotParamRulesOfResourceResponse() (response *ListHotParamRulesOfResourceResponse) {
	response = &ListHotParamRulesOfResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
