package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachIndexVersion invokes the airec.AttachIndexVersion API synchronously
func (client *Client) AttachIndexVersion(request *AttachIndexVersionRequest) (response *AttachIndexVersionResponse, err error) {
	response = CreateAttachIndexVersionResponse()
	err = client.DoAction(request, response)
	return
}

// AttachIndexVersionWithChan invokes the airec.AttachIndexVersion API asynchronously
func (client *Client) AttachIndexVersionWithChan(request *AttachIndexVersionRequest) (<-chan *AttachIndexVersionResponse, <-chan error) {
	responseChan := make(chan *AttachIndexVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachIndexVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachIndexVersionWithCallback invokes the airec.AttachIndexVersion API asynchronously
func (client *Client) AttachIndexVersionWithCallback(request *AttachIndexVersionRequest, callback func(response *AttachIndexVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachIndexVersionResponse
		var err error
		defer close(result)
		response, err = client.AttachIndexVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachIndexVersionRequest is the request struct for api AttachIndexVersion
type AttachIndexVersionRequest struct {
	*requests.RoaRequest
	VersionId   string `position:"Path" name:"versionId"`
	InstanceId  string `position:"Path" name:"instanceId"`
	AlgorithmId string `position:"Path" name:"algorithmId"`
}

// AttachIndexVersionResponse is the response struct for api AttachIndexVersion
type AttachIndexVersionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    bool   `json:"result" xml:"result"`
}

// CreateAttachIndexVersionRequest creates a request to invoke AttachIndexVersion API
func CreateAttachIndexVersionRequest() (request *AttachIndexVersionRequest) {
	request = &AttachIndexVersionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "AttachIndexVersion", "/v2/openapi/instances/[instanceId]/filtering-algorithms/[algorithmId]/index-versions/[versionId]/actions/attach", "airec", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachIndexVersionResponse creates a response to parse from AttachIndexVersion response
func CreateAttachIndexVersionResponse() (response *AttachIndexVersionResponse) {
	response = &AttachIndexVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
