package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LastTestYingShe invokes the amp.LastTestYingShe API synchronously
func (client *Client) LastTestYingShe(request *LastTestYingSheRequest) (response *LastTestYingSheResponse, err error) {
	response = CreateLastTestYingSheResponse()
	err = client.DoAction(request, response)
	return
}

// LastTestYingSheWithChan invokes the amp.LastTestYingShe API asynchronously
func (client *Client) LastTestYingSheWithChan(request *LastTestYingSheRequest) (<-chan *LastTestYingSheResponse, <-chan error) {
	responseChan := make(chan *LastTestYingSheResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LastTestYingShe(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LastTestYingSheWithCallback invokes the amp.LastTestYingShe API asynchronously
func (client *Client) LastTestYingSheWithCallback(request *LastTestYingSheRequest, callback func(response *LastTestYingSheResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LastTestYingSheResponse
		var err error
		defer close(result)
		response, err = client.LastTestYingShe(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LastTestYingSheRequest is the request struct for api LastTestYingShe
type LastTestYingSheRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// LastTestYingSheResponse is the response struct for api LastTestYingShe
type LastTestYingSheResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateLastTestYingSheRequest creates a request to invoke LastTestYingShe API
func CreateLastTestYingSheRequest() (request *LastTestYingSheRequest) {
	request = &LastTestYingSheRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "LastTestYingShe", "/aef/yig", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLastTestYingSheResponse creates a response to parse from LastTestYingShe response
func CreateLastTestYingSheResponse() (response *LastTestYingSheResponse) {
	response = &LastTestYingSheResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
