package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MyRoaApi invokes the amp.MyRoaApi API synchronously
func (client *Client) MyRoaApi(request *MyRoaApiRequest) (response *MyRoaApiResponse, err error) {
	response = CreateMyRoaApiResponse()
	err = client.DoAction(request, response)
	return
}

// MyRoaApiWithChan invokes the amp.MyRoaApi API asynchronously
func (client *Client) MyRoaApiWithChan(request *MyRoaApiRequest) (<-chan *MyRoaApiResponse, <-chan error) {
	responseChan := make(chan *MyRoaApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MyRoaApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MyRoaApiWithCallback invokes the amp.MyRoaApi API asynchronously
func (client *Client) MyRoaApiWithCallback(request *MyRoaApiRequest, callback func(response *MyRoaApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MyRoaApiResponse
		var err error
		defer close(result)
		response, err = client.MyRoaApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MyRoaApiRequest is the request struct for api MyRoaApi
type MyRoaApiRequest struct {
	*requests.RoaRequest
	Resourceownerid      string `position:"Query" name:"resourceownerid"`
	Resourceowneraccount string `position:"Path" name:"resourceowneraccount"`
	Securitytoken        string `position:"Query" name:"securitytoken"`
	Owneraccount         string `position:"Header" name:"owneraccount"`
	Name                 string `position:"Query" name:"name"`
	Accesskeysecret      string `position:"Query" name:"accesskeysecret"`
	Id                   string `position:"Query" name:"id"`
	Ownerid              string `position:"Query" name:"ownerid"`
}

// MyRoaApiResponse is the response struct for api MyRoaApi
type MyRoaApiResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMyRoaApiRequest creates a request to invoke MyRoaApi API
func CreateMyRoaApiRequest() (request *MyRoaApiRequest) {
	request = &MyRoaApiRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "MyRoaApi", "/my/roa/test", "ServiceCode", "openAPI")
	request.Method = requests.GET
	return
}

// CreateMyRoaApiResponse creates a response to parse from MyRoaApi response
func CreateMyRoaApiResponse() (response *MyRoaApiResponse) {
	response = &MyRoaApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
