package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SecondAPI invokes the amp.SecondAPI API synchronously
func (client *Client) SecondAPI(request *SecondAPIRequest) (response *SecondAPIResponse, err error) {
	response = CreateSecondAPIResponse()
	err = client.DoAction(request, response)
	return
}

// SecondAPIWithChan invokes the amp.SecondAPI API asynchronously
func (client *Client) SecondAPIWithChan(request *SecondAPIRequest) (<-chan *SecondAPIResponse, <-chan error) {
	responseChan := make(chan *SecondAPIResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SecondAPI(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SecondAPIWithCallback invokes the amp.SecondAPI API asynchronously
func (client *Client) SecondAPIWithCallback(request *SecondAPIRequest, callback func(response *SecondAPIResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SecondAPIResponse
		var err error
		defer close(result)
		response, err = client.SecondAPI(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SecondAPIRequest is the request struct for api SecondAPI
type SecondAPIRequest struct {
	*requests.RoaRequest
}

// SecondAPIResponse is the response struct for api SecondAPI
type SecondAPIResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateSecondAPIRequest creates a request to invoke SecondAPI API
func CreateSecondAPIRequest() (request *SecondAPIRequest) {
	request = &SecondAPIRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "SecondAPI", "/api/second", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSecondAPIResponse creates a response to parse from SecondAPI response
func CreateSecondAPIResponse() (response *SecondAPIResponse) {
	response = &SecondAPIResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
