package apds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMigrationJobConfig invokes the apds.DescribeMigrationJobConfig API synchronously
func (client *Client) DescribeMigrationJobConfig(request *DescribeMigrationJobConfigRequest) (response *DescribeMigrationJobConfigResponse, err error) {
	response = CreateDescribeMigrationJobConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMigrationJobConfigWithChan invokes the apds.DescribeMigrationJobConfig API asynchronously
func (client *Client) DescribeMigrationJobConfigWithChan(request *DescribeMigrationJobConfigRequest) (<-chan *DescribeMigrationJobConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeMigrationJobConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMigrationJobConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMigrationJobConfigWithCallback invokes the apds.DescribeMigrationJobConfig API asynchronously
func (client *Client) DescribeMigrationJobConfigWithCallback(request *DescribeMigrationJobConfigRequest, callback func(response *DescribeMigrationJobConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMigrationJobConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeMigrationJobConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMigrationJobConfigRequest is the request struct for api DescribeMigrationJobConfig
type DescribeMigrationJobConfigRequest struct {
	*requests.RoaRequest
}

// DescribeMigrationJobConfigResponse is the response struct for api DescribeMigrationJobConfig
type DescribeMigrationJobConfigResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Error   string `json:"error" xml:"error"`
	Success bool   `json:"Success" xml:"Success"`
	Data    string `json:"Data" xml:"Data"`
}

// CreateDescribeMigrationJobConfigRequest creates a request to invoke DescribeMigrationJobConfig API
func CreateDescribeMigrationJobConfigRequest() (request *DescribeMigrationJobConfigRequest) {
	request = &DescribeMigrationJobConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("apds", "2022-03-31", "DescribeMigrationJobConfig", "/okss-services/migration-job/describe-migration-job-config", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeMigrationJobConfigResponse creates a response to parse from DescribeMigrationJobConfig response
func CreateDescribeMigrationJobConfigResponse() (response *DescribeMigrationJobConfigResponse) {
	response = &DescribeMigrationJobConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
