package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBizLine invokes the biz_ipdb.CreateBizLine API synchronously
func (client *Client) CreateBizLine(request *CreateBizLineRequest) (response *CreateBizLineResponse, err error) {
	response = CreateCreateBizLineResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBizLineWithChan invokes the biz_ipdb.CreateBizLine API asynchronously
func (client *Client) CreateBizLineWithChan(request *CreateBizLineRequest) (<-chan *CreateBizLineResponse, <-chan error) {
	responseChan := make(chan *CreateBizLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBizLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBizLineWithCallback invokes the biz_ipdb.CreateBizLine API asynchronously
func (client *Client) CreateBizLineWithCallback(request *CreateBizLineRequest, callback func(response *CreateBizLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBizLineResponse
		var err error
		defer close(result)
		response, err = client.CreateBizLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBizLineRequest is the request struct for api CreateBizLine
type CreateBizLineRequest struct {
	*requests.RpcRequest
	Partner requests.Boolean `position:"Query" name:"Partner"`
	CnName  string           `position:"Query" name:"CnName"`
	BizLine string           `position:"Query" name:"BizLine"`
	EnName  string           `position:"Query" name:"EnName"`
}

// CreateBizLineResponse is the response struct for api CreateBizLine
type CreateBizLineResponse struct {
	*responses.BaseResponse
	Id        int64  `json:"Id" xml:"Id"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateBizLineRequest creates a request to invoke CreateBizLine API
func CreateCreateBizLineRequest() (request *CreateBizLineRequest) {
	request = &CreateBizLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "CreateBizLine", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateBizLineResponse creates a response to parse from CreateBizLine response
func CreateCreateBizLineResponse() (response *CreateBizLineResponse) {
	response = &CreateBizLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
