package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResourceUsageDetail invokes the bssopenapi.DescribeResourceUsageDetail API synchronously
func (client *Client) DescribeResourceUsageDetail(request *DescribeResourceUsageDetailRequest) (response *DescribeResourceUsageDetailResponse, err error) {
	response = CreateDescribeResourceUsageDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResourceUsageDetailWithChan invokes the bssopenapi.DescribeResourceUsageDetail API asynchronously
func (client *Client) DescribeResourceUsageDetailWithChan(request *DescribeResourceUsageDetailRequest) (<-chan *DescribeResourceUsageDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeResourceUsageDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResourceUsageDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResourceUsageDetailWithCallback invokes the bssopenapi.DescribeResourceUsageDetail API asynchronously
func (client *Client) DescribeResourceUsageDetailWithCallback(request *DescribeResourceUsageDetailRequest, callback func(response *DescribeResourceUsageDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResourceUsageDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeResourceUsageDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResourceUsageDetailRequest is the request struct for api DescribeResourceUsageDetail
type DescribeResourceUsageDetailRequest struct {
	*requests.RpcRequest
	PeriodType   string           `position:"Query" name:"PeriodType"`
	BillOwnerId  requests.Integer `position:"Query" name:"BillOwnerId"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	StartPeriod  string           `position:"Query" name:"StartPeriod"`
	EndPeriod    string           `position:"Query" name:"EndPeriod"`
	NextToken    string           `position:"Query" name:"NextToken"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeResourceUsageDetailResponse is the response struct for api DescribeResourceUsageDetail
type DescribeResourceUsageDetailResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeResourceUsageDetailRequest creates a request to invoke DescribeResourceUsageDetail API
func CreateDescribeResourceUsageDetailRequest() (request *DescribeResourceUsageDetailRequest) {
	request = &DescribeResourceUsageDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeResourceUsageDetail", "bssopenapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeResourceUsageDetailResponse creates a response to parse from DescribeResourceUsageDetail response
func CreateDescribeResourceUsageDetailResponse() (response *DescribeResourceUsageDetailResponse) {
	response = &DescribeResourceUsageDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
