package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportDoNotCallNumbers invokes the ccc.ImportDoNotCallNumbers API synchronously
func (client *Client) ImportDoNotCallNumbers(request *ImportDoNotCallNumbersRequest) (response *ImportDoNotCallNumbersResponse, err error) {
	response = CreateImportDoNotCallNumbersResponse()
	err = client.DoAction(request, response)
	return
}

// ImportDoNotCallNumbersWithChan invokes the ccc.ImportDoNotCallNumbers API asynchronously
func (client *Client) ImportDoNotCallNumbersWithChan(request *ImportDoNotCallNumbersRequest) (<-chan *ImportDoNotCallNumbersResponse, <-chan error) {
	responseChan := make(chan *ImportDoNotCallNumbersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportDoNotCallNumbers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportDoNotCallNumbersWithCallback invokes the ccc.ImportDoNotCallNumbers API asynchronously
func (client *Client) ImportDoNotCallNumbersWithCallback(request *ImportDoNotCallNumbersRequest, callback func(response *ImportDoNotCallNumbersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportDoNotCallNumbersResponse
		var err error
		defer close(result)
		response, err = client.ImportDoNotCallNumbers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportDoNotCallNumbersRequest is the request struct for api ImportDoNotCallNumbers
type ImportDoNotCallNumbersRequest struct {
	*requests.RpcRequest
	Remark     string `position:"Query" name:"Remark"`
	NumberList string `position:"Query" name:"NumberList"`
	InstanceId string `position:"Query" name:"InstanceId"`
	FilePath   string `position:"Query" name:"FilePath"`
}

// ImportDoNotCallNumbersResponse is the response struct for api ImportDoNotCallNumbers
type ImportDoNotCallNumbersResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateImportDoNotCallNumbersRequest creates a request to invoke ImportDoNotCallNumbers API
func CreateImportDoNotCallNumbersRequest() (request *ImportDoNotCallNumbersRequest) {
	request = &ImportDoNotCallNumbersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ImportDoNotCallNumbers", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImportDoNotCallNumbersResponse creates a response to parse from ImportDoNotCallNumbers response
func CreateImportDoNotCallNumbersResponse() (response *ImportDoNotCallNumbersResponse) {
	response = &ImportDoNotCallNumbersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
