package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlerts invokes the cloud_siem.DescribeAlerts API synchronously
func (client *Client) DescribeAlerts(request *DescribeAlertsRequest) (response *DescribeAlertsResponse, err error) {
	response = CreateDescribeAlertsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlertsWithChan invokes the cloud_siem.DescribeAlerts API asynchronously
func (client *Client) DescribeAlertsWithChan(request *DescribeAlertsRequest) (<-chan *DescribeAlertsResponse, <-chan error) {
	responseChan := make(chan *DescribeAlertsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlerts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlertsWithCallback invokes the cloud_siem.DescribeAlerts API asynchronously
func (client *Client) DescribeAlertsWithCallback(request *DescribeAlertsRequest, callback func(response *DescribeAlertsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlertsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlerts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlertsRequest is the request struct for api DescribeAlerts
type DescribeAlertsRequest struct {
	*requests.RpcRequest
	Source      string           `position:"Body" name:"Source"`
	IsDefend    string           `position:"Body" name:"IsDefend"`
	StartTime   requests.Integer `position:"Body" name:"StartTime"`
	SubUserId   string           `position:"Body" name:"SubUserId"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	Level       *[]string        `position:"Body" name:"Level"  type:"Repeated"`
	EndTime     requests.Integer `position:"Body" name:"EndTime"`
	AlertTitle  string           `position:"Body" name:"AlertTitle"`
	CurrentPage requests.Integer `position:"Body" name:"CurrentPage"`
	AlertUuid   string           `position:"Body" name:"AlertUuid"`
}

// DescribeAlertsResponse is the response struct for api DescribeAlerts
type DescribeAlertsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeAlertsRequest creates a request to invoke DescribeAlerts API
func CreateDescribeAlertsRequest() (request *DescribeAlertsRequest) {
	request = &DescribeAlertsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeAlerts", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAlertsResponse creates a response to parse from DescribeAlerts response
func CreateDescribeAlertsResponse() (response *DescribeAlertsResponse) {
	response = &DescribeAlertsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
