package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableInstanceAccessControl invokes the cloudapi.EnableInstanceAccessControl API synchronously
func (client *Client) EnableInstanceAccessControl(request *EnableInstanceAccessControlRequest) (response *EnableInstanceAccessControlResponse, err error) {
	response = CreateEnableInstanceAccessControlResponse()
	err = client.DoAction(request, response)
	return
}

// EnableInstanceAccessControlWithChan invokes the cloudapi.EnableInstanceAccessControl API asynchronously
func (client *Client) EnableInstanceAccessControlWithChan(request *EnableInstanceAccessControlRequest) (<-chan *EnableInstanceAccessControlResponse, <-chan error) {
	responseChan := make(chan *EnableInstanceAccessControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableInstanceAccessControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableInstanceAccessControlWithCallback invokes the cloudapi.EnableInstanceAccessControl API asynchronously
func (client *Client) EnableInstanceAccessControlWithCallback(request *EnableInstanceAccessControlRequest, callback func(response *EnableInstanceAccessControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableInstanceAccessControlResponse
		var err error
		defer close(result)
		response, err = client.EnableInstanceAccessControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableInstanceAccessControlRequest is the request struct for api EnableInstanceAccessControl
type EnableInstanceAccessControlRequest struct {
	*requests.RpcRequest
	AclId            string `position:"Query" name:"AclId"`
	AddressIPVersion string `position:"Query" name:"AddressIPVersion"`
	AclType          string `position:"Query" name:"AclType"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	SecurityToken    string `position:"Query" name:"SecurityToken"`
}

// EnableInstanceAccessControlResponse is the response struct for api EnableInstanceAccessControl
type EnableInstanceAccessControlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableInstanceAccessControlRequest creates a request to invoke EnableInstanceAccessControl API
func CreateEnableInstanceAccessControlRequest() (request *EnableInstanceAccessControlRequest) {
	request = &EnableInstanceAccessControlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "EnableInstanceAccessControl", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableInstanceAccessControlResponse creates a response to parse from EnableInstanceAccessControl response
func CreateEnableInstanceAccessControlResponse() (response *EnableInstanceAccessControlResponse) {
	response = &EnableInstanceAccessControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
