package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCrowdList invokes the cloudwf.GetCrowdList API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getcrowdlist.html
func (client *Client) GetCrowdList(request *GetCrowdListRequest) (response *GetCrowdListResponse, err error) {
	response = CreateGetCrowdListResponse()
	err = client.DoAction(request, response)
	return
}

// GetCrowdListWithChan invokes the cloudwf.GetCrowdList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getcrowdlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCrowdListWithChan(request *GetCrowdListRequest) (<-chan *GetCrowdListResponse, <-chan error) {
	responseChan := make(chan *GetCrowdListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCrowdList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCrowdListWithCallback invokes the cloudwf.GetCrowdList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getcrowdlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCrowdListWithCallback(request *GetCrowdListRequest, callback func(response *GetCrowdListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCrowdListResponse
		var err error
		defer close(result)
		response, err = client.GetCrowdList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCrowdListRequest is the request struct for api GetCrowdList
type GetCrowdListRequest struct {
	*requests.RpcRequest
	Gsid      requests.Integer `position:"Query" name:"Gsid"`
	ClassType requests.Integer `position:"Query" name:"ClassType"`
	GsType    string           `position:"Query" name:"GsType"`
	EndTime   string           `position:"Query" name:"EndTime"`
	Page      requests.Integer `position:"Query" name:"Page"`
	StartTime string           `position:"Query" name:"StartTime"`
	Per       requests.Integer `position:"Query" name:"Per"`
	Bid       requests.Integer `position:"Query" name:"Bid"`
}

// GetCrowdListResponse is the response struct for api GetCrowdList
type GetCrowdListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetCrowdListRequest creates a request to invoke GetCrowdList API
func CreateGetCrowdListRequest() (request *GetCrowdListRequest) {
	request = &GetCrowdListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetCrowdList", "cloudwf", "openAPI")
	return
}

// CreateGetCrowdListResponse creates a response to parse from GetCrowdList response
func CreateGetCrowdListResponse() (response *GetCrowdListResponse) {
	response = &GetCrowdListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
