package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeServiceInstance invokes the computenestsupplier.UpgradeServiceInstance API synchronously
func (client *Client) UpgradeServiceInstance(request *UpgradeServiceInstanceRequest) (response *UpgradeServiceInstanceResponse, err error) {
	response = CreateUpgradeServiceInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeServiceInstanceWithChan invokes the computenestsupplier.UpgradeServiceInstance API asynchronously
func (client *Client) UpgradeServiceInstanceWithChan(request *UpgradeServiceInstanceRequest) (<-chan *UpgradeServiceInstanceResponse, <-chan error) {
	responseChan := make(chan *UpgradeServiceInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeServiceInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeServiceInstanceWithCallback invokes the computenestsupplier.UpgradeServiceInstance API asynchronously
func (client *Client) UpgradeServiceInstanceWithCallback(request *UpgradeServiceInstanceRequest, callback func(response *UpgradeServiceInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeServiceInstanceResponse
		var err error
		defer close(result)
		response, err = client.UpgradeServiceInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeServiceInstanceRequest is the request struct for api UpgradeServiceInstance
type UpgradeServiceInstanceRequest struct {
	*requests.RpcRequest
	ClientToken       string `position:"Query" name:"ClientToken"`
	ServiceInstanceId string `position:"Query" name:"ServiceInstanceId"`
	DryRun            string `position:"Query" name:"DryRun"`
	ServiceVersion    string `position:"Query" name:"ServiceVersion"`
	Parameters        string `position:"Query" name:"Parameters"`
}

// UpgradeServiceInstanceResponse is the response struct for api UpgradeServiceInstance
type UpgradeServiceInstanceResponse struct {
	*responses.BaseResponse
	Status                    string   `json:"Status" xml:"Status"`
	RequestId                 string   `json:"RequestId" xml:"RequestId"`
	ServiceInstanceId         string   `json:"ServiceInstanceId" xml:"ServiceInstanceId"`
	UpgradeRequiredParameters []string `json:"UpgradeRequiredParameters" xml:"UpgradeRequiredParameters"`
}

// CreateUpgradeServiceInstanceRequest creates a request to invoke UpgradeServiceInstance API
func CreateUpgradeServiceInstanceRequest() (request *UpgradeServiceInstanceRequest) {
	request = &UpgradeServiceInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "UpgradeServiceInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateUpgradeServiceInstanceResponse creates a response to parse from UpgradeServiceInstance response
func CreateUpgradeServiceInstanceResponse() (response *UpgradeServiceInstanceResponse) {
	response = &UpgradeServiceInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
