package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAggregateCompliancePack invokes the config.UpdateAggregateCompliancePack API synchronously
func (client *Client) UpdateAggregateCompliancePack(request *UpdateAggregateCompliancePackRequest) (response *UpdateAggregateCompliancePackResponse, err error) {
	response = CreateUpdateAggregateCompliancePackResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAggregateCompliancePackWithChan invokes the config.UpdateAggregateCompliancePack API asynchronously
func (client *Client) UpdateAggregateCompliancePackWithChan(request *UpdateAggregateCompliancePackRequest) (<-chan *UpdateAggregateCompliancePackResponse, <-chan error) {
	responseChan := make(chan *UpdateAggregateCompliancePackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAggregateCompliancePack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAggregateCompliancePackWithCallback invokes the config.UpdateAggregateCompliancePack API asynchronously
func (client *Client) UpdateAggregateCompliancePackWithCallback(request *UpdateAggregateCompliancePackRequest, callback func(response *UpdateAggregateCompliancePackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAggregateCompliancePackResponse
		var err error
		defer close(result)
		response, err = client.UpdateAggregateCompliancePack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAggregateCompliancePackRequest is the request struct for api UpdateAggregateCompliancePack
type UpdateAggregateCompliancePackRequest struct {
	*requests.RpcRequest
	TagKeyScope             string                                      `position:"Body" name:"TagKeyScope"`
	CompliancePackName      string                                      `position:"Body" name:"CompliancePackName"`
	ClientToken             string                                      `position:"Body" name:"ClientToken"`
	Description             string                                      `position:"Body" name:"Description"`
	AggregatorId            string                                      `position:"Body" name:"AggregatorId"`
	TagValueScope           string                                      `position:"Body" name:"TagValueScope"`
	RegionIdsScope          string                                      `position:"Body" name:"RegionIdsScope"`
	CompliancePackId        string                                      `position:"Body" name:"CompliancePackId"`
	ConfigRules             *[]UpdateAggregateCompliancePackConfigRules `position:"Body" name:"ConfigRules"  type:"Json"`
	RiskLevel               requests.Integer                            `position:"Body" name:"RiskLevel"`
	ResourceGroupIdsScope   string                                      `position:"Body" name:"ResourceGroupIdsScope"`
	ExcludeResourceIdsScope string                                      `position:"Body" name:"ExcludeResourceIdsScope"`
}

// UpdateAggregateCompliancePackConfigRules is a repeated param struct in UpdateAggregateCompliancePackRequest
type UpdateAggregateCompliancePackConfigRules struct {
	ManagedRuleIdentifier string                                                              `name:"ManagedRuleIdentifier"`
	ConfigRuleParameters  *[]UpdateAggregateCompliancePackConfigRulesConfigRuleParametersItem `name:"ConfigRuleParameters" type:"Repeated"`
	ConfigRuleId          string                                                              `name:"ConfigRuleId"`
	ConfigRuleName        string                                                              `name:"ConfigRuleName"`
	Description           string                                                              `name:"Description"`
	RiskLevel             string                                                              `name:"RiskLevel"`
}

// UpdateAggregateCompliancePackConfigRulesConfigRuleParametersItem is a repeated param struct in UpdateAggregateCompliancePackRequest
type UpdateAggregateCompliancePackConfigRulesConfigRuleParametersItem struct {
	ParameterValue string `name:"ParameterValue"`
	ParameterName  string `name:"ParameterName"`
}

// UpdateAggregateCompliancePackResponse is the response struct for api UpdateAggregateCompliancePack
type UpdateAggregateCompliancePackResponse struct {
	*responses.BaseResponse
	CompliancePackId string `json:"CompliancePackId" xml:"CompliancePackId"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAggregateCompliancePackRequest creates a request to invoke UpdateAggregateCompliancePack API
func CreateUpdateAggregateCompliancePackRequest() (request *UpdateAggregateCompliancePackRequest) {
	request = &UpdateAggregateCompliancePackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "UpdateAggregateCompliancePack", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateAggregateCompliancePackResponse creates a response to parse from UpdateAggregateCompliancePack response
func CreateUpdateAggregateCompliancePackResponse() (response *UpdateAggregateCompliancePackResponse) {
	response = &UpdateAggregateCompliancePackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
