package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgQueryDefaultTemplates invokes the dataworks_public.DsgQueryDefaultTemplates API synchronously
func (client *Client) DsgQueryDefaultTemplates(request *DsgQueryDefaultTemplatesRequest) (response *DsgQueryDefaultTemplatesResponse, err error) {
	response = CreateDsgQueryDefaultTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// DsgQueryDefaultTemplatesWithChan invokes the dataworks_public.DsgQueryDefaultTemplates API asynchronously
func (client *Client) DsgQueryDefaultTemplatesWithChan(request *DsgQueryDefaultTemplatesRequest) (<-chan *DsgQueryDefaultTemplatesResponse, <-chan error) {
	responseChan := make(chan *DsgQueryDefaultTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgQueryDefaultTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgQueryDefaultTemplatesWithCallback invokes the dataworks_public.DsgQueryDefaultTemplates API asynchronously
func (client *Client) DsgQueryDefaultTemplatesWithCallback(request *DsgQueryDefaultTemplatesRequest, callback func(response *DsgQueryDefaultTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgQueryDefaultTemplatesResponse
		var err error
		defer close(result)
		response, err = client.DsgQueryDefaultTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgQueryDefaultTemplatesRequest is the request struct for api DsgQueryDefaultTemplates
type DsgQueryDefaultTemplatesRequest struct {
	*requests.RpcRequest
	SceneId requests.Integer `position:"Query" name:"SceneId"`
}

// DsgQueryDefaultTemplatesResponse is the response struct for api DsgQueryDefaultTemplates
type DsgQueryDefaultTemplatesResponse struct {
	*responses.BaseResponse
}

// CreateDsgQueryDefaultTemplatesRequest creates a request to invoke DsgQueryDefaultTemplates API
func CreateDsgQueryDefaultTemplatesRequest() (request *DsgQueryDefaultTemplatesRequest) {
	request = &DsgQueryDefaultTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgQueryDefaultTemplates", "", "")
	request.Method = requests.GET
	return
}

// CreateDsgQueryDefaultTemplatesResponse creates a response to parse from DsgQueryDefaultTemplates response
func CreateDsgQueryDefaultTemplatesResponse() (response *DsgQueryDefaultTemplatesResponse) {
	response = &DsgQueryDefaultTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
