package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgStopSensIdentify invokes the dataworks_public.DsgStopSensIdentify API synchronously
func (client *Client) DsgStopSensIdentify(request *DsgStopSensIdentifyRequest) (response *DsgStopSensIdentifyResponse, err error) {
	response = CreateDsgStopSensIdentifyResponse()
	err = client.DoAction(request, response)
	return
}

// DsgStopSensIdentifyWithChan invokes the dataworks_public.DsgStopSensIdentify API asynchronously
func (client *Client) DsgStopSensIdentifyWithChan(request *DsgStopSensIdentifyRequest) (<-chan *DsgStopSensIdentifyResponse, <-chan error) {
	responseChan := make(chan *DsgStopSensIdentifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgStopSensIdentify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgStopSensIdentifyWithCallback invokes the dataworks_public.DsgStopSensIdentify API asynchronously
func (client *Client) DsgStopSensIdentifyWithCallback(request *DsgStopSensIdentifyRequest, callback func(response *DsgStopSensIdentifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgStopSensIdentifyResponse
		var err error
		defer close(result)
		response, err = client.DsgStopSensIdentify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgStopSensIdentifyRequest is the request struct for api DsgStopSensIdentify
type DsgStopSensIdentifyRequest struct {
	*requests.RpcRequest
	JobId    requests.Integer `position:"Body" name:"JobId"`
	TenantId string           `position:"Body" name:"TenantId"`
}

// DsgStopSensIdentifyResponse is the response struct for api DsgStopSensIdentify
type DsgStopSensIdentifyResponse struct {
	*responses.BaseResponse
}

// CreateDsgStopSensIdentifyRequest creates a request to invoke DsgStopSensIdentify API
func CreateDsgStopSensIdentifyRequest() (request *DsgStopSensIdentifyRequest) {
	request = &DsgStopSensIdentifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgStopSensIdentify", "", "")
	request.Method = requests.POST
	return
}

// CreateDsgStopSensIdentifyResponse creates a response to parse from DsgStopSensIdentify response
func CreateDsgStopSensIdentifyResponse() (response *DsgStopSensIdentifyResponse) {
	response = &DsgStopSensIdentifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
