package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstanceAmount invokes the dataworks_public.ListInstanceAmount API synchronously
func (client *Client) ListInstanceAmount(request *ListInstanceAmountRequest) (response *ListInstanceAmountResponse, err error) {
	response = CreateListInstanceAmountResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceAmountWithChan invokes the dataworks_public.ListInstanceAmount API asynchronously
func (client *Client) ListInstanceAmountWithChan(request *ListInstanceAmountRequest) (<-chan *ListInstanceAmountResponse, <-chan error) {
	responseChan := make(chan *ListInstanceAmountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstanceAmount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceAmountWithCallback invokes the dataworks_public.ListInstanceAmount API asynchronously
func (client *Client) ListInstanceAmountWithCallback(request *ListInstanceAmountRequest, callback func(response *ListInstanceAmountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceAmountResponse
		var err error
		defer close(result)
		response, err = client.ListInstanceAmount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceAmountRequest is the request struct for api ListInstanceAmount
type ListInstanceAmountRequest struct {
	*requests.RpcRequest
	BeginDate string           `position:"Body" name:"BeginDate"`
	EndDate   string           `position:"Body" name:"EndDate"`
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
}

// ListInstanceAmountResponse is the response struct for api ListInstanceAmount
type ListInstanceAmountResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	InstanceCounts []IntanceCounts `json:"InstanceCounts" xml:"InstanceCounts"`
}

// CreateListInstanceAmountRequest creates a request to invoke ListInstanceAmount API
func CreateListInstanceAmountRequest() (request *ListInstanceAmountRequest) {
	request = &ListInstanceAmountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListInstanceAmount", "", "")
	request.Method = requests.POST
	return
}

// CreateListInstanceAmountResponse creates a response to parse from ListInstanceAmount response
func CreateListInstanceAmountResponse() (response *ListInstanceAmountResponse) {
	response = &ListInstanceAmountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
