package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafGroups invokes the dcdn.DescribeDcdnWafGroups API synchronously
func (client *Client) DescribeDcdnWafGroups(request *DescribeDcdnWafGroupsRequest) (response *DescribeDcdnWafGroupsResponse, err error) {
	response = CreateDescribeDcdnWafGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafGroupsWithChan invokes the dcdn.DescribeDcdnWafGroups API asynchronously
func (client *Client) DescribeDcdnWafGroupsWithChan(request *DescribeDcdnWafGroupsRequest) (<-chan *DescribeDcdnWafGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafGroupsWithCallback invokes the dcdn.DescribeDcdnWafGroups API asynchronously
func (client *Client) DescribeDcdnWafGroupsWithCallback(request *DescribeDcdnWafGroupsRequest, callback func(response *DescribeDcdnWafGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafGroupsRequest is the request struct for api DescribeDcdnWafGroups
type DescribeDcdnWafGroupsRequest struct {
	*requests.RpcRequest
	QueryArgs  string           `position:"Query" name:"QueryArgs"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Language   string           `position:"Query" name:"Language"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeDcdnWafGroupsResponse is the response struct for api DescribeDcdnWafGroups
type DescribeDcdnWafGroupsResponse struct {
	*responses.BaseResponse
	RequestId  string         `json:"RequestId" xml:"RequestId"`
	TotalCount int            `json:"TotalCount" xml:"TotalCount"`
	PageNumber int            `json:"PageNumber" xml:"PageNumber"`
	PageSize   int            `json:"PageSize" xml:"PageSize"`
	WafGroups  []WafGroupItem `json:"WafGroups" xml:"WafGroups"`
}

// CreateDescribeDcdnWafGroupsRequest creates a request to invoke DescribeDcdnWafGroups API
func CreateDescribeDcdnWafGroupsRequest() (request *DescribeDcdnWafGroupsRequest) {
	request = &DescribeDcdnWafGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafGroups", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafGroupsResponse creates a response to parse from DescribeDcdnWafGroups response
func CreateDescribeDcdnWafGroupsResponse() (response *DescribeDcdnWafGroupsResponse) {
	response = &DescribeDcdnWafGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
