package dypnsapi_intl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartVerification invokes the dypnsapi_intl.StartVerification API synchronously
func (client *Client) StartVerification(request *StartVerificationRequest) (response *StartVerificationResponse, err error) {
	response = CreateStartVerificationResponse()
	err = client.DoAction(request, response)
	return
}

// StartVerificationWithChan invokes the dypnsapi_intl.StartVerification API asynchronously
func (client *Client) StartVerificationWithChan(request *StartVerificationRequest) (<-chan *StartVerificationResponse, <-chan error) {
	responseChan := make(chan *StartVerificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartVerification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartVerificationWithCallback invokes the dypnsapi_intl.StartVerification API asynchronously
func (client *Client) StartVerificationWithCallback(request *StartVerificationRequest, callback func(response *StartVerificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartVerificationResponse
		var err error
		defer close(result)
		response, err = client.StartVerification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartVerificationRequest is the request struct for api StartVerification
type StartVerificationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Channel              string           `position:"Query" name:"Channel"`
	ServiceSid           string           `position:"Query" name:"ServiceSid"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	To                   string           `position:"Query" name:"To"`
}

// StartVerificationResponse is the response struct for api StartVerification
type StartVerificationResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Message   string                 `json:"Message" xml:"Message"`
	Model     map[string]interface{} `json:"Model" xml:"Model"`
	Code      string                 `json:"Code" xml:"Code"`
	Success   bool                   `json:"Success" xml:"Success"`
}

// CreateStartVerificationRequest creates a request to invoke StartVerification API
func CreateStartVerificationRequest() (request *StartVerificationRequest) {
	request = &StartVerificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi-intl", "2017-07-25", "StartVerification", "", "")
	request.Method = requests.POST
	return
}

// CreateStartVerificationResponse creates a response to parse from StartVerification response
func CreateStartVerificationResponse() (response *StartVerificationResponse) {
	response = &StartVerificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
