package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendMessageToGlobe invokes the dysmsapi.SendMessageToGlobe API synchronously
func (client *Client) SendMessageToGlobe(request *SendMessageToGlobeRequest) (response *SendMessageToGlobeResponse, err error) {
	response = CreateSendMessageToGlobeResponse()
	err = client.DoAction(request, response)
	return
}

// SendMessageToGlobeWithChan invokes the dysmsapi.SendMessageToGlobe API asynchronously
func (client *Client) SendMessageToGlobeWithChan(request *SendMessageToGlobeRequest) (<-chan *SendMessageToGlobeResponse, <-chan error) {
	responseChan := make(chan *SendMessageToGlobeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendMessageToGlobe(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendMessageToGlobeWithCallback invokes the dysmsapi.SendMessageToGlobe API asynchronously
func (client *Client) SendMessageToGlobeWithCallback(request *SendMessageToGlobeRequest, callback func(response *SendMessageToGlobeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendMessageToGlobeResponse
		var err error
		defer close(result)
		response, err = client.SendMessageToGlobe(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendMessageToGlobeRequest is the request struct for api SendMessageToGlobe
type SendMessageToGlobeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Type                 string           `position:"Query" name:"Type"`
	From                 string           `position:"Query" name:"From"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Message              string           `position:"Query" name:"Message"`
	ValidityPeriod       requests.Integer `position:"Query" name:"ValidityPeriod"`
	To                   string           `position:"Query" name:"To"`
	ChannelId            string           `position:"Query" name:"ChannelId"`
}

// SendMessageToGlobeResponse is the response struct for api SendMessageToGlobe
type SendMessageToGlobeResponse struct {
	*responses.BaseResponse
	ResponseCode        string       `json:"ResponseCode" xml:"ResponseCode"`
	RequestId           string       `json:"RequestId" xml:"RequestId"`
	Segments            string       `json:"Segments" xml:"Segments"`
	ResponseDescription string       `json:"ResponseDescription" xml:"ResponseDescription"`
	From                string       `json:"From" xml:"From"`
	To                  string       `json:"To" xml:"To"`
	MessageId           string       `json:"MessageId" xml:"MessageId"`
	NumberDetail        NumberDetail `json:"NumberDetail" xml:"NumberDetail"`
}

// CreateSendMessageToGlobeRequest creates a request to invoke SendMessageToGlobe API
func CreateSendMessageToGlobeRequest() (request *SendMessageToGlobeRequest) {
	request = &SendMessageToGlobeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2018-05-01", "SendMessageToGlobe", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendMessageToGlobeResponse creates a response to parse from SendMessageToGlobe response
func CreateSendMessageToGlobeResponse() (response *SendMessageToGlobeResponse) {
	response = &SendMessageToGlobeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
