package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDedicatedBlockStorageClusterDisks invokes the ebs.DescribeDedicatedBlockStorageClusterDisks API synchronously
func (client *Client) DescribeDedicatedBlockStorageClusterDisks(request *DescribeDedicatedBlockStorageClusterDisksRequest) (response *DescribeDedicatedBlockStorageClusterDisksResponse, err error) {
	response = CreateDescribeDedicatedBlockStorageClusterDisksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDedicatedBlockStorageClusterDisksWithChan invokes the ebs.DescribeDedicatedBlockStorageClusterDisks API asynchronously
func (client *Client) DescribeDedicatedBlockStorageClusterDisksWithChan(request *DescribeDedicatedBlockStorageClusterDisksRequest) (<-chan *DescribeDedicatedBlockStorageClusterDisksResponse, <-chan error) {
	responseChan := make(chan *DescribeDedicatedBlockStorageClusterDisksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDedicatedBlockStorageClusterDisks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDedicatedBlockStorageClusterDisksWithCallback invokes the ebs.DescribeDedicatedBlockStorageClusterDisks API asynchronously
func (client *Client) DescribeDedicatedBlockStorageClusterDisksWithCallback(request *DescribeDedicatedBlockStorageClusterDisksRequest, callback func(response *DescribeDedicatedBlockStorageClusterDisksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDedicatedBlockStorageClusterDisksResponse
		var err error
		defer close(result)
		response, err = client.DescribeDedicatedBlockStorageClusterDisks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDedicatedBlockStorageClusterDisksRequest is the request struct for api DescribeDedicatedBlockStorageClusterDisks
type DescribeDedicatedBlockStorageClusterDisksRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	DbscId     string           `position:"Query" name:"DbscId"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeDedicatedBlockStorageClusterDisksResponse is the response struct for api DescribeDedicatedBlockStorageClusterDisks
type DescribeDedicatedBlockStorageClusterDisksResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	NextToken string `json:"NextToken" xml:"NextToken"`
	Disks     Disks  `json:"Disks" xml:"Disks"`
}

// CreateDescribeDedicatedBlockStorageClusterDisksRequest creates a request to invoke DescribeDedicatedBlockStorageClusterDisks API
func CreateDescribeDedicatedBlockStorageClusterDisksRequest() (request *DescribeDedicatedBlockStorageClusterDisksRequest) {
	request = &DescribeDedicatedBlockStorageClusterDisksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "DescribeDedicatedBlockStorageClusterDisks", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDedicatedBlockStorageClusterDisksResponse creates a response to parse from DescribeDedicatedBlockStorageClusterDisks response
func CreateDescribeDedicatedBlockStorageClusterDisksResponse() (response *DescribeDedicatedBlockStorageClusterDisksResponse) {
	response = &DescribeDedicatedBlockStorageClusterDisksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
