package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAclEntries invokes the ecd.DescribeAclEntries API synchronously
func (client *Client) DescribeAclEntries(request *DescribeAclEntriesRequest) (response *DescribeAclEntriesResponse, err error) {
	response = CreateDescribeAclEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAclEntriesWithChan invokes the ecd.DescribeAclEntries API asynchronously
func (client *Client) DescribeAclEntriesWithChan(request *DescribeAclEntriesRequest) (<-chan *DescribeAclEntriesResponse, <-chan error) {
	responseChan := make(chan *DescribeAclEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAclEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAclEntriesWithCallback invokes the ecd.DescribeAclEntries API asynchronously
func (client *Client) DescribeAclEntriesWithCallback(request *DescribeAclEntriesRequest, callback func(response *DescribeAclEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAclEntriesResponse
		var err error
		defer close(result)
		response, err = client.DescribeAclEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAclEntriesRequest is the request struct for api DescribeAclEntries
type DescribeAclEntriesRequest struct {
	*requests.RpcRequest
	SourceId   string           `position:"Query" name:"SourceId"`
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	SourceType string           `position:"Query" name:"SourceType"`
}

// DescribeAclEntriesResponse is the response struct for api DescribeAclEntries
type DescribeAclEntriesResponse struct {
	*responses.BaseResponse
	NextToken  string     `json:"NextToken" xml:"NextToken"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	AclEntries []AclEntry `json:"AclEntries" xml:"AclEntries"`
}

// CreateDescribeAclEntriesRequest creates a request to invoke DescribeAclEntries API
func CreateDescribeAclEntriesRequest() (request *DescribeAclEntriesRequest) {
	request = &DescribeAclEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeAclEntries", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAclEntriesResponse creates a response to parse from DescribeAclEntries response
func CreateDescribeAclEntriesResponse() (response *DescribeAclEntriesResponse) {
	response = &DescribeAclEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
