package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSubnet invokes the eflo.DeleteSubnet API synchronously
func (client *Client) DeleteSubnet(request *DeleteSubnetRequest) (response *DeleteSubnetResponse, err error) {
	response = CreateDeleteSubnetResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSubnetWithChan invokes the eflo.DeleteSubnet API asynchronously
func (client *Client) DeleteSubnetWithChan(request *DeleteSubnetRequest) (<-chan *DeleteSubnetResponse, <-chan error) {
	responseChan := make(chan *DeleteSubnetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSubnet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSubnetWithCallback invokes the eflo.DeleteSubnet API asynchronously
func (client *Client) DeleteSubnetWithCallback(request *DeleteSubnetRequest, callback func(response *DeleteSubnetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSubnetResponse
		var err error
		defer close(result)
		response, err = client.DeleteSubnet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSubnetRequest is the request struct for api DeleteSubnet
type DeleteSubnetRequest struct {
	*requests.RpcRequest
	SubnetId string `position:"Body" name:"SubnetId"`
	VpdId    string `position:"Body" name:"VpdId"`
	ZoneId   string `position:"Body" name:"ZoneId"`
}

// DeleteSubnetResponse is the response struct for api DeleteSubnet
type DeleteSubnetResponse struct {
	*responses.BaseResponse
}

// CreateDeleteSubnetRequest creates a request to invoke DeleteSubnet API
func CreateDeleteSubnetRequest() (request *DeleteSubnetRequest) {
	request = &DeleteSubnetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "DeleteSubnet", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSubnetResponse creates a response to parse from DeleteSubnet response
func CreateDeleteSubnetResponse() (response *DeleteSubnetResponse) {
	response = &DeleteSubnetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
