package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEpnInstance invokes the ens.CreateEpnInstance API synchronously
func (client *Client) CreateEpnInstance(request *CreateEpnInstanceRequest) (response *CreateEpnInstanceResponse, err error) {
	response = CreateCreateEpnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEpnInstanceWithChan invokes the ens.CreateEpnInstance API asynchronously
func (client *Client) CreateEpnInstanceWithChan(request *CreateEpnInstanceRequest) (<-chan *CreateEpnInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateEpnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEpnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEpnInstanceWithCallback invokes the ens.CreateEpnInstance API asynchronously
func (client *Client) CreateEpnInstanceWithCallback(request *CreateEpnInstanceRequest, callback func(response *CreateEpnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEpnInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateEpnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEpnInstanceRequest is the request struct for api CreateEpnInstance
type CreateEpnInstanceRequest struct {
	*requests.RpcRequest
	NetworkingModel         string           `position:"Query" name:"NetworkingModel"`
	InternetMaxBandwidthOut requests.Integer `position:"Query" name:"InternetMaxBandwidthOut"`
	EPNInstanceType         string           `position:"Query" name:"EPNInstanceType"`
	InternetChargeType      string           `position:"Query" name:"InternetChargeType"`
	EPNInstanceName         string           `position:"Query" name:"EPNInstanceName"`
}

// CreateEpnInstanceResponse is the response struct for api CreateEpnInstance
type CreateEpnInstanceResponse struct {
	*responses.BaseResponse
	EPNInstanceId string `json:"EPNInstanceId" xml:"EPNInstanceId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateEpnInstanceRequest creates a request to invoke CreateEpnInstance API
func CreateCreateEpnInstanceRequest() (request *CreateEpnInstanceRequest) {
	request = &CreateEpnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateEpnInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEpnInstanceResponse creates a response to parse from CreateEpnInstance response
func CreateCreateEpnInstanceResponse() (response *CreateEpnInstanceResponse) {
	response = &CreateEpnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
