package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceBootConfiguration invokes the ens.ModifyInstanceBootConfiguration API synchronously
func (client *Client) ModifyInstanceBootConfiguration(request *ModifyInstanceBootConfigurationRequest) (response *ModifyInstanceBootConfigurationResponse, err error) {
	response = CreateModifyInstanceBootConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceBootConfigurationWithChan invokes the ens.ModifyInstanceBootConfiguration API asynchronously
func (client *Client) ModifyInstanceBootConfigurationWithChan(request *ModifyInstanceBootConfigurationRequest) (<-chan *ModifyInstanceBootConfigurationResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceBootConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceBootConfiguration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceBootConfigurationWithCallback invokes the ens.ModifyInstanceBootConfiguration API asynchronously
func (client *Client) ModifyInstanceBootConfigurationWithCallback(request *ModifyInstanceBootConfigurationRequest, callback func(response *ModifyInstanceBootConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceBootConfigurationResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceBootConfiguration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceBootConfigurationRequest is the request struct for api ModifyInstanceBootConfiguration
type ModifyInstanceBootConfigurationRequest struct {
	*requests.RpcRequest
	DiskSet    string `position:"Query" name:"DiskSet"`
	BootType   string `position:"Query" name:"BootType"`
	BootSet    string `position:"Query" name:"BootSet"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ModifyInstanceBootConfigurationResponse is the response struct for api ModifyInstanceBootConfiguration
type ModifyInstanceBootConfigurationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceBootConfigurationRequest creates a request to invoke ModifyInstanceBootConfiguration API
func CreateModifyInstanceBootConfigurationRequest() (request *ModifyInstanceBootConfigurationRequest) {
	request = &ModifyInstanceBootConfigurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ModifyInstanceBootConfiguration", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateModifyInstanceBootConfigurationResponse creates a response to parse from ModifyInstanceBootConfiguration response
func CreateModifyInstanceBootConfigurationResponse() (response *ModifyInstanceBootConfigurationResponse) {
	response = &ModifyInstanceBootConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
