package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIns invokes the ft.CreateIns API synchronously
func (client *Client) CreateIns(request *CreateInsRequest) (response *CreateInsResponse, err error) {
	response = CreateCreateInsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInsWithChan invokes the ft.CreateIns API asynchronously
func (client *Client) CreateInsWithChan(request *CreateInsRequest) (<-chan *CreateInsResponse, <-chan error) {
	responseChan := make(chan *CreateInsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIns(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInsWithCallback invokes the ft.CreateIns API asynchronously
func (client *Client) CreateInsWithCallback(request *CreateInsRequest, callback func(response *CreateInsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInsResponse
		var err error
		defer close(result)
		response, err = client.CreateIns(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInsRequest is the request struct for api CreateIns
type CreateInsRequest struct {
	*requests.RpcRequest
	NewParam1 string `position:"Query" name:"new-param-1"`
	Bind      string `position:"Query" name:"Bind"`
	Test      string `position:"Query" name:"Test"`
	Success   string `position:"Query" name:"Success"`
	Time      string `position:"Query" name:"Time"`
	NewPala   string `position:"Query" name:"NewPala"`
}

// CreateInsResponse is the response struct for api CreateIns
type CreateInsResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Success string `json:"Success" xml:"Success"`
}

// CreateCreateInsRequest creates a request to invoke CreateIns API
func CreateCreateInsRequest() (request *CreateInsRequest) {
	request = &CreateInsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2015-03-03", "CreateIns", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateInsResponse creates a response to parse from CreateIns response
func CreateCreateInsResponse() (response *CreateInsResponse) {
	response = &CreateInsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
