package imageseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeSky invokes the imageseg.ChangeSky API synchronously
func (client *Client) ChangeSky(request *ChangeSkyRequest) (response *ChangeSkyResponse, err error) {
	response = CreateChangeSkyResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeSkyWithChan invokes the imageseg.ChangeSky API asynchronously
func (client *Client) ChangeSkyWithChan(request *ChangeSkyRequest) (<-chan *ChangeSkyResponse, <-chan error) {
	responseChan := make(chan *ChangeSkyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeSky(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeSkyWithCallback invokes the imageseg.ChangeSky API asynchronously
func (client *Client) ChangeSkyWithCallback(request *ChangeSkyRequest, callback func(response *ChangeSkyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeSkyResponse
		var err error
		defer close(result)
		response, err = client.ChangeSky(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeSkyRequest is the request struct for api ChangeSky
type ChangeSkyRequest struct {
	*requests.RpcRequest
	OssFile         string `position:"Query" name:"OssFile"`
	ReplaceImageURL string `position:"Query" name:"ReplaceImageURL"`
	RequestProxyBy  string `position:"Query" name:"RequestProxyBy"`
	ImageURL        string `position:"Query" name:"ImageURL"`
}

// ChangeSkyResponse is the response struct for api ChangeSky
type ChangeSkyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateChangeSkyRequest creates a request to invoke ChangeSky API
func CreateChangeSkyRequest() (request *ChangeSkyRequest) {
	request = &ChangeSkyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageseg", "2019-12-30", "ChangeSky", "imageseg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateChangeSkyResponse creates a response to parse from ChangeSky response
func CreateChangeSkyResponse() (response *ChangeSkyResponse) {
	response = &ChangeSkyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
