package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableVirtualMFA invokes the ims.DisableVirtualMFA API synchronously
func (client *Client) DisableVirtualMFA(request *DisableVirtualMFARequest) (response *DisableVirtualMFAResponse, err error) {
	response = CreateDisableVirtualMFAResponse()
	err = client.DoAction(request, response)
	return
}

// DisableVirtualMFAWithChan invokes the ims.DisableVirtualMFA API asynchronously
func (client *Client) DisableVirtualMFAWithChan(request *DisableVirtualMFARequest) (<-chan *DisableVirtualMFAResponse, <-chan error) {
	responseChan := make(chan *DisableVirtualMFAResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableVirtualMFA(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableVirtualMFAWithCallback invokes the ims.DisableVirtualMFA API asynchronously
func (client *Client) DisableVirtualMFAWithCallback(request *DisableVirtualMFARequest, callback func(response *DisableVirtualMFAResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableVirtualMFAResponse
		var err error
		defer close(result)
		response, err = client.DisableVirtualMFA(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableVirtualMFARequest is the request struct for api DisableVirtualMFA
type DisableVirtualMFARequest struct {
	*requests.RpcRequest
	AkProxySuffix     string `position:"Query" name:"AkProxySuffix"`
	UserPrincipalName string `position:"Query" name:"UserPrincipalName"`
}

// DisableVirtualMFAResponse is the response struct for api DisableVirtualMFA
type DisableVirtualMFAResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableVirtualMFARequest creates a request to invoke DisableVirtualMFA API
func CreateDisableVirtualMFARequest() (request *DisableVirtualMFARequest) {
	request = &DisableVirtualMFARequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "DisableVirtualMFA", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableVirtualMFAResponse creates a response to parse from DisableVirtualMFA response
func CreateDisableVirtualMFAResponse() (response *DisableVirtualMFAResponse) {
	response = &DisableVirtualMFAResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
