package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFaceUserGroup invokes the linkvisual.DeleteFaceUserGroup API synchronously
func (client *Client) DeleteFaceUserGroup(request *DeleteFaceUserGroupRequest) (response *DeleteFaceUserGroupResponse, err error) {
	response = CreateDeleteFaceUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFaceUserGroupWithChan invokes the linkvisual.DeleteFaceUserGroup API asynchronously
func (client *Client) DeleteFaceUserGroupWithChan(request *DeleteFaceUserGroupRequest) (<-chan *DeleteFaceUserGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteFaceUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFaceUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFaceUserGroupWithCallback invokes the linkvisual.DeleteFaceUserGroup API asynchronously
func (client *Client) DeleteFaceUserGroupWithCallback(request *DeleteFaceUserGroupRequest, callback func(response *DeleteFaceUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFaceUserGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteFaceUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFaceUserGroupRequest is the request struct for api DeleteFaceUserGroup
type DeleteFaceUserGroupRequest struct {
	*requests.RpcRequest
	IsolationId string `position:"Query" name:"IsolationId"`
	UserGroupId string `position:"Query" name:"UserGroupId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// DeleteFaceUserGroupResponse is the response struct for api DeleteFaceUserGroup
type DeleteFaceUserGroupResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteFaceUserGroupRequest creates a request to invoke DeleteFaceUserGroup API
func CreateDeleteFaceUserGroupRequest() (request *DeleteFaceUserGroupRequest) {
	request = &DeleteFaceUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DeleteFaceUserGroup", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteFaceUserGroupResponse creates a response to parse from DeleteFaceUserGroup response
func CreateDeleteFaceUserGroupResponse() (response *DeleteFaceUserGroupResponse) {
	response = &DeleteFaceUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
