package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDevicePictureFile invokes the linkvisual.QueryDevicePictureFile API synchronously
func (client *Client) QueryDevicePictureFile(request *QueryDevicePictureFileRequest) (response *QueryDevicePictureFileResponse, err error) {
	response = CreateQueryDevicePictureFileResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDevicePictureFileWithChan invokes the linkvisual.QueryDevicePictureFile API asynchronously
func (client *Client) QueryDevicePictureFileWithChan(request *QueryDevicePictureFileRequest) (<-chan *QueryDevicePictureFileResponse, <-chan error) {
	responseChan := make(chan *QueryDevicePictureFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDevicePictureFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDevicePictureFileWithCallback invokes the linkvisual.QueryDevicePictureFile API asynchronously
func (client *Client) QueryDevicePictureFileWithCallback(request *QueryDevicePictureFileRequest, callback func(response *QueryDevicePictureFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDevicePictureFileResponse
		var err error
		defer close(result)
		response, err = client.QueryDevicePictureFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDevicePictureFileRequest is the request struct for api QueryDevicePictureFile
type QueryDevicePictureFileRequest struct {
	*requests.RpcRequest
	PictureType   requests.Integer `position:"Query" name:"PictureType"`
	ThumbWidth    requests.Integer `position:"Query" name:"ThumbWidth"`
	IotId         string           `position:"Query" name:"IotId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ExpireTime    requests.Integer `position:"Query" name:"ExpireTime"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
	CaptureId     string           `position:"Query" name:"CaptureId"`
}

// QueryDevicePictureFileResponse is the response struct for api QueryDevicePictureFile
type QueryDevicePictureFileResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryDevicePictureFileRequest creates a request to invoke QueryDevicePictureFile API
func CreateQueryDevicePictureFileRequest() (request *QueryDevicePictureFileRequest) {
	request = &QueryDevicePictureFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryDevicePictureFile", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDevicePictureFileResponse creates a response to parse from QueryDevicePictureFile response
func CreateQueryDevicePictureFileResponse() (response *QueryDevicePictureFileResponse) {
	response = &QueryDevicePictureFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
