package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveCenterStreamRateData invokes the live.DescribeLiveCenterStreamRateData API synchronously
func (client *Client) DescribeLiveCenterStreamRateData(request *DescribeLiveCenterStreamRateDataRequest) (response *DescribeLiveCenterStreamRateDataResponse, err error) {
	response = CreateDescribeLiveCenterStreamRateDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveCenterStreamRateDataWithChan invokes the live.DescribeLiveCenterStreamRateData API asynchronously
func (client *Client) DescribeLiveCenterStreamRateDataWithChan(request *DescribeLiveCenterStreamRateDataRequest) (<-chan *DescribeLiveCenterStreamRateDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveCenterStreamRateDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveCenterStreamRateData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveCenterStreamRateDataWithCallback invokes the live.DescribeLiveCenterStreamRateData API asynchronously
func (client *Client) DescribeLiveCenterStreamRateDataWithCallback(request *DescribeLiveCenterStreamRateDataRequest, callback func(response *DescribeLiveCenterStreamRateDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveCenterStreamRateDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveCenterStreamRateData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveCenterStreamRateDataRequest is the request struct for api DescribeLiveCenterStreamRateData
type DescribeLiveCenterStreamRateDataRequest struct {
	*requests.RpcRequest
	StartTime  string `position:"Query" name:"StartTime"`
	AppName    string `position:"Query" name:"AppName"`
	StreamName string `position:"Query" name:"StreamName"`
	DomainName string `position:"Query" name:"DomainName"`
	EndTime    string `position:"Query" name:"EndTime"`
}

// DescribeLiveCenterStreamRateDataResponse is the response struct for api DescribeLiveCenterStreamRateData
type DescribeLiveCenterStreamRateDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RateDatas []Data `json:"RateDatas" xml:"RateDatas"`
}

// CreateDescribeLiveCenterStreamRateDataRequest creates a request to invoke DescribeLiveCenterStreamRateData API
func CreateDescribeLiveCenterStreamRateDataRequest() (request *DescribeLiveCenterStreamRateDataRequest) {
	request = &DescribeLiveCenterStreamRateDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveCenterStreamRateData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveCenterStreamRateDataResponse creates a response to parse from DescribeLiveCenterStreamRateData response
func CreateDescribeLiveCenterStreamRateDataResponse() (response *DescribeLiveCenterStreamRateDataResponse) {
	response = &DescribeLiveCenterStreamRateDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
