package multimediaai

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaskResult invokes the multimediaai.GetTaskResult API synchronously
// api document: https://help.aliyun.com/api/multimediaai/gettaskresult.html
func (client *Client) GetTaskResult(request *GetTaskResultRequest) (response *GetTaskResultResponse, err error) {
	response = CreateGetTaskResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaskResultWithChan invokes the multimediaai.GetTaskResult API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/gettaskresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTaskResultWithChan(request *GetTaskResultRequest) (<-chan *GetTaskResultResponse, <-chan error) {
	responseChan := make(chan *GetTaskResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaskResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaskResultWithCallback invokes the multimediaai.GetTaskResult API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/gettaskresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTaskResultWithCallback(request *GetTaskResultRequest, callback func(response *GetTaskResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaskResultResponse
		var err error
		defer close(result)
		response, err = client.GetTaskResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaskResultRequest is the request struct for api GetTaskResult
type GetTaskResultRequest struct {
	*requests.RpcRequest
	TaskId requests.Integer `position:"Query" name:"TaskId"`
}

// GetTaskResultResponse is the response struct for api GetTaskResult
type GetTaskResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Status    int    `json:"Status" xml:"Status"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetTaskResultRequest creates a request to invoke GetTaskResult API
func CreateGetTaskResultRequest() (request *GetTaskResultRequest) {
	request = &GetTaskResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("multimediaai", "2019-08-10", "GetTaskResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTaskResultResponse creates a response to parse from GetTaskResult response
func CreateGetTaskResultResponse() (response *GetTaskResultResponse) {
	response = &GetTaskResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
