package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunPreTrainServiceNew invokes the nlp_automl.RunPreTrainServiceNew API synchronously
func (client *Client) RunPreTrainServiceNew(request *RunPreTrainServiceNewRequest) (response *RunPreTrainServiceNewResponse, err error) {
	response = CreateRunPreTrainServiceNewResponse()
	err = client.DoAction(request, response)
	return
}

// RunPreTrainServiceNewWithChan invokes the nlp_automl.RunPreTrainServiceNew API asynchronously
func (client *Client) RunPreTrainServiceNewWithChan(request *RunPreTrainServiceNewRequest) (<-chan *RunPreTrainServiceNewResponse, <-chan error) {
	responseChan := make(chan *RunPreTrainServiceNewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunPreTrainServiceNew(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunPreTrainServiceNewWithCallback invokes the nlp_automl.RunPreTrainServiceNew API asynchronously
func (client *Client) RunPreTrainServiceNewWithCallback(request *RunPreTrainServiceNewRequest, callback func(response *RunPreTrainServiceNewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunPreTrainServiceNewResponse
		var err error
		defer close(result)
		response, err = client.RunPreTrainServiceNew(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunPreTrainServiceNewRequest is the request struct for api RunPreTrainServiceNew
type RunPreTrainServiceNewRequest struct {
	*requests.RpcRequest
	Product        string `position:"Body" name:"Product"`
	PredictContent string `position:"Body" name:"PredictContent"`
	ServiceVersion string `position:"Body" name:"ServiceVersion"`
	ServiceName    string `position:"Body" name:"ServiceName"`
}

// RunPreTrainServiceNewResponse is the response struct for api RunPreTrainServiceNew
type RunPreTrainServiceNewResponse struct {
	*responses.BaseResponse
	PredictResult string `json:"PredictResult" xml:"PredictResult"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	BillingCount  int    `json:"BillingCount" xml:"BillingCount"`
}

// CreateRunPreTrainServiceNewRequest creates a request to invoke RunPreTrainServiceNew API
func CreateRunPreTrainServiceNewRequest() (request *RunPreTrainServiceNewRequest) {
	request = &RunPreTrainServiceNewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-11-11", "RunPreTrainServiceNew", "", "")
	request.Method = requests.POST
	return
}

// CreateRunPreTrainServiceNewResponse creates a response to parse from RunPreTrainServiceNew response
func CreateRunPreTrainServiceNewResponse() (response *RunPreTrainServiceNewResponse) {
	response = &RunPreTrainServiceNewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
