package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetryProjectModifyRecords invokes the oceanbasepro.RetryProjectModifyRecords API synchronously
func (client *Client) RetryProjectModifyRecords(request *RetryProjectModifyRecordsRequest) (response *RetryProjectModifyRecordsResponse, err error) {
	response = CreateRetryProjectModifyRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// RetryProjectModifyRecordsWithChan invokes the oceanbasepro.RetryProjectModifyRecords API asynchronously
func (client *Client) RetryProjectModifyRecordsWithChan(request *RetryProjectModifyRecordsRequest) (<-chan *RetryProjectModifyRecordsResponse, <-chan error) {
	responseChan := make(chan *RetryProjectModifyRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetryProjectModifyRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetryProjectModifyRecordsWithCallback invokes the oceanbasepro.RetryProjectModifyRecords API asynchronously
func (client *Client) RetryProjectModifyRecordsWithCallback(request *RetryProjectModifyRecordsRequest, callback func(response *RetryProjectModifyRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetryProjectModifyRecordsResponse
		var err error
		defer close(result)
		response, err = client.RetryProjectModifyRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetryProjectModifyRecordsRequest is the request struct for api RetryProjectModifyRecords
type RetryProjectModifyRecordsRequest struct {
	*requests.RpcRequest
	Id string `position:"Body" name:"Id"`
}

// RetryProjectModifyRecordsResponse is the response struct for api RetryProjectModifyRecords
type RetryProjectModifyRecordsResponse struct {
	*responses.BaseResponse
}

// CreateRetryProjectModifyRecordsRequest creates a request to invoke RetryProjectModifyRecords API
func CreateRetryProjectModifyRecordsRequest() (request *RetryProjectModifyRecordsRequest) {
	request = &RetryProjectModifyRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "RetryProjectModifyRecords", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRetryProjectModifyRecordsResponse creates a response to parse from RetryProjectModifyRecords response
func CreateRetryProjectModifyRecordsResponse() (response *RetryProjectModifyRecordsResponse) {
	response = &RetryProjectModifyRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
