package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDialogueNodeStatistics invokes the outboundbot.DescribeDialogueNodeStatistics API synchronously
func (client *Client) DescribeDialogueNodeStatistics(request *DescribeDialogueNodeStatisticsRequest) (response *DescribeDialogueNodeStatisticsResponse, err error) {
	response = CreateDescribeDialogueNodeStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDialogueNodeStatisticsWithChan invokes the outboundbot.DescribeDialogueNodeStatistics API asynchronously
func (client *Client) DescribeDialogueNodeStatisticsWithChan(request *DescribeDialogueNodeStatisticsRequest) (<-chan *DescribeDialogueNodeStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeDialogueNodeStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDialogueNodeStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDialogueNodeStatisticsWithCallback invokes the outboundbot.DescribeDialogueNodeStatistics API asynchronously
func (client *Client) DescribeDialogueNodeStatisticsWithCallback(request *DescribeDialogueNodeStatisticsRequest, callback func(response *DescribeDialogueNodeStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDialogueNodeStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDialogueNodeStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDialogueNodeStatisticsRequest is the request struct for api DescribeDialogueNodeStatistics
type DescribeDialogueNodeStatisticsRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	JobGroupId string           `position:"Query" name:"JobGroupId"`
	Limit      requests.Integer `position:"Query" name:"Limit"`
}

// DescribeDialogueNodeStatisticsResponse is the response struct for api DescribeDialogueNodeStatistics
type DescribeDialogueNodeStatisticsResponse struct {
	*responses.BaseResponse
	HttpStatusCode        int                    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId             string                 `json:"RequestId" xml:"RequestId"`
	GroupId               string                 `json:"GroupId" xml:"GroupId"`
	Success               bool                   `json:"Success" xml:"Success"`
	TotalCompleted        int                    `json:"TotalCompleted" xml:"TotalCompleted"`
	Code                  string                 `json:"Code" xml:"Code"`
	Message               string                 `json:"Message" xml:"Message"`
	InstanceId            string                 `json:"InstanceId" xml:"InstanceId"`
	NoAnswerDialogueNodes []NoAnswerDialogueNode `json:"NoAnswerDialogueNodes" xml:"NoAnswerDialogueNodes"`
}

// CreateDescribeDialogueNodeStatisticsRequest creates a request to invoke DescribeDialogueNodeStatistics API
func CreateDescribeDialogueNodeStatisticsRequest() (request *DescribeDialogueNodeStatisticsRequest) {
	request = &DescribeDialogueNodeStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DescribeDialogueNodeStatistics", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDialogueNodeStatisticsResponse creates a response to parse from DescribeDialogueNodeStatistics response
func CreateDescribeDialogueNodeStatisticsResponse() (response *DescribeDialogueNodeStatisticsResponse) {
	response = &DescribeDialogueNodeStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
