package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLabelTable invokes the paifeaturestore.GetLabelTable API synchronously
func (client *Client) GetLabelTable(request *GetLabelTableRequest) (response *GetLabelTableResponse, err error) {
	response = CreateGetLabelTableResponse()
	err = client.DoAction(request, response)
	return
}

// GetLabelTableWithChan invokes the paifeaturestore.GetLabelTable API asynchronously
func (client *Client) GetLabelTableWithChan(request *GetLabelTableRequest) (<-chan *GetLabelTableResponse, <-chan error) {
	responseChan := make(chan *GetLabelTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLabelTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLabelTableWithCallback invokes the paifeaturestore.GetLabelTable API asynchronously
func (client *Client) GetLabelTableWithCallback(request *GetLabelTableRequest, callback func(response *GetLabelTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLabelTableResponse
		var err error
		defer close(result)
		response, err = client.GetLabelTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLabelTableRequest is the request struct for api GetLabelTable
type GetLabelTableRequest struct {
	*requests.RoaRequest
	InstanceId   string `position:"Path" name:"InstanceId"`
	LabelTableId string `position:"Path" name:"LabelTableId"`
}

// GetLabelTableResponse is the response struct for api GetLabelTable
type GetLabelTableResponse struct {
	*responses.BaseResponse
	RequestId            string   `json:"RequestId" xml:"RequestId"`
	ProjectId            string   `json:"ProjectId" xml:"ProjectId"`
	ProjectName          string   `json:"ProjectName" xml:"ProjectName"`
	DatasourceId         string   `json:"DatasourceId" xml:"DatasourceId"`
	Name                 string   `json:"Name" xml:"Name"`
	DatasourceName       string   `json:"DatasourceName" xml:"DatasourceName"`
	Owner                string   `json:"Owner" xml:"Owner"`
	GmtCreateTime        string   `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime      string   `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	RelatedModelFeatures []string `json:"RelatedModelFeatures" xml:"RelatedModelFeatures"`
	Fields               []Field  `json:"Fields" xml:"Fields"`
}

// CreateGetLabelTableRequest creates a request to invoke GetLabelTable API
func CreateGetLabelTableRequest() (request *GetLabelTableRequest) {
	request = &GetLabelTableRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "GetLabelTable", "/api/v1/instances/[InstanceId]/labeltables/[LabelTableId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetLabelTableResponse creates a response to parse from GetLabelTable response
func CreateGetLabelTableResponse() (response *GetLabelTableResponse) {
	response = &GetLabelTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
