package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddResolverEndpoint invokes the pvtz.AddResolverEndpoint API synchronously
func (client *Client) AddResolverEndpoint(request *AddResolverEndpointRequest) (response *AddResolverEndpointResponse, err error) {
	response = CreateAddResolverEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// AddResolverEndpointWithChan invokes the pvtz.AddResolverEndpoint API asynchronously
func (client *Client) AddResolverEndpointWithChan(request *AddResolverEndpointRequest) (<-chan *AddResolverEndpointResponse, <-chan error) {
	responseChan := make(chan *AddResolverEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddResolverEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddResolverEndpointWithCallback invokes the pvtz.AddResolverEndpoint API asynchronously
func (client *Client) AddResolverEndpointWithCallback(request *AddResolverEndpointRequest, callback func(response *AddResolverEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddResolverEndpointResponse
		var err error
		defer close(result)
		response, err = client.AddResolverEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddResolverEndpointRequest is the request struct for api AddResolverEndpoint
type AddResolverEndpointRequest struct {
	*requests.RpcRequest
	VpcRegionId     string                         `position:"Query" name:"VpcRegionId"`
	SecurityGroupId string                         `position:"Query" name:"SecurityGroupId"`
	VpcId           string                         `position:"Query" name:"VpcId"`
	UserClientIp    string                         `position:"Query" name:"UserClientIp"`
	Name            string                         `position:"Query" name:"Name"`
	Lang            string                         `position:"Query" name:"Lang"`
	IpConfig        *[]AddResolverEndpointIpConfig `position:"Query" name:"IpConfig"  type:"Repeated"`
}

// AddResolverEndpointIpConfig is a repeated param struct in AddResolverEndpointRequest
type AddResolverEndpointIpConfig struct {
	VSwitchId string `name:"VSwitchId"`
	Ip        string `name:"Ip"`
	CidrBlock string `name:"CidrBlock"`
	AzId      string `name:"AzId"`
}

// AddResolverEndpointResponse is the response struct for api AddResolverEndpoint
type AddResolverEndpointResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	EndpointId string `json:"EndpointId" xml:"EndpointId"`
}

// CreateAddResolverEndpointRequest creates a request to invoke AddResolverEndpoint API
func CreateAddResolverEndpointRequest() (request *AddResolverEndpointRequest) {
	request = &AddResolverEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "AddResolverEndpoint", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddResolverEndpointResponse creates a response to parse from AddResolverEndpoint response
func CreateAddResolverEndpointResponse() (response *AddResolverEndpointResponse) {
	response = &AddResolverEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
