package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserClusters invokes the qianzhou.ListUserClusters API synchronously
func (client *Client) ListUserClusters(request *ListUserClustersRequest) (response *ListUserClustersResponse, err error) {
	response = CreateListUserClustersResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserClustersWithChan invokes the qianzhou.ListUserClusters API asynchronously
func (client *Client) ListUserClustersWithChan(request *ListUserClustersRequest) (<-chan *ListUserClustersResponse, <-chan error) {
	responseChan := make(chan *ListUserClustersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserClusters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserClustersWithCallback invokes the qianzhou.ListUserClusters API asynchronously
func (client *Client) ListUserClustersWithCallback(request *ListUserClustersRequest, callback func(response *ListUserClustersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserClustersResponse
		var err error
		defer close(result)
		response, err = client.ListUserClusters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserClustersRequest is the request struct for api ListUserClusters
type ListUserClustersRequest struct {
	*requests.RoaRequest
	Current  string `position:"Query" name:"current"`
	PageSize string `position:"Query" name:"pageSize"`
	UserID   string `position:"Query" name:"userID"`
}

// ListUserClustersResponse is the response struct for api ListUserClusters
type ListUserClustersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Msg       string `json:"msg" xml:"msg"`
	Data      string `json:"data" xml:"data"`
	Code      int64  `json:"code" xml:"code"`
}

// CreateListUserClustersRequest creates a request to invoke ListUserClusters API
func CreateListUserClustersRequest() (request *ListUserClustersRequest) {
	request = &ListUserClustersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "ListUserClusters", "/popapi/listUserClusters", "", "")
	request.Method = requests.GET
	return
}

// CreateListUserClustersResponse creates a response to parse from ListUserClusters response
func CreateListUserClustersResponse() (response *ListUserClustersResponse) {
	response = &ListUserClustersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
