package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartTairKVCacheCustomInstance invokes the r_kvstore.RestartTairKVCacheCustomInstance API synchronously
func (client *Client) RestartTairKVCacheCustomInstance(request *RestartTairKVCacheCustomInstanceRequest) (response *RestartTairKVCacheCustomInstanceResponse, err error) {
	response = CreateRestartTairKVCacheCustomInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RestartTairKVCacheCustomInstanceWithChan invokes the r_kvstore.RestartTairKVCacheCustomInstance API asynchronously
func (client *Client) RestartTairKVCacheCustomInstanceWithChan(request *RestartTairKVCacheCustomInstanceRequest) (<-chan *RestartTairKVCacheCustomInstanceResponse, <-chan error) {
	responseChan := make(chan *RestartTairKVCacheCustomInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartTairKVCacheCustomInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartTairKVCacheCustomInstanceWithCallback invokes the r_kvstore.RestartTairKVCacheCustomInstance API asynchronously
func (client *Client) RestartTairKVCacheCustomInstanceWithCallback(request *RestartTairKVCacheCustomInstanceRequest, callback func(response *RestartTairKVCacheCustomInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartTairKVCacheCustomInstanceResponse
		var err error
		defer close(result)
		response, err = client.RestartTairKVCacheCustomInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartTairKVCacheCustomInstanceRequest is the request struct for api RestartTairKVCacheCustomInstance
type RestartTairKVCacheCustomInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// RestartTairKVCacheCustomInstanceResponse is the response struct for api RestartTairKVCacheCustomInstance
type RestartTairKVCacheCustomInstanceResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
	TaskId     string `json:"TaskId" xml:"TaskId"`
}

// CreateRestartTairKVCacheCustomInstanceRequest creates a request to invoke RestartTairKVCacheCustomInstance API
func CreateRestartTairKVCacheCustomInstanceRequest() (request *RestartTairKVCacheCustomInstanceRequest) {
	request = &RestartTairKVCacheCustomInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "RestartTairKVCacheCustomInstance", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestartTairKVCacheCustomInstanceResponse creates a response to parse from RestartTairKVCacheCustomInstance response
func CreateRestartTairKVCacheCustomInstanceResponse() (response *RestartTairKVCacheCustomInstanceResponse) {
	response = &RestartTairKVCacheCustomInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
