package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportMarketingAudienceToOSS invokes the retailadvqa_public.ExportMarketingAudienceToOSS API synchronously
func (client *Client) ExportMarketingAudienceToOSS(request *ExportMarketingAudienceToOSSRequest) (response *ExportMarketingAudienceToOSSResponse, err error) {
	response = CreateExportMarketingAudienceToOSSResponse()
	err = client.DoAction(request, response)
	return
}

// ExportMarketingAudienceToOSSWithChan invokes the retailadvqa_public.ExportMarketingAudienceToOSS API asynchronously
func (client *Client) ExportMarketingAudienceToOSSWithChan(request *ExportMarketingAudienceToOSSRequest) (<-chan *ExportMarketingAudienceToOSSResponse, <-chan error) {
	responseChan := make(chan *ExportMarketingAudienceToOSSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportMarketingAudienceToOSS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportMarketingAudienceToOSSWithCallback invokes the retailadvqa_public.ExportMarketingAudienceToOSS API asynchronously
func (client *Client) ExportMarketingAudienceToOSSWithCallback(request *ExportMarketingAudienceToOSSRequest, callback func(response *ExportMarketingAudienceToOSSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportMarketingAudienceToOSSResponse
		var err error
		defer close(result)
		response, err = client.ExportMarketingAudienceToOSS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportMarketingAudienceToOSSRequest is the request struct for api ExportMarketingAudienceToOSS
type ExportMarketingAudienceToOSSRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Query" name:"AccessId"`
	AudienceId  string `position:"Query" name:"AudienceId"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// ExportMarketingAudienceToOSSResponse is the response struct for api ExportMarketingAudienceToOSS
type ExportMarketingAudienceToOSSResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateExportMarketingAudienceToOSSRequest creates a request to invoke ExportMarketingAudienceToOSS API
func CreateExportMarketingAudienceToOSSRequest() (request *ExportMarketingAudienceToOSSRequest) {
	request = &ExportMarketingAudienceToOSSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ExportMarketingAudienceToOSS", "", "")
	request.Method = requests.POST
	return
}

// CreateExportMarketingAudienceToOSSResponse creates a response to parse from ExportMarketingAudienceToOSS response
func CreateExportMarketingAudienceToOSSResponse() (response *ExportMarketingAudienceToOSSResponse) {
	response = &ExportMarketingAudienceToOSSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
