package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyOpenLogShipper invokes the sas.ModifyOpenLogShipper API synchronously
func (client *Client) ModifyOpenLogShipper(request *ModifyOpenLogShipperRequest) (response *ModifyOpenLogShipperResponse, err error) {
	response = CreateModifyOpenLogShipperResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyOpenLogShipperWithChan invokes the sas.ModifyOpenLogShipper API asynchronously
func (client *Client) ModifyOpenLogShipperWithChan(request *ModifyOpenLogShipperRequest) (<-chan *ModifyOpenLogShipperResponse, <-chan error) {
	responseChan := make(chan *ModifyOpenLogShipperResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyOpenLogShipper(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyOpenLogShipperWithCallback invokes the sas.ModifyOpenLogShipper API asynchronously
func (client *Client) ModifyOpenLogShipperWithCallback(request *ModifyOpenLogShipperRequest, callback func(response *ModifyOpenLogShipperResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyOpenLogShipperResponse
		var err error
		defer close(result)
		response, err = client.ModifyOpenLogShipper(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyOpenLogShipperRequest is the request struct for api ModifyOpenLogShipper
type ModifyOpenLogShipperRequest struct {
	*requests.RpcRequest
	LogMetaList    *[]ModifyOpenLogShipperLogMetaList `position:"Query" name:"LogMetaList"  type:"Repeated"`
	Ttl            requests.Integer                   `position:"Query" name:"Ttl"`
	SourceIp       string                             `position:"Query" name:"SourceIp"`
	HotTtl         requests.Integer                   `position:"Query" name:"HotTtl"`
	From           string                             `position:"Query" name:"From"`
	TargetRegionId string                             `position:"Query" name:"TargetRegionId"`
}

// ModifyOpenLogShipperLogMetaList is a repeated param struct in ModifyOpenLogShipperRequest
type ModifyOpenLogShipperLogMetaList struct {
	HotTtl         string `name:"HotTtl"`
	Ttl            string `name:"Ttl"`
	ConfigLogStore string `name:"ConfigLogStore"`
	Status         string `name:"Status"`
}

// ModifyOpenLogShipperResponse is the response struct for api ModifyOpenLogShipper
type ModifyOpenLogShipperResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyOpenLogShipperRequest creates a request to invoke ModifyOpenLogShipper API
func CreateModifyOpenLogShipperRequest() (request *ModifyOpenLogShipperRequest) {
	request = &ModifyOpenLogShipperRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ModifyOpenLogShipper", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyOpenLogShipperResponse creates a response to parse from ModifyOpenLogShipper response
func CreateModifyOpenLogShipperResponse() (response *ModifyOpenLogShipperResponse) {
	response = &ModifyOpenLogShipperResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
